/*
 * Decompiled with CFR 0.152.
 */
package org.kc7bfi.jflac.frame;

import java.io.IOException;
import org.kc7bfi.jflac.ChannelData;
import org.kc7bfi.jflac.LPCPredictor;
import org.kc7bfi.jflac.frame.Channel;
import org.kc7bfi.jflac.frame.EntropyCodingMethod;
import org.kc7bfi.jflac.frame.EntropyPartitionedRice;
import org.kc7bfi.jflac.frame.Header;
import org.kc7bfi.jflac.io.BitInputStream;
import org.kc7bfi.jflac.util.BitMath;

public class ChannelLPC
extends Channel {
    private static final int SUBFRAME_LPC_QLP_COEFF_PRECISION_LEN = 4;
    private static final int SUBFRAME_LPC_QLP_SHIFT_LEN = 5;
    private static final int MAX_LPC_ORDER = 32;
    private EntropyCodingMethod entropyCodingMethod;
    private int order;
    private int qlpCoeffPrecision;
    private int quantizationLevel;
    private int[] qlpCoeff = new int[32];
    private int[] warmup = new int[32];
    private int[] residual;

    public ChannelLPC(BitInputStream is, Header header, ChannelData channelData, int bps, int wastedBits, int order) throws IOException {
        super(header, wastedBits);
        this.residual = channelData.getResidual();
        this.order = order;
        int u = 0;
        while (u < order) {
            this.warmup[u] = is.readRawInt(bps);
            ++u;
        }
        int u32 = is.readRawUInt(4);
        if (u32 == 15) {
            throw new IOException("STREAM_DECODER_ERROR_STATUS_LOST_SYNC");
        }
        this.qlpCoeffPrecision = u32 + 1;
        this.quantizationLevel = is.readRawInt(5);
        int u2 = 0;
        while (u2 < order) {
            this.qlpCoeff[u2] = is.readRawInt(this.qlpCoeffPrecision);
            ++u2;
        }
        int codingType = is.readRawUInt(2);
        switch (codingType) {
            case 0: {
                this.entropyCodingMethod = new EntropyPartitionedRice();
                ((EntropyPartitionedRice)this.entropyCodingMethod).order = is.readRawUInt(4);
                ((EntropyPartitionedRice)this.entropyCodingMethod).contents = channelData.getPartitionedRiceContents();
                break;
            }
            default: {
                throw new IOException("STREAM_DECODER_UNPARSEABLE_STREAM");
            }
        }
        if (this.entropyCodingMethod instanceof EntropyPartitionedRice) {
            ((EntropyPartitionedRice)this.entropyCodingMethod).readResidual(is, order, ((EntropyPartitionedRice)this.entropyCodingMethod).order, header, channelData.getResidual());
        }
        System.arraycopy(this.warmup, 0, channelData.getOutput(), 0, order);
        if (bps + this.qlpCoeffPrecision + BitMath.ilog2(order) <= 32) {
            if (bps <= 16 && this.qlpCoeffPrecision <= 16) {
                LPCPredictor.restoreSignal(channelData.getResidual(), header.blockSize - order, this.qlpCoeff, order, this.quantizationLevel, channelData.getOutput(), order);
            } else {
                LPCPredictor.restoreSignal(channelData.getResidual(), header.blockSize - order, this.qlpCoeff, order, this.quantizationLevel, channelData.getOutput(), order);
            }
        } else {
            LPCPredictor.restoreSignalWide(channelData.getResidual(), header.blockSize - order, this.qlpCoeff, order, this.quantizationLevel, channelData.getOutput(), order);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ChannelLPC: Order=" + this.order + " WastedBits=" + this.wastedBits);
        sb.append(" qlpCoeffPrecision=" + this.qlpCoeffPrecision + " quantizationLevel=" + this.quantizationLevel);
        sb.append("\n\t\tqlpCoeff: ");
        int i = 0;
        while (i < this.order) {
            sb.append(String.valueOf(this.qlpCoeff[i]) + " ");
            ++i;
        }
        sb.append("\n\t\tWarmup: ");
        i = 0;
        while (i < this.order) {
            sb.append(String.valueOf(this.warmup[i]) + " ");
            ++i;
        }
        sb.append("\n\t\tParameter: ");
        i = 0;
        while (i < 1 << ((EntropyPartitionedRice)this.entropyCodingMethod).order) {
            sb.append(String.valueOf(((EntropyPartitionedRice)this.entropyCodingMethod).contents.parameters[i]) + " ");
            ++i;
        }
        return sb.toString();
    }
}

