/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.datatype;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import org.jaudiotagger.tag.InvalidDataTypeException;
import org.jaudiotagger.tag.datatype.AbstractString;
import org.jaudiotagger.tag.id3.AbstractTagFrameBody;
import org.jaudiotagger.tag.id3.valuepair.TextEncoding;

public class StringFixedLength
extends AbstractString {
    public StringFixedLength(String identifier, AbstractTagFrameBody frameBody, int size) {
        super(identifier, frameBody);
        if (size < 0) {
            throw new IllegalArgumentException("size is less than zero: " + size);
        }
        this.setSize(size);
    }

    public StringFixedLength(StringFixedLength copyObject) {
        super(copyObject);
        this.size = copyObject.size;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof StringFixedLength)) {
            return false;
        }
        StringFixedLength object = (StringFixedLength)obj;
        if (this.size != object.size) {
            return false;
        }
        return super.equals(obj);
    }

    @Override
    public void readByteArray(byte[] arr, int offset) throws InvalidDataTypeException {
        try {
            String charSetName = this.getTextEncodingCharSet();
            CharsetDecoder decoder = Charset.forName(charSetName).newDecoder();
            if (arr.length - offset < this.size) {
                throw new InvalidDataTypeException("byte array is to small to retrieve string of declared length:" + this.size);
            }
            String str = decoder.decode(ByteBuffer.wrap(arr, offset, this.size)).toString();
            if (str == null) {
                throw new NullPointerException("String is null");
            }
            this.value = str;
        }
        catch (CharacterCodingException ce) {
            this.value = "";
        }
    }

    @Override
    public byte[] writeByteArray() {
        ByteBuffer dataBuffer = null;
        if (this.value == null) {
            byte[] data = new byte[this.size];
            for (int i = 0; i < this.size; ++i) {
                data[i] = 32;
            }
            return data;
        }
        try {
            CharsetEncoder encoder;
            String charSetName = this.getTextEncodingCharSet();
            if (charSetName.equals("UTF-16")) {
                charSetName = "UTF-16LE";
                encoder = Charset.forName(charSetName).newEncoder();
                dataBuffer = encoder.encode(CharBuffer.wrap('\ufeff' + (String)this.value));
            } else {
                encoder = Charset.forName(charSetName).newEncoder();
                dataBuffer = encoder.encode(CharBuffer.wrap((String)this.value));
            }
        }
        catch (CharacterCodingException ce) {
            byte[] data = new byte[this.size];
            for (int i = 0; i < this.size; ++i) {
                data[i] = 32;
            }
            return data;
        }
        if (dataBuffer != null) {
            if (dataBuffer.limit() == this.size) {
                byte[] data = new byte[dataBuffer.limit()];
                dataBuffer.get(data, 0, dataBuffer.limit());
                return data;
            }
            if (dataBuffer.limit() > this.size) {
                byte[] data = new byte[this.size];
                dataBuffer.get(data, 0, this.size);
                return data;
            }
            byte[] data = new byte[this.size];
            dataBuffer.get(data, 0, dataBuffer.limit());
            for (int i = dataBuffer.limit(); i < this.size; ++i) {
                data[i] = 32;
            }
            return data;
        }
        byte[] data = new byte[this.size];
        for (int i = 0; i < this.size; ++i) {
            data[i] = 32;
        }
        return data;
    }

    protected String getTextEncodingCharSet() {
        byte textEncoding = this.getBody().getTextEncoding();
        String charSetName = TextEncoding.getInstanceOf().getValueForId(textEncoding);
        return charSetName;
    }
}

