/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages.vendor;

import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.vendor.AbstractVendorMessage;
import java.io.IOException;
import java.io.OutputStream;
import org.limewire.util.ByteUtils;

public final class HopsFlowVendorMessage
extends AbstractVendorMessage {
    public static final int VERSION = 1;

    HopsFlowVendorMessage(byte[] guid, byte ttl, byte hops, int version, byte[] payload, Message.Network network) throws BadPacketException {
        super(guid, ttl, hops, F_BEAR_VENDOR_ID, 4, version, payload, network);
        if (this.getVersion() > 1) {
            throw new BadPacketException("UNSUPPORTED VERSION");
        }
        if (this.getPayload().length != 1) {
            throw new BadPacketException("UNSUPPORTED PAYLOAD LENGTH: " + this.getPayload().length);
        }
    }

    public HopsFlowVendorMessage(byte hopVal) {
        super(F_BEAR_VENDOR_ID, 4, 1, HopsFlowVendorMessage.derivePayload(hopVal));
    }

    public int getHopValue() {
        return ByteUtils.ubyte2int(this.getPayload()[0]);
    }

    private static byte[] derivePayload(byte hopVal) {
        byte[] payload = new byte[]{hopVal};
        return payload;
    }

    @Override
    protected void writePayload(OutputStream out) throws IOException {
        super.writePayload(out);
    }
}

