/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.messages.QueryReplyFactory;
import com.limegroup.gnutella.simpp.SimppListener;
import com.limegroup.gnutella.simpp.SimppManager;
import com.limegroup.gnutella.util.Data;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.core.settings.SearchSettings;
import org.limewire.i18n.I18nMarker;
import org.limewire.inject.EagerSingleton;
import org.limewire.io.IOUtils;
import org.limewire.lifecycle.Service;
import org.limewire.lifecycle.ServiceRegistry;
import org.limewire.util.Base32;

@EagerSingleton
public final class StaticMessages
implements Service {
    private static final Log LOG = LogFactory.getLog(StaticMessages.class);
    private volatile QueryReply limeReply;
    private final QueryReplyFactory queryReplyFactory;
    private final Provider<SimppManager> simppManager;

    @Inject
    public StaticMessages(QueryReplyFactory queryReplyFactory, Provider<SimppManager> simppManager) {
        this.queryReplyFactory = queryReplyFactory;
        this.simppManager = simppManager;
    }

    @Inject
    void register(ServiceRegistry registry) {
        registry.register(this);
    }

    @Override
    public String getServiceName() {
        return I18nMarker.marktr("Static Messages");
    }

    @Override
    public void initialize() {
    }

    @Override
    public void stop() {
    }

    @Override
    public void start() {
        this.reloadMessages();
        this.simppManager.get().addListener(new SimppListener(){

            @Override
            public void simppUpdated(int newVersion) {
                StaticMessages.this.reloadMessages();
            }
        });
    }

    private void reloadMessages() {
        this.limeReply = this.createLimeReply();
    }

    private QueryReply createLimeReply() {
        byte[] reply = Base32.decode(SearchSettings.LIME_SIGNED_RESPONSE.get());
        return this.createReply(new ByteArrayInputStream(reply));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QueryReply createReply(InputStream source) {
        QueryReply queryReply;
        ObjectInputStream in = null;
        try {
            in = new ObjectInputStream(source);
            byte[] payload = ((Data)in.readObject()).data;
            queryReply = this.queryReplyFactory.createFromNetwork(new byte[16], (byte)1, (byte)0, payload);
        }
        catch (Throwable t) {
            QueryReply queryReply2;
            try {
                LOG.error("Unable to read serialized data", t);
                queryReply2 = null;
            }
            catch (Throwable throwable) {
                IOUtils.close(in);
                throw throwable;
            }
            IOUtils.close(in);
            return queryReply2;
        }
        IOUtils.close(in);
        return queryReply;
    }

    public QueryReply getLimeReply() {
        return this.limeReply;
    }
}

