/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.HostCatcher;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.Statistics;
import com.limegroup.gnutella.dht.DHTManager;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.LocalPongInfo;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.PingReply;
import com.limegroup.gnutella.messages.PingReplyFactory;
import com.limegroup.gnutella.messages.PingReplyImpl;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import org.limewire.collection.BitNumbers;
import org.limewire.core.settings.ApplicationSettings;
import org.limewire.io.BadGGEPBlockException;
import org.limewire.io.BadGGEPPropertyException;
import org.limewire.io.GGEP;
import org.limewire.io.IpPort;
import org.limewire.io.NetworkInstanceUtils;
import org.limewire.io.NetworkUtils;
import org.limewire.security.AddressSecurityToken;
import org.limewire.security.MACCalculatorRepositoryManager;
import org.limewire.service.ErrorService;
import org.limewire.util.ByteUtils;
import org.limewire.util.StringUtils;

@Singleton
public class PingReplyFactoryImpl
implements PingReplyFactory {
    private final NetworkManager networkManager;
    private final Provider<Statistics> statistics;
    private final Provider<ConnectionManager> connectionManager;
    private final Provider<HostCatcher> hostCatcher;
    private final Provider<DHTManager> dhtManager;
    private final LocalPongInfo localPongInfo;
    private final MACCalculatorRepositoryManager macCalculatorRepositoryManager;
    private final NetworkInstanceUtils networkInstanceUtils;

    @Inject
    public PingReplyFactoryImpl(NetworkManager networkManager, Provider<Statistics> statistics, Provider<ConnectionManager> connectionManager, Provider<HostCatcher> hostCatcher, Provider<DHTManager> dhtManager, LocalPongInfo localPongInfo, MACCalculatorRepositoryManager MACCalculatorRepositoryManager2, NetworkInstanceUtils networkInstanceUtils) {
        this.networkManager = networkManager;
        this.statistics = statistics;
        this.connectionManager = connectionManager;
        this.hostCatcher = hostCatcher;
        this.dhtManager = dhtManager;
        this.localPongInfo = localPongInfo;
        this.macCalculatorRepositoryManager = MACCalculatorRepositoryManager2;
        this.networkInstanceUtils = networkInstanceUtils;
    }

    @Override
    public PingReply create(byte[] guid, byte ttl, Collection<? extends IpPort> gnutHosts, Collection<? extends IpPort> dhtHosts) {
        return this.create(guid, ttl, this.networkManager.getPort(), this.networkManager.getAddress(), this.localPongInfo.getNumSharedFiles(), this.localPongInfo.getSharedFileSize() / 1024, this.localPongInfo.isSupernode(), this.statistics.get().calculateDailyUptime(), this.networkManager.isGUESSCapable(), ApplicationSettings.LANGUAGE.get().equals("") ? ApplicationSettings.DEFAULT_LOCALE.get() : ApplicationSettings.LANGUAGE.get(), this.connectionManager.get().getNumLimeWireLocalePrefSlots(), gnutHosts, dhtHosts);
    }

    @Override
    public PingReply create(byte[] guid, byte ttl) {
        return this.create(guid, ttl, IpPort.EMPTY_LIST, IpPort.EMPTY_LIST);
    }

    @Override
    public PingReply create(byte[] guid, byte ttl, IpPort addr) {
        return this.create(guid, ttl, addr, IpPort.EMPTY_LIST, IpPort.EMPTY_LIST);
    }

    @Override
    public PingReply create(byte[] guid, byte ttl, int localPort, byte[] localIp, IpPort addr) {
        return this.create(guid, ttl, localPort, localIp, addr, IpPort.EMPTY_LIST, IpPort.EMPTY_LIST);
    }

    @Override
    public PingReply create(byte[] guid, byte ttl, IpPort returnAddr, Collection<? extends IpPort> gnutHosts, Collection<? extends IpPort> dhtHosts) {
        return this.create(guid, ttl, this.networkManager.getPort(), this.networkManager.getAddress(), returnAddr, gnutHosts, dhtHosts);
    }

    @Override
    public PingReply create(byte[] guid, byte ttl, int localPort, byte[] localIP, IpPort returnAddr, Collection<? extends IpPort> gnutHosts, Collection<? extends IpPort> dhtHosts) {
        GGEP ggep = this.newGGEP(this.statistics.get().calculateDailyUptime(), this.localPongInfo.isSupernode(), this.networkManager.isGUESSCapable());
        String locale = ApplicationSettings.LANGUAGE.get().equals("") ? ApplicationSettings.DEFAULT_LOCALE.get() : ApplicationSettings.LANGUAGE.get();
        this.addLocale(ggep, locale, this.connectionManager.get().getNumLimeWireLocalePrefSlots());
        this.addAddress(ggep, returnAddr);
        this.addPackedHosts(ggep, gnutHosts, dhtHosts);
        return this.create(guid, ttl, localPort, localIP, this.localPongInfo.getNumSharedFiles(), this.localPongInfo.getSharedFileSize() / 1024, this.localPongInfo.isSupernode(), ggep);
    }

    @Override
    public PingReply createQueryKeyReply(byte[] guid, byte ttl, AddressSecurityToken key) {
        return this.create(guid, ttl, this.networkManager.getPort(), this.networkManager.getAddress(), this.localPongInfo.getNumSharedFiles(), this.localPongInfo.getSharedFileSize() / 1024, this.localPongInfo.isSupernode(), this.qkGGEP(key));
    }

    @Override
    public PingReply createQueryKeyReply(byte[] guid, byte ttl, int port, byte[] ip, long sharedFiles, long sharedSize, boolean ultrapeer, AddressSecurityToken key) {
        return this.create(guid, ttl, port, ip, sharedFiles, sharedSize, ultrapeer, this.qkGGEP(key));
    }

    @Override
    public PingReply create(byte[] guid, byte ttl, int port, byte[] address) {
        return this.create(guid, ttl, port, address, 0L, 0L, false, -1, false);
    }

    @Override
    public PingReply createExternal(byte[] guid, byte ttl, int port, byte[] address, boolean ultrapeer) {
        return this.create(guid, ttl, port, address, 0L, 0L, ultrapeer, -1, false);
    }

    @Override
    public PingReply createExternal(byte[] guid, byte ttl, int port, byte[] address, int uptime, boolean ultrapeer) {
        return this.create(guid, ttl, port, address, 0L, 0L, ultrapeer, uptime, false);
    }

    @Override
    public PingReply createGUESSReply(byte[] guid, byte ttl, Endpoint ep) throws UnknownHostException {
        return this.create(guid, ttl, ep.getPort(), ep.getHostBytes(), 0L, 0L, true, -1, true);
    }

    @Override
    public PingReply createGUESSReply(byte[] guid, byte ttl, int port, byte[] address) {
        return this.create(guid, ttl, port, address, 0L, 0L, true, -1, true);
    }

    @Override
    public PingReply create(byte[] guid, byte ttl, int port, byte[] ip, long files, long kbytes) {
        return this.create(guid, ttl, port, ip, files, kbytes, false, -1, false);
    }

    @Override
    public PingReply create(byte[] guid, byte ttl, int port, byte[] ip, long files, long kbytes, boolean isUltrapeer, int dailyUptime, boolean isGUESSCapable) {
        return this.create(guid, ttl, port, ip, files, kbytes, isUltrapeer, this.newGGEP(dailyUptime, isUltrapeer, isGUESSCapable));
    }

    @Override
    public PingReply create(byte[] guid, byte ttl, int port, byte[] ip, long files, long kbytes, boolean isUltrapeer, int dailyUptime, boolean isGuessCapable, String locale, int slots) {
        return this.create(guid, ttl, port, ip, files, kbytes, isUltrapeer, dailyUptime, isGuessCapable, locale, slots, IpPort.EMPTY_LIST, IpPort.EMPTY_LIST);
    }

    @Override
    public PingReply create(byte[] guid, byte ttl, int port, byte[] ip, long files, long kbytes, boolean isUltrapeer, int dailyUptime, boolean isGuessCapable, String locale, int slots, Collection<? extends IpPort> gnutHosts, Collection<? extends IpPort> dhtHosts) {
        GGEP ggep = this.newGGEP(dailyUptime, isUltrapeer, isGuessCapable);
        this.addLocale(ggep, locale, slots);
        this.addPackedHosts(ggep, gnutHosts, dhtHosts);
        return this.create(guid, ttl, port, ip, files, kbytes, isUltrapeer, ggep);
    }

    @Override
    public PingReply create(byte[] guid, byte ttl, int port, byte[] ipBytes, long files, long kbytes, boolean isUltrapeer, GGEP ggep) {
        if (!NetworkUtils.isValidPort(port)) {
            throw new IllegalArgumentException("invalid port: " + port);
        }
        if (!NetworkUtils.isValidAddress(ipBytes)) {
            throw new IllegalArgumentException("invalid address: " + NetworkUtils.ip2string(ipBytes));
        }
        InetAddress ip = null;
        try {
            ip = InetAddress.getByName(NetworkUtils.ip2string(ipBytes));
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(e);
        }
        byte[] extensions = null;
        if (ggep != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                ggep.write(baos);
            }
            catch (IOException e) {
                ErrorService.error(e);
            }
            extensions = baos.toByteArray();
        }
        int length = 14 + (extensions == null ? 0 : extensions.length);
        byte[] payload = new byte[length];
        ByteUtils.short2leb((short)port, payload, 0);
        payload[2] = ipBytes[0];
        payload[3] = ipBytes[1];
        payload[4] = ipBytes[2];
        payload[5] = ipBytes[3];
        ByteUtils.int2leb((int)files, payload, 6);
        ByteUtils.int2leb((int)(isUltrapeer ? this.mark(kbytes) : kbytes), payload, 10);
        if (extensions != null) {
            System.arraycopy(extensions, 0, payload, 14, extensions.length);
        }
        try {
            return new PingReplyImpl(guid, ttl, 0, payload, ggep, ip, Message.Network.UNKNOWN, this.macCalculatorRepositoryManager, this.networkInstanceUtils);
        }
        catch (BadPacketException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public PingReply createFromNetwork(byte[] guid, byte ttl, byte hops, byte[] payload) throws BadPacketException {
        return this.createFromNetwork(guid, ttl, hops, payload, Message.Network.UNKNOWN);
    }

    @Override
    public PingReply createFromNetwork(byte[] guid, byte ttl, byte hops, byte[] payload, Message.Network network) throws BadPacketException {
        if (guid == null) {
            throw new NullPointerException("null guid");
        }
        if (payload == null) {
            throw new NullPointerException("null payload");
        }
        if (payload.length < 14) {
            throw new BadPacketException("invalid payload length");
        }
        int port = ByteUtils.ushort2int(ByteUtils.leb2short(payload, 0));
        if (!NetworkUtils.isValidPort(port)) {
            throw new BadPacketException("invalid port: " + port);
        }
        String ipString = NetworkUtils.ip2string(payload, 2);
        InetAddress ip = null;
        GGEP ggep = this.parseGGEP(payload);
        if (ggep != null) {
            if (ggep.hasKey("LOC")) {
                try {
                    ggep.getBytes("LOC");
                }
                catch (BadGGEPPropertyException e) {
                    throw new BadPacketException("GGEP error : creating from network : client locale");
                }
            }
            if (ggep.hasKey("IPP")) {
                byte[] data = null;
                try {
                    data = ggep.getBytes("IPP");
                }
                catch (BadGGEPPropertyException bad) {
                    throw new BadPacketException(bad.getMessage());
                }
                if (data == null || data.length % 6 != 0) {
                    throw new BadPacketException("invalid data");
                }
            }
            if (ggep.hasKey("PHC")) {
                try {
                    ggep.getBytes("PHC");
                }
                catch (BadGGEPPropertyException bad) {
                    throw new BadPacketException(bad.getMessage());
                }
            }
            if (ggep.hasKey("UDPHC")) {
                try {
                    String dns = ggep.getString("UDPHC");
                    ip = InetAddress.getByName(dns);
                    ipString = ip.getHostAddress();
                }
                catch (BadGGEPPropertyException ignored) {
                }
                catch (UnknownHostException bad) {
                    throw new BadPacketException(bad.getMessage());
                }
            }
        }
        if (!NetworkUtils.isValidAddress(ipString)) {
            throw new BadPacketException("invalid address: " + ipString);
        }
        if (ip == null) {
            try {
                ip = InetAddress.getByName(NetworkUtils.ip2string(payload, 2));
            }
            catch (UnknownHostException e) {
                throw new BadPacketException("bad IP:" + ipString + " " + e.getMessage());
            }
        }
        return new PingReplyImpl(guid, ttl, hops, payload, ggep, ip, network, this.macCalculatorRepositoryManager, this.networkInstanceUtils);
    }

    @Override
    public PingReply mutateGUID(PingReply pingReply, byte[] guid) {
        if (guid.length != 16) {
            throw new IllegalArgumentException("bad guid size: " + guid.length);
        }
        try {
            return this.createFromNetwork(guid, pingReply.getTTL(), pingReply.getHops(), pingReply.getPayload(), pingReply.getNetwork());
        }
        catch (BadPacketException ioe) {
            throw new IllegalArgumentException("Input pong was bad!");
        }
    }

    private GGEP newGGEP(int dailyUptime, boolean isUltrapeer, boolean isGUESSCapable) {
        GGEP ggep = new GGEP();
        if (dailyUptime >= 0) {
            ggep.put("DU", dailyUptime);
        }
        if (isGUESSCapable && isUltrapeer) {
            ggep.put("GUE");
        }
        if (isUltrapeer) {
            this.addUltrapeerExtension(ggep);
        }
        this.addDHTExtension(ggep);
        if (this.networkManager.isIncomingTLSEnabled()) {
            ggep.put("TLS");
        }
        return ggep;
    }

    private GGEP qkGGEP(AddressSecurityToken addressSecurityToken) {
        try {
            GGEP ggep = new GGEP();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            addressSecurityToken.write(baos);
            ggep.put("QK", baos.toByteArray());
            return ggep;
        }
        catch (IOException e) {
            throw new IllegalStateException("Couldn't encode AddressSecurityToken" + addressSecurityToken, e);
        }
    }

    private GGEP addLocale(GGEP ggep, String locale, int slots) {
        byte[] payload = new byte[3];
        byte[] s = StringUtils.toAsciiBytes(locale);
        payload[0] = s[0];
        payload[1] = s[1];
        payload[2] = (byte)slots;
        ggep.put("LOC", payload);
        return ggep;
    }

    private GGEP addAddress(GGEP ggep, IpPort address) {
        byte[] payload = new byte[6];
        System.arraycopy(address.getInetAddress().getAddress(), 0, payload, 0, 4);
        ByteUtils.short2leb((short)address.getPort(), payload, 4);
        ggep.put("IP", payload);
        return ggep;
    }

    private GGEP addPackedHosts(GGEP ggep, Collection<? extends IpPort> gnutHosts, Collection<? extends IpPort> dhtHosts) {
        if (gnutHosts != null && !gnutHosts.isEmpty()) {
            ggep.put("IPP", NetworkUtils.packIpPorts(gnutHosts));
            byte[] data = this.getTLSData(gnutHosts);
            if (data.length != 0) {
                ggep.put("IPP_TLS", data);
            }
        }
        if (dhtHosts != null && !dhtHosts.isEmpty()) {
            ggep.put("DHTIPP", NetworkUtils.packIpPorts(dhtHosts));
        }
        return ggep;
    }

    private byte[] getTLSData(Collection<? extends IpPort> hosts) {
        BitNumbers bn = new BitNumbers(hosts.size());
        int i = 0;
        for (IpPort ipPort : hosts) {
            if (this.hostCatcher.get().isHostTLSCapable(ipPort)) {
                bn.set(i);
            }
            ++i;
        }
        return bn.toByteArray();
    }

    private void addUltrapeerExtension(GGEP ggep) {
        byte[] payload = new byte[]{0, this.localPongInfo.getNumFreeLimeWireLeafSlots(), this.localPongInfo.getNumFreeLimeWireNonLeafSlots()};
        ggep.put("UP", payload);
    }

    private void addDHTExtension(GGEP ggep) {
        byte[] payload = new byte[3];
        int version = this.dhtManager.get().getVersion().shortValue();
        ByteUtils.short2beb((short)version, payload, 0);
        if (this.dhtManager.get().isMemberOfDHT()) {
            DHTManager.DHTMode mode = this.dhtManager.get().getDHTMode();
            assert (mode != null);
            payload[2] = mode.byteValue();
        } else {
            payload[2] = DHTManager.DHTMode.INACTIVE.byteValue();
        }
        ggep.put("DHT", payload);
    }

    private GGEP parseGGEP(byte[] PAYLOAD) {
        if (PAYLOAD.length <= 14) {
            return null;
        }
        try {
            return new GGEP(PAYLOAD, 14, null);
        }
        catch (BadGGEPBlockException e) {
            return null;
        }
    }

    private long mark(long kbytes) {
        int x = ByteUtils.long2int(kbytes);
        if (x < 12) {
            return 8L;
        }
        if (x < 24) {
            return 16L;
        }
        if (x < 48) {
            return 32L;
        }
        if (x < 96) {
            return 64L;
        }
        if (x < 192) {
            return 128L;
        }
        if (x < 384) {
            return 256L;
        }
        if (x < 768) {
            return 512L;
        }
        if (x < 1536) {
            return 1024L;
        }
        if (x < 3072) {
            return 2048L;
        }
        if (x < 6144) {
            return 4096L;
        }
        if (x < 12288) {
            return 8192L;
        }
        if (x < 24576) {
            return 16384L;
        }
        if (x < 49152) {
            return 32768L;
        }
        if (x < 98304) {
            return 65536L;
        }
        if (x < 196608) {
            return 131072L;
        }
        if (x < 393216) {
            return 262144L;
        }
        if (x < 786432) {
            return 524288L;
        }
        if (x < 0x180000) {
            return 0x100000L;
        }
        if (x < 0x300000) {
            return 0x200000L;
        }
        if (x < 0x600000) {
            return 0x400000L;
        }
        if (x < 0xC00000) {
            return 0x800000L;
        }
        if (x < 0x1800000) {
            return 0x1000000L;
        }
        if (x < 0x3000000) {
            return 0x2000000L;
        }
        if (x < 0x6000000) {
            return 0x4000000L;
        }
        if (x < 0xC000000) {
            return 0x8000000L;
        }
        if (x < 0x18000000) {
            return 0x10000000L;
        }
        if (x < 0x30000000) {
            return 0x20000000L;
        }
        return 0x40000000L;
    }
}

