/***************************************************************************
 *   Copyright (C) 2005 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef MOUSEWIDGET_H
#define MOUSEWIDGET_H

#include <qwidget.h>
#include <qstring.h>
#include <qlabel.h>
#include <qpixmap.h>
#include <QMutex>
#include "widgets/mainwindow.h"

/**
@author Juergen Thies
*/



class mainWindow;

class mouseWidget : public QWidget
{
Q_OBJECT
public:
    mouseWidget(mainWindow *m, QWidget *parent = 0, const char *name = 0);

    ~mouseWidget();
    static QPixmap *pixmaps[18];
    static mouseWidget *mouseInfo;
    static QString functionText[8];
    static int iconNum[8];
    QLabel *icons[8];
    QLabel *textLabel[8];
    void resizeEvent(QResizeEvent *);
    mainWindow *main;
public slots:
 void update();
    
    
signals:

 void changed();

public:

 static void set(int mode,int modestep);
 static void set(helpText h);
 static void setMultifunction(helpText h);
 static QMutex locked;
protected:
    void contextMenuEvent ( QContextMenuEvent * event );
    void mousePressEvent ( QMouseEvent * event );
  private:
  static   int currentMode;
  static   int currentStep;
  static   helpText currentHelp;
};

#endif
