/***************************************************************************
 *   Copyright (C) 2009 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#ifdef WINDOWS
#ifdef OPENACCESS
#include <winsock2.h>
// #define _WINSOCKAPI_
#endif
#endif
#include <QMainWindow>
#include <QMenu>
#include <QAction>
#include <QToolBar>
#include <QPrinter>
#include <QThread>
class singleToolButton;
class multiToolButton;
class menus;
class macroMenuEntry;
#ifdef translationutility
class translationModule;
#endif

enum helpText {clear, contextHelp,contextLibHelp, layerButtonHelp, setSelectEditHelp, setBoxModeHelp, setPathModeHelp, setPolygonModeHelp, setCellrefModeHelp, setCellrefArrayModeHelp, setTextModeHelp, setSubfunctionHelp, setCopyModeHelp, setMoveModeHelp, setMovePointModeHelp,  moveByHelp, setRotateModeHelp, setMirrorModeHelp, copyToLayerHelp,  moveToLayerHelp, mergeHelp, setCutModeHelp, deleteHelp, setPropertiesModeHelp, newDrawingHelp, openFileHelp, attachFileHelp, saveFileHelp, screenshotHelp, printHelp, whatThisHelp, pointSelectHelp, formSelectHelp, cellSelectHelp, pointDeselectHelp, formDeselectHelp, cellDeselectHelp, selectAllHelp, selectVisibleHelp,  deselectAllHelp, scrollUpHelp, scrollDownHelp,  scrollLeftHelp,  scrollRightHelp, zoomPlusHelp, zoomMinusHelp, zoomFullHelp, zoomOneHelp, setZoomModeHelp, setCellnameHelp, newCellHelp, deleteCellHelp, ungroupHelp, groupHelp, undoHelp,  redoHelp, reduceGridHelp, increaseGridHelp, autoGridHelp, showGridHelp, setCircleModeHelp, setSectorModeHelp, setArcModeHelp, setSpiralModeHelp, removeSmallHelp, roundHelp, setscaleModeHelp, sizeAdjustHelp, areaHelp,  setRulerModeHelp, setLayerAHelp, setLayerBHelp, setAHelp, setBHelp, APlusBHelp, AMultiBHelp,  AMinusBHelp, BMinusAHelp, AEorBHelp, snapGridHelp, snapLineHelp, snapMiddleHelp, snapCenterHelp, snapPointHelp, setupHelp, setBezier2ModeHelp, setBezier3ModeHelp, setArc2ModeHelp, saveAsFileHelp, updateFileHelp, flat1Help, flatAllHelp, pathSelectHelp, pathDeselectHelp, polygonSelectHelp, polygonDeselectHelp, boxSelectHelp, boxDeselectHelp, textSelectHelp, textDeselectHelp, toPolygonHelp, toBoxHelp, deselectLayerHelp, selectLayerHelp, drcSetupHelp, drcClearViolationHelp, drcLoadViolationHelp, drcSaveViolationHelp, drcSetRegionHelp, drcViolationViewHelp, drcSetLayerHelp, drcShowReportHelp, drcMinDistanceHelp, drcInsideHelp, drcNoElementHelp, drcNoPathHelp,drcNoHolesHelp, drcNotchesHelp, drcAnglesHelp, drcDimensionHelp, drcAreaHelp, drcPerimeterHelp, drcNoBoxHelp, drcNoTextHelp,  drcNoPolygonHelp, drcMinSizeHelp, drcMinOverHelp, drcLayerCombinationHelp, setAngleModeHelp, macroReloadHelp, macroStartHelp, macroStopHelp, macroeditHelp, copyCellHelp, extractCellHelp, extractLayerHelp, snapInterHelp, drcOverlapingElementsHelp, invertSelectHelp, toCircleHelp, layerManagerHelp, insertPointHelp, hideUnusedLayersHelp, hideCurUnusedLayersHelp, disableUnusedLayersHelp, enableAllLayersHelp, gotoxyHelp,copyByHelp, crossSectionHelp,
zoomSelectHelp, boolOnLayerHelp, setMoveXModeHelp, moveEdgeHelp, backgroundFrontHelp, setMoveYModeHelp,setCircleBoxModeHelp,setCircleFitModeHelp, centerXHelp,centerHelp, centerYHelp,alignXHelp, alignHelp,alignYHelp, alignValueHelp, alignLeftHelp, alignRightHelp,  alignTopHelp, alignBottomHelp, stripUnneededHelp, clipboardCopyHelp, clipboardPasteHelp, drcMinElementDisHelp,  view3dallHelp, view3dselectHelp , view3dautoHelp , view3doffHelp,  view3dscreenshotHelp , generate3dSetupMacroHelp, macroExecuteHelp,view3dsetupHelp,view3dHelp,lengthHelp, lengthelementHelp, selectCellHelp, setGridHelp, exitHelp,commandHelp, view3dRotXHelp, view3dRotYHelp,view3dRotZHelp, drcOnlyCircleHelp, drcNoCircleHelp, drcOnGridHelp, drcMinDistanceOrOverlapHelp, drcEnclosureHelp,drcOverlapDistanceHelp,setSelectCellModeHelp, setElementSizeModeHelp, closeDesignHelp, snapShapesHelp, setActiveLayerHelp, setVisibilityLayerHelp,setHideOtherLayerHelp, setAllLayerHelp,helpHelp, aboutHelp,generateTechMacroHelp, nextLayoutHelp,generateViewMacroHelp, setUserunitsHelp, groupSimpleHelp,groupGlobalHelp, groupStructureHelp,cellUpHelp,stripIdenticalElementsHelp,netlistLoadHelp,netlistSaveHelp,netlistAddLibraryHelp, netlistRemoveLibraryHelp, netlistRebuildHelp, technologyLayerRemoveHelp,technologyLayerNewHelp,technologyLayerDownHelp,technologyLayerUpHelp,placeShowConnectionsHelp, cropSharpAnglesHelp, setPlaceModeHelp,setRouteModeHelp, routeadjustHelp,route45Help,route90Help,routeFineHelp, setNodeModeHelp,buildConnectHelp,saveGenNetHelp, lvsHelp,registerLicenseHelp, compareCellHelp, toMeshHelp, cropWithSelectionHelp,modifyCornersHelp, setCellOriginHelp,closedPathToPolygonHelp, mergeToHelp, layer123Help, layerABCHelp, layerBlockHelp, layerListHelp, setPreviousCellHelp, stripEmptyCellsHelp, selectCellNameHelp,removeCellArrayHelp, backgroundsetHelp,backgroundclearHelp ,backgroundallclearHelp, placeBackgroundHelp, centerBackgroundHelp, backgroundSetColorHelp, backgroundChooseColorHelp, backgroundPreviewColorHelp, removeNotOrthogonalRefHelp, removeScaledRefHelp, setBarcodeCode39ModeHelp, setBarcodeCode39Mod43ModeHelp, setBarcodeCode128ModeHelp, setBarcodeCode128AModeHelp, setBarcodeCode128BModeHelp, setBarcodeCode128CModeHelp, setDatamatrixModeHelp,
detailsLevel3Help,detailsLevel2Help,detailsLevel1Help,detailsAllHelp,detailsAutoHelp, schematicHelp,openLayoutHelp,schematicBusHelp,schematicDeleteHelp, schematicNameHelp,schematicNewHelp,schematicTextHelp,schematicArcHelp ,schematicCircleHelp, schematicRectHelp, schematicLineHelp, busportHelp, portHelp, lableNodeHelp, schematicWireHelp, schematicPolygonHelp, addSchematicLibHelp, removeSchematicLibHelp, newComponentHelp, editComponentHelp, schematicLibSelectHelp, schematicGroundHelp, schematicColorHelp, schematicEditHelp, toLayoutHelp,toComponenttHelp, pointSelectDeselectHelp, cellSelectDeselectHelp, formSelectDeselectHelp, zoomPlusMinusHelp, saveAsSaveFileHelp,openImportFileHelp,deSelectAllHelp, openImportUpdateFileHelp, gridAutoPlusMinusHelp, setSelectCellModecellUpHelp,execHelp,oaLibCreateHelp, oaSetLibHelp, oaReadLayerHelp, oaVersionHelp, oaLoadNetHelp, oaOpenHelp, oaCellInfoHelp, oaAddLibHelp, displayTextHelp, displayCellsHelp, autoPlaceBackgroundHelp, backgroundShowAllHelp, backgroundShowAllCellHelp, backgroundHideAllHelp, backgroundShowHelp, backgroundShowCellHelp, backgroundHideHelp, componentInfoHelp, flatDialogHelp, groupDialogHelp, extractionHelp
};

/**
@author Juergen Thies
*/

class helpWindow;
class lastOpen;

class mainWindow: public QMainWindow
{
    Q_OBJECT
private:
   int lastmode;
     static void *guiThread;
public:
    mainWindow();

    ~mainWindow();
public:
    static helpWindow *helpwindow;
    QMenu *getMenu(QString name);
    void setToolButton(singleToolButton *,int code,int mode=-1,bool icon=true);
protected:
    multiToolButton *multiButton[30];
    int multiToolButtonNext;
    singleToolButton *singleButton[300];
    int singleToolButtonNext;
    int actionNext;
    QAction *action[300];
    QToolBar *toolBar[30];
    int toolBarNext;
    void addToolbar(QString name, QList<int> list, bool visible=true);
    virtual void spezialToolbar(int){}
    virtual void getFunctionInfo(int , QString *, QObject ** , const char **,helpText *){}
    void addMenu(QString name, QList<int> list);
    
    QMenu *layoutMenu[30];
    int menuNext;
    singleToolButton *undoButton,*redoButton;
    QAction *undoAction, *redoAction;
    QMenu *mainmenu;
    menus *menuList, *mainMenu;
    macroMenuEntry *macroList;
    QString className;
    lastOpen *lastFiles;
    QPrinter *printer;
public slots:
// undo/redo slots
    void undoEnable(bool b);
    void redoEnable(bool b);
    void registerLicense();
    void releaseNotes();
    void about();
    void aboutQt();
    void setNewMode(int i);
    void showMainmenu();
    void showMainmenu(QMenu *);
    virtual void macroStart(QString,QString){};
    void updateMacros();
    void initPrinter(){
	if (printer==NULL) printer = new QPrinter(QPrinter::HighResolution);
	}
	
    bool setShortcut(QString function,QString key); 
signals:
    void newMode(int oldMode,int newMode);
    void executePython(QString code);
public:
    void callPython(QString code){emit executePython(code);}
    void callPythonFile(QString filename);
    void addMacros();
    void addMacroTree(QString *path,QString *menuName,QString *parentName);
    bool isGuiThread(){   
		void *v=QThread::currentThread ();
    		if (v==guiThread) return true;
		else return false;}
#ifdef translationutility
translationModule *translationTool;
#endif
    friend class menuAction;
};

#endif
