/***************************************************************************
 *   Copyright (C) 2005 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef LAYERTOOL_H
#define LAYERTOOL_H

#include <QDockWidget>
//Added by qt3to4:
#include <QResizeEvent>
#include <QWheelEvent>
#include <QScrollBar>
#include "layerbutton.h"
#include <qlayout.h>
#include "general/layers.h"
#include "layerwidget.h"
/**
@author Juergen Thies
*/
class layerTool : public QDockWidget
{
Q_OBJECT
public:
    layerTool(QWidget *,const QString & title);

    ~layerTool();
    layerWidget *layersWidget;
    layerbutton *button[layersMax];
    QScrollBar *scrollBar;
    int initLayers;
    void placeButtons();
    void resizeEvent ( QResizeEvent *  );
    void paintEvent ( QPaintEvent * event );
    
    
public slots:
    void updateAllButtons();
// Layershortkeys;
    void layerActive();
    void layerVisibleToggle();
    void layerHideOther();
    void layerShowAll();
    void scrolled(int);
    void layersAsList();
    void layersAsBlock();
    void layerSortName();
    void layerSortNumber();
signals:
    void shortkeyFinished();
private:
  int layerShortkeyMode;
  int cols;
  int rows;
  double colDif;
  double rowDif;
  int leftLabel;
  int title;
  bool resizeRuning;
  bool oneLayerPerRow;
  int rowStart[layersMax+1];
  int topRowOffset;
  int sorting;
  int findLayer(int);
protected:
  bool eventFilter(QObject *obj, QEvent *event);
  virtual void wheelEvent(QWheelEvent *e);
  virtual void mouseDoubleClickEvent ( QMouseEvent * event );
  virtual void mousePressEvent ( QMouseEvent * event );
  virtual void mouseReleaseEvent ( QMouseEvent * event );
  void focusInEvent ( QFocusEvent * event );
  void focusOutEvent ( QFocusEvent * event );
  void initUsedLayers();
  void contextMenuEvent ( QContextMenuEvent * event );
};

#endif
