/***************************************************************************
 *   Copyright (C) 2004 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "layerbutton.h"
#include "qtoolbutton.h"
#include <QMouseEvent>
#include "general/layers.h"
#include "general/layerproperties.h"
#include "general/setup.h"
#include "general/drawingfield.h"
#include <qpixmap.h>
#include <qpainter.h>
#include <qimage.h>
#include <qbitmap.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qradiobutton.h>
#include <qcursor.h>
#include <qtoolbutton.h>
#include <QAbstractButton>
#include <QtGlobal>
#undef layer_nr
#include "widgets/shortkey.h"
#include "layout.h"
#include "dialog/helpwindow.h"
#include <QWhatsThis>
 



layerbutton::layerbutton(int nr,QWidget *parent)
 : QToolButton(parent){
  active=false;
  shortkey=false;
  actionMakeActive=NULL;
  actionHideLayer=NULL;
  actionShowLayer=NULL;
  //setToggleButton(Q3Button::Toggle);
  setMinimumSize(20,20);
  setCheckable(true);
  setChecked(false);
  layer_nr=nr;
  QString s;
  setText((layers::num[layer_nr].name));
  setToolTip((layers::num[layer_nr].name));
  changeSetup();
  //active=false;
  //shortkey=false;
  makeMenu();
  connect(&time,SIGNAL(timeout()),this,SLOT(showMenu()));
  brush=-1;
}

layerbutton::~layerbutton(){
   popup.clear();
}

void layerbutton::paintEvent ( QPaintEvent * p){
QToolButton::paintEvent(p);
 if (!shortkey) return;
 shortKey::paint(this,layers::num[layer_nr].shortkey);
/*if (layers::num[layer_nr].shortkey=="") return;
  QPen pen(QColor(0,0,0));
  QPainter paint(this); 
  paint.setPen(pen);
   QFont f=QFont("Arial", 10);
  f.setBold(true);
  paint.setFont(f);
  QString s=layers::num[layer_nr].shortkey;
  int i=s.indexOf("+",1);
  if (i>0) {
  	s=s.mid(i+1).trimmed().left(1);
	} 
  else
  s=s.trimmed().left(1);
  if (layers::num[layer_nr].getShortkeyModifiers()==Qt::NoModifier) paint.drawText(0,0,width(),height(),Qt::AlignCenter|Qt::AlignVCenter,s);
	else
		paint.drawText(0,-2,width(),height(),Qt::AlignCenter|Qt::AlignVCenter,s);
  f=QFont("Arial", 6);
  f.setBold(true);
  paint.setFont(f);
  //paint.drawText(0,0,width(),height(),Qt::AlignLeft|Qt::AlignBottom,"ctrl");
  switch (layers::num[layer_nr].getShortkeyModifiers()){
  case Qt::ShiftModifier: paint.drawText(0,2,width(),height(),Qt::AlignLeft|Qt::AlignBottom,"shift");; break;
  case Qt::ControlModifier: paint.drawText(0,2,width(),height(),Qt::AlignLeft|Qt::AlignBottom,"ctrl"); break;
  case Qt::AltModifier: paint.drawText(0,2,width(),height(),Qt::AlignLeft|Qt::AlignBottom,"alt");break ;
  case Qt::MetaModifier: paint.drawText(0,2,width(),height(),Qt::AlignLeft|Qt::AlignBottom,"meta");break ;;break;
  }
  paint.end();*/
}

void layerbutton::makeMenu(){
 popup.clear();
 if (setup::showMenuIcons) {
	actionMakeActive=new QAction(iconActive,tr("Active"),this);
	actionShowLayer=new QAction(iconVisible,tr("Show"),this);
	actionHideLayer=new QAction(iconHide,tr("Hide"),this);
	}
 else {
	actionMakeActive=new QAction(tr("Active"),this);
	actionShowLayer=new QAction(tr("Show"),this);
	actionHideLayer=new QAction(tr("Hide"),this);
}
 connect(actionMakeActive,SIGNAL(triggered()),this,SLOT(makeLayerAktive()));
 //actionMakeActive->setStatusTip(tr("Making this layer active."));
 connect(actionShowLayer,SIGNAL(triggered()),this,SLOT(showLayer()));
 //actionShowLayer->setStatusTip(tr("Show this layer."));
 connect(actionHideLayer,SIGNAL(triggered()),this,SLOT(hideLayer()));
 //actionHideLayer->setStatusTip(tr("Making this layer not visible."));
 actionHideOtherLayer=new QAction(tr("Hide Other"),this);
 connect(actionHideOtherLayer,SIGNAL(triggered()),this,SLOT(hideOtherLayer()));
 //actionHideOtherLayer->setStatusTip(tr("All other layers are set to not visible."));
 actionShowAllLayer=new QAction(tr("Show All"),this);
 connect(actionShowAllLayer,SIGNAL(triggered()),this,SLOT(showAllLayer()));
 //actionShowAllLayer->setStatusTip(tr("All Layers are set visible."));
 actionPropertiesDialog=new QAction(tr("Properties..."),this);
 connect(actionPropertiesDialog,SIGNAL(triggered()),this,SLOT(propertiesDialog()));
 //actionPropertiesDialog->setStatusTip(tr("Editing the layerproperties"));
  popup.addAction(actionMakeActive);
  popup.addAction(actionShowLayer);
  popup.addAction(actionHideLayer);
  popup.addAction(actionHideOtherLayer);
  popup.addAction(actionShowAllLayer);
  popup.addAction(actionPropertiesDialog);
  popup.setTitle(layers::num[layer_nr].name);
  if (setup::showMenuIcons) popup.setIcon(getIcon());
}

void layerbutton::updateMenu(){ 
 if (layers::num[layer_nr].use ) 
		{
		popup.menuAction()->setVisible(true);
		popup.setTitle(layers::num[layer_nr].name);
		popup.setEnabled(true);
		}
 else {
	popup.menuAction()->setVisible(false);
	popup.setTitle(""); //tr("unused"));
 	popup.setEnabled(false);
	QIcon ic;
	if (setup::showMenuIcons) popup.setIcon(ic);
	}
// Mark 2
//#ifndef Q_OS_DARWIN
 if (actionMakeActive!=NULL) if (setup::showMenuIcons) actionMakeActive->setIcon(iconActive);
 if (actionHideLayer!=NULL) if (setup::showMenuIcons) actionHideLayer->setIcon(iconHide);
 if (actionShowLayer!=NULL) if (setup::showMenuIcons) actionShowLayer->setIcon(iconVisible);
//#endif

}

QIcon layerbutton::getIcon(){
 if (active)  return iconActive;
 else if (layers::num[layer_nr].visible)  return iconVisible;
  else  return iconHide;
}


void layerbutton::showMenu(){
 popup.popup(QCursor::pos());
}

void layerbutton::showLayer(){
  setChecked(false);
  if (layers::num[layer_nr].visible==false) emit macroAdd("layers::num["+drawingField::str(layer_nr)+"].visible=true;");
  layers::num[layer_nr].visible=true;
  setIcon();
 // emit changed(layer_nr);
  emit visibleChange();
}

void layerbutton::hideLayer(){
  active=false;
  setChecked(true);
   if (layers::num[layer_nr].visible==true) emit macroAdd("layers::num["+drawingField::str(layer_nr)+"].visible=false;");
  layers::num[layer_nr].visible=false;
  setIcon();
  //emit changed(layer_nr);
  emit visibleChange();
}

void layerbutton::showAllLayer(){
  for (int i=0;i<layersMax;i++){
	if (layers::num[i].use) layers::num[i].visible=true;}
  setChecked(false);
  emit macroAdd("layers::showAllLayer();");
  //printf("showAllLayer %d\n",layer_nr);
  emit updateAllLayerbutton();
  emit visibleChange();
}

void layerbutton::hideOtherLayer(){
  for (int i=0;i<layersMax;i++){
	layers::num[i].visible=false;}
  emit macroAdd("layers::hideAllLayer();");
  emit macroAdd("layers::num["+drawingField::str(layer_nr)+"].visible=true;");
  layers::num[layer_nr].visible=true;
  active=true;
  setChecked(false);
  //printf("hideOtherLayer %d\n",layer_nr);
  emit aktiveLayer(layer_nr);
  emit updateAllLayerbutton();
  emit visibleChange();
}

void layerbutton::makeLayerAktive(){
   active=true;
   setChecked(false);
   setIcon();
   emit aktiveLayer(layer_nr);
   if (!layers::num[layer_nr].visible){layers::num[layer_nr].visible=true;emit visibleChange();}
   //emit changed(layer_nr);
}


void layerbutton::mouseReleaseEvent(QMouseEvent *e){
if ((e->button()==Qt::LeftButton)&&(time.isActive())){
	  	if (!active) makeLayerAktive();
	}
time.stop();
}

void layerbutton::mousePressEvent(QMouseEvent *e){
//printf("mousepressed %d %d\n",int(e->modifiers()),e->button());
  if (((e->modifiers()==Qt::ShiftModifier)&&(e->button()==Qt::RightButton))){
	showAllLayer();
	}
  else if (((e->modifiers()==Qt::ShiftModifier+Qt::ControlModifier)&&(e->button()==Qt::LeftButton))){
	propertiesDialog();
	}
  else if (((e->modifiers()==Qt::ControlModifier)&&(e->button()==Qt::RightButton))){
  	// set all outline
	for (int i=0;i<layersMax;i++){layers::num[i].setStyle(0);}
  	 emit aktiveLayer(layer_nr);
	 emit updateSetup();
	}
  else if (((e->modifiers()==Qt::ControlModifier)&&(e->button()==Qt::LeftButton))){
	hideOtherLayer();
	}
  else if ((e->button()==Qt::MidButton)||((e->modifiers()==Qt::ShiftModifier)&&(e->button()==Qt::LeftButton))){
        if (isChecked()){
		showLayer();}
	else{
		hideLayer();
		active=false;
 	}
	}
  else if (e->button()==Qt::LeftButton){
	time.setSingleShot(true);
  	time.start(1000);
        //if (!active){makeLayerAktive();}
	
	}
}

void layerbutton::setIcon(){
  if (active) QAbstractButton::setIcon(iconActive);
  else if (layers::num[layer_nr].visible) QAbstractButton::setIcon(iconVisible);
  else QAbstractButton::setIcon(iconHide);
//#ifndef Q_OS_DARWIN
if (setup::showMenuIcons){
  if (layers::num[layer_nr].use){
    if (active)  popup.setIcon(iconActive);
    else if (layers::num[layer_nr].visible)  popup.setIcon(iconVisible);
	}
    else  popup.setIcon(iconHide);
  }
//#endif
}

void layerbutton::visibleOn(){
  showLayer();
}

void layerbutton::aktiveOff(){
  active=false;
  setIcon();
 // emit changed(layer_nr);
}

void layerbutton::updateButton(){
  setUpdatesEnabled(false);
     if (layers::num[layer_nr].visible==true){setChecked(false);}
     else {setChecked(true);}
  setUpdatesEnabled(true);
  setIcon();
}

void layerbutton::changeSetup(){
  setText((layers::num[layer_nr].name));
  setToolTip((layers::num[layer_nr].name));
  if ((layers::num[layer_nr].pen.color()==color)&&(brush==layers::num[layer_nr].brushStyle)) {
      updateMenu();
      updateButton();
      return;
  }
  color=layers::num[layer_nr].pen.color();
  brush=layers::num[layer_nr].brushStyle;
  QPixmap pixmap=QPixmap(16,16);
  pixmap.fill(qRgb(200,200,200));
  QPixmap alpha=QPixmap(16,16);
  alpha.fill(qRgb(0,0,0));
  pixmap.setAlphaChannel(alpha);
  QPainter paint(&pixmap);
  paint.setPen(layers::num[layer_nr].pen);
  paint.setBrush(layers::num[layer_nr].brush());
  paint.drawRect(2,2,12,12);
  paint.end();
  iconVisible=QIcon(pixmap);
  pixmap.fill(qRgb(200,200,200));
  alpha.fill(qRgb(0,0,0));
  pixmap.setAlphaChannel(alpha);
  paint.begin(&pixmap);
  paint.setPen(layers::num[layer_nr].pen);
  paint.setBrush(layers::num[layer_nr].brush());
  paint.drawRect(0,0,16,16);
  paint.drawRect(1,1,14,14);
  paint.drawRect(2,2,12,12);
  paint.end();
  iconActive=QIcon(pixmap);
  pixmap.fill(qRgb(200,200,200));
  alpha.fill(qRgb(0,0,0));
  pixmap.setAlphaChannel(alpha);
  paint.begin(&pixmap);
  QPen pen=layers::num[layer_nr].pen;
  pen.setColor(qRgb(150,150,150));
  paint.setPen(pen);
  QBrush brush=layers::num[layer_nr].brush();
  brush.setColor(qRgb(150,150,150));
  paint.setBrush(brush);
  paint.drawRect(2,2,12,12);
  paint.end();
  iconHide=QIcon(pixmap);
  updateMenu();
  updateButton();
 }
 
 void layerbutton::propertiesDialog(){
 QString s;
 layerproperties *l= new layerproperties(layer_nr);
 l->setModal(true);
 l->setWindowTitle(tr("Properties for Layer ")+s.setNum(layer_nr));
 if (active==true) {l->stateActive->setChecked(true);}
 else if (layers::num[layer_nr].visible==true) {l->stateVisible->setChecked(true);}
 else {l->stateHidden->setChecked(true);}
 l->show();
 if (l->exec()==QDialog::Accepted){
 	layers::num[layer_nr].name=l->layerName->text();
	macroAdd("layers::num["+drawingField::str(layer_nr)+"].name=\""+l->layerName->text()+"\";");
	layers::num[layer_nr].setStyle(l->brushStyle);
	macroAdd("layers::num["+drawingField::str(layer_nr)+"].setStyle("+drawingField::str(layers::num[layer_nr].getStyle())+");");
	layers::num[layer_nr].pen.setColor(l->brush.color());
	//layers::num[layer_nr].brush.setColor(l->brush.color());
	layers::num[layer_nr].shortkey=l->shortKeyB->getShortKey();
	macroAdd("layers::num["+drawingField::str(layer_nr)+"].setColor("+drawingField::str(l->brush.color().red())+","+drawingField::str(l->brush.color().green())+","+drawingField::str(l->brush.color().blue())+");");
	update();
	changeSetup();
	emit visibleChange();
	if (l->stateActive->isChecked()){makeLayerAktive();}
	if ((l->stateVisible->isChecked())&&(layers::num[layer_nr].visible==false)){showLayer();}
	if ((l->stateHidden->isChecked())&&(layers::num[layer_nr].visible==true)){hideLayer();}
 }
 l->hide();
 delete l;
 }
 
bool layerbutton::event( QEvent *e){
    if (e->type() == 
            (QEvent::WhatsThis)) {
	//QWhatsThis::hideText ();
	  layout::helpwindow->showHelp(layerButtonHelp);
	  QWhatsThis::leaveWhatsThisMode ();
	  return true;
	}
return QToolButton::event(e);
}
