# qmake file fr den LayoutEditor
# (c) 2004-2010 Jrgen Thies
# Licened under the GPL
#  QMAKE_CXXFLAGS_RELEASE += -fno-var-tracking-assignments

DESTDIR=../bin
unix:OBJECTS_DIR = o
unix:UI_DIR= o
unix:RCC_DIR = o
unix:MOC_DIR = o
TARGET = layout
CONFIG += release \
warn_on \
qt \
thread \
exceptions
QT += xml
#CONFIG += debug
TEMPLATE = app
win32{
  DEFINES += WINDOWS
  RC_FILE = icons/icon.rc
#  QTPLUGIN   += qjpeg qgif qmng qico
#  DEFINES += IMAGEPLUGINS
} 

exists( ../../win64.h ) {
DEFINES += WINDOWS64
message("Windows 64bit used")
}

#LIBS += -ltcl

win32-msvc2008{
    LIBS += -lfreetype
    CONFIG += embed_manifest_exe
    QMAKE_INCDIR += C:/Qt/libs
    QMAKE_LIBDIR += C:/Qt/libs
    QMAKE_CXXFLAGS += -wd4996
}
win32-msvc2005{
    LIBS += -lfreetype
    CONFIG += embed_manifest_exe
}

win32-g++{
    LIBS += -llibfreetype
}

CONFIG(staticqt) {
    QTPLUGIN +=qjpeg qgif qmng
    DEFINES += QT_STATIC
    message("static qt")
}
!CONFIG(staticqt) {
    message("dynamic qt")
}
unix{
  LIBS += -lfreetype -ldl -lz
  INCLUDEPATH += /usr/include/freetype2
  DEFINES += LINUX
 NOPRINTING = 4.3.0 4.3.1 4.3.2 4.3.3 4.3.4 4.4.0 4.4.1 4.4.2 4.4.3 4.4.4 4.4.5 4.5.0 4.5.1
 contains( NOPRINTING, $$QT_VERSION ){
	DEFINES += NO_PRINTER
	message("Linux qt version $$QT_VERSION -> no printing due to qt bug")
	}
}
#
# console output for prcessing times
#
exists( print.h ){
   DEFINES += printtime
   CONFIG += console
}
#
# mac icon and ppc
#
macx{
# CONFIG+= x86
LIBS += -lz
LIBS -= -ldl
# x86_64
# icon for Mac OS X
  ICON = icons/layout.icns
   DEFINES += MACOSX
}
#
# for static linked freetype on mac
#
exists( /Users/thies/ft/include/ft2build.h ) {
  INCLUDEPATH += /Users/thies/ft/include
  INCLUDEPATH += /Users/thies/ft/include/freetype2
  LIBS += -L/Users/thies/ft/lib
}
FORMS += elements/boxpropertiesdialog.ui \
         elements/cellrefarraypropertiesdialog.ui \
         elements/cellrefpropertiesdialog.ui \
         elements/pathpropertiesdialog.ui \
         elements/polygonpropertiesdialog.ui \
         elements/textpropertiesdialog.ui \
	 elements/propertyeditdialog.ui \
         general/layerpropertiesdialog.ui \
         dialog/movebydialog.ui \
 	 dialog/drcareadialog.ui \
	 dialog/drcangledialog.ui \
	 dialog/drcdimensiondialog.ui \
	 dialog/drcminsizedialog.ui \
	 dialog/drcmindistancedialog.ui \
	 dialog/drcmindistanceoverlapdialog.ui \
	 dialog/drcinsidedialog.ui \
	 dialog/drclayercombinationdialog.ui \
 	 dialog/drcnoholesdialog.ui \
	 dialog/pointentrydialog.ui \
         dialog/helpwindowdialog.ui \
         dialog/setupwindowdialog.ui \
         dialog/selectcelldialog.ui \
         dialog/setuserunitdialog.ui \
         dialog/cellselectdialog.ui \
         dialog/selectgriddialog.ui \
         general/reportdialog.ui \
	 dialog/layermanagerdialog.ui \
	 dialog/gotoxydialog.ui \
	 dialog/layersetupwidget.ui \
	 dialog/sizeadjustdialog.ui \
	 dialog/modifycornersdialog.ui \
	 dialog/rotatedialog.ui \
	 dialog/placecelldialog.ui \
	 dialog/groupdialog.ui \
	 dialog/flatdialog.ui \
	 dialog/boolonlayerdialog.ui \
	 drc/drcwidgetdialog.ui

TRANSLATIONS += ../translation/layout_de.ts 
TRANSLATIONS += ../translation/layout_ru.ts 
TRANSLATIONS += ../translation/layout_ja.ts 
TRANSLATIONS += ../translation/layout_fr.ts 
TRANSLATIONS += ../translation/layout_new.ts 
HEADERS += layout.h \
           elements/box.h \
           elements/boxproperties.h \
           elements/cell.h \
           elements/celllist.h \
           elements/cellref.h \
           elements/cellrefarray.h \
           elements/cellrefproperties.h \
           elements/element.h \
           elements/elementlist.h \
           elements/path.h \
           elements/pathproperties.h \
           elements/polygon.h \
           elements/text.h \
           elements/textproperties.h \
           elements/polygonproperties.h \
           elements/cellrefarrayproperties.h \
           elements/shortselect.h \
           elements/propertylist.h \
           elements/layertranslator.h \
	   elements/propertyedit.h \
           elements/pointarray.h \
           elements/strans.h \
           elements/elementiterator.h \
           fileformats/dxf.h \
           fileformats/filedialog.h \
           fileformats/gds.h \
           fileformats/source.h \
	   fileformats/ap.h \
	   fileformats/tld.h \
	   fileformats/svg.h \
	   fileformats/eps.h \
	   fileformats/pixel.h \
	   fileformats/csv.h \
	   fileformats/gerber.h \
	   fileformats/electromask.h \
           fileformats/filewrite.h \
           fileformats/cif.h \
           fileformats/filegeneral.h \
           fileformats/oasis.h \
           fileformats/iconprovider.h \
           general/drawingfield.h \
           general/drawpixmap.h \
           general/layer.h \
           general/layerproperties.h \
           general/layers.h \
           general/paintpixmapthread.h \
           general/setup.h \
           general/layoutimage.h \
           general/layoutpixmap.h \
           general/layoutimagepainter.h \
           general/layoutimagepaintertransparent.h \
           general/layoutimagepainterwhitetransparent.h \
           general/layoutimagepainterstacked.h \
           general/textrender.h \
           general/system.h \
	   general/errorreport.h \
           general/reportview.h \
           general/reportitem.h \
           general/userunitsvalidator.h \
           general/guiworkthread.h \
           general/lastopen.h \
           general/splash.h \
	   general/project.h \
	   general/oainfo.h \
	   general/basemode.h \
           drc/drc.h \
           drc/drcdock.h \
           drc/drcwidget.h \
	   drc/drcregionmode.h \
	   widgets/cellcombo.h \
           widgets/layerbutton.h \
           widgets/layersetupbutton.h \
           widgets/layernameedit.h \
           widgets/selectwidget.h \
           widgets/gridwidget.h \
           widgets/timewidget.h \
           widgets/poswidget.h \
           widgets/lineedit.h \
           widgets/menuaction.h \
           macro/macro.h \
           macro/macromenuentry.h \
           macro/menus.h \
           macro/keywords.h \
           macro/variant.h \
           macro/parservalue.h \
           macro/includes.h \
	   macro/string.h \
	   macro/stringlist.h \
           macro/file.h \
	   dialog/boolonlayer.h \
           dialog/moveby.h \
	   dialog/drcarea.h \
	   dialog/drcangle.h \
	   dialog/drcdimension.h \
	   dialog/drcminsize.h \
	   dialog/drcmindistance.h \
	   dialog/drcmindistanceoverlap.h \
	   dialog/drcnoholes.h \
	   dialog/drcinside.h \
	   dialog/drclayercombination.h \
           dialog/pointentry.h \
           dialog/selectcell.h \
           dialog/cellselect.h \
	   dialog/sizeadjust.h \
	   dialog/setuserunit.h \
	   dialog/layermanager.h \
           dialog/layersetupwidget2.h \
           dialog/helpwindow.h \
           dialog/setupwindow.h \
           dialog/gotoxy.h \
           dialog/selectgrid.h \
	   dialog/modifycorners.h \
           defines.h \
           widgets/multitoolbutton.h \
           widgets/subtoolbutton.h \
           widgets/mousehelp.h \
           widgets/layertool.h \
           widgets/layerwidget.h \
           widgets/mousewidget.h \
           widgets/singletoolbutton.h \
           widgets/tool3dbutton.h \
           widgets/newcombobox.h \
           widgets/shortkey.h \
	   widgets/mainwindow.h \
           widgets/shortkeybutton.h \
           widgets/shortkeytoolbutton.h
# tr help headers
unix{
HEADERS += autogen/layout_tr.h \
	   autogen/layout_tr2.h \
	   autogen/helpwindow_tr.h 
}
SOURCES += layout.cpp \
           main.cpp \
           drc/drc.cpp \
           drc/drcdock.cpp \
           drc/drcwidget.cpp \
	   drc/drcregionmode.cpp \
           elements/textproperties.cpp \
           elements/box.cpp \
           elements/boxproperties.cpp \
           elements/cell.cpp \
           elements/celllist.cpp \
           elements/cellref.cpp \
           elements/cellrefarray.cpp \
           elements/cellrefarrayproperties.cpp \
           elements/cellrefproperties.cpp \
           elements/element.cpp \
           elements/elementlist.cpp \
           elements/path.cpp \
           elements/pathproperties.cpp \
           elements/polygon.cpp \
           elements/polygonproperties.cpp \
           elements/text.cpp \
           elements/shortselect.cpp \
           elements/propertylist.cpp \
           elements/layertranslator.cpp \
	   elements/propertyedit.cpp \
           elements/strans.cpp \
           elements/pointarray.cpp \
           elements/elementiterator.cpp \
           fileformats/dxf.cpp \
           fileformats/filedialog.cpp \
           fileformats/gds.cpp \
           fileformats/source.cpp \
	   fileformats/ap.cpp \
	   fileformats/tld.cpp \
	   fileformats/svg.cpp \
	   fileformats/eps.cpp \
	   fileformats/pixel.cpp \
	   fileformats/csv.cpp \
	   fileformats/gerber.cpp \
	   fileformats/electromask.cpp \
           fileformats/filewrite.cpp \
           fileformats/oasis.cpp \
           fileformats/cif.cpp \
           fileformats/filegeneral.cpp \
           general/drawingfield.cpp \
           general/drawpixmap.cpp \
           general/layer.cpp \
           general/layerproperties.cpp \
           general/layers.cpp \
           general/paintpixmapthread.cpp \
           general/setup.cpp \
           general/layoutimage.cpp \
           general/layoutpixmap.cpp \
           general/layoutimagepainter.cpp \
           general/layoutimagepaintertransparent.cpp \
           general/layoutimagepainterwhitetransparent.cpp \
           general/layoutimagepainterstacked.cpp \
           general/textrender.cpp \
           general/system.cpp \
           general/errorreport.cpp \
           general/reportview.cpp \
           general/reportitem.cpp \
	   general/oainfo.cpp \
           macro/macro.cpp \
           macro/macromenuentry.cpp \
           macro/menus.cpp \
           macro/keywords.cpp \
           macro/variant.cpp \
           macro/parservalue.cpp \
           macro/includes.cpp \
           macro/file.cpp \
	   macro/string.cpp \
	   macro/stringlist.cpp \
	   general/basemode.cpp \
           general/userunitsvalidator.cpp \
           general/guiworkthread.cpp \
           general/lastopen.cpp \
           general/splash.cpp \
	   general/project.cpp \
	   dialog/boolonlayer.cpp \
           dialog/moveby.cpp \
           dialog/pointentry.cpp \
           dialog/layersetupwidget2.cpp \
           dialog/helpwindow.cpp \
           dialog/setupwindow.cpp \
	   dialog/drcarea.cpp \
	   dialog/drcangle.cpp \
	   dialog/drcdimension.cpp \
	   dialog/drcminsize.cpp \
	   dialog/drcmindistance.cpp \
	   dialog/drcmindistanceoverlap.cpp \
	   dialog/drcnoholes.cpp \
	   dialog/drcinside.cpp \
	   dialog/drclayercombination.cpp \
           dialog/selectcell.cpp \
           dialog/cellselect.cpp \
	   dialog/sizeadjust.cpp \
	   dialog/setuserunit.cpp \
	   dialog/modifycorners.cpp \
           dialog/selectgrid.cpp \
           dialog/layermanager.cpp \
           dialog/gotoxy.cpp \
	   widgets/cellcombo.cpp \
           widgets/layerbutton.cpp \
           widgets/layersetupbutton.cpp \
           widgets/layernameedit.cpp \
           widgets/selectwidget.cpp \
           widgets/lineedit.cpp \
           widgets/gridwidget.cpp \
           widgets/timewidget.cpp \
           widgets/mousehelp.cpp \
           widgets/poswidget.cpp \
           widgets/shortkey.cpp \
           widgets/layertool.cpp \
           widgets/layerwidget.cpp \
           widgets/mousewidget.cpp \
           widgets/menuaction.cpp \
           widgets/singletoolbutton.cpp \
           widgets/tool3dbutton.cpp \
           widgets/newcombobox.cpp \
           widgets/multitoolbutton.cpp \
           widgets/subtoolbutton.cpp \
	   widgets/mainwindow.cpp \
           widgets/shortkeybutton.cpp \
	   widgets/shortkeytoolbutton.cpp
RESOURCES += layout-rc.qrc
RESOURCES += autogen/whatsthis.qrc
#
#switch correct boolean tool
#
exists( boolle/booleanhandler.h ){
DEFINES += BOOL_LAYOUT
HEADERS +=  boolle/booleanhandler.h \
           boolle/boolengine.h \
           boolle/_dl_itr.h \
           boolle/_dl_itr.cpp \
           boolle/boolgraph.h \
           boolle/boolgraphlist.h \
           boolle/boolline.h \
           boolle/boollink.h \
           boolle/_lnk_itr.h \
           boolle/_lnk_itr.cpp \
           boolle/boolpoint.h \
           boolle/boolnode.h \
           boolle/boolrecord.h \
           boolle/boolscanbeam.h
SOURCES += boolle/booleanhandler.cpp \
           boolle/boolengine.cpp \
           boolle/boolgraph.cpp \
           boolle/boolgraphlist.cpp \
           boolle/boolline.cpp \
           boolle/boollink.cpp \
           boolle/boolpoint.cpp \
           boolle/boolnode.cpp \
           boolle/boolrecord.cpp \
           boolle/boolscanbeam.cpp
}
else {
DEFINES += BOOL_GPL
HEADERS +=  boolgpl/booleanhandler.h \
           boolgpl/booleng.h \
           boolgpl/_dl_itr.h \
           boolgpl/_dl_itr.cpp \
           boolgpl/graph.h \
           boolgpl/graphlst.h \
           boolgpl/line.h \
           boolgpl/link.h \
           boolgpl/_lnk_itr.h \
           boolgpl/_lnk_itr.cpp \
           boolgpl/lpoint.h \
           boolgpl/node.h \
           boolgpl/record.h \
           boolgpl/scanbeam.h
SOURCES += boolgpl/booleanhandler.cpp \
           boolgpl/booleng.cpp \
           boolgpl/graph.cpp \
           boolgpl/graphlst.cpp \
           boolgpl/instonly.cpp \
           boolgpl/line.cpp \
           boolgpl/link.cpp \
           boolgpl/lpoint.cpp \
           boolgpl/node.cpp \
           boolgpl/record.cpp \
           boolgpl/scanbeam.cpp
}

#
#3d view
#
!CONFIG(genisys){
exists( 3d/window3d.cpp ){
message("extension 3d")
  DEFINES += USE_3d
  DEFINES += USE_3d_thread
  QT += opengl
  SOURCES += 3d/window3d.cpp \
  	     3d/widget3d.cpp \
  	     3d/view3dmodule.cpp \
	     3d/point3d.cpp \
	     3d/triangle3d.cpp \
	     3d/dxf3d.cpp
  HEADERS += 3d/window3d.h \
  	     3d/widget3d.h \
  	     3d/view3dmodule.h \
	     3d/point3d.h \
	     3d/triangle3d.h \
	     3d/dxf3d.h
}
}
#
# layout style
#
exists( style/layoutstyle.h ){
  HEADERS += style/layoutstyle.h
  SOURCES += style/layoutstyle.cpp
  RESOURCES += style/images.qrc
  DEFINES += layout_style
}
#
# multithread painting/ file open
#
exists( threads/fileread.h ){
HEADERS += threads/fileread.h \
	threads/cleandispatcher.h \
	threads/layoutimagedispatcher.h \
	threads/layoutimagethread.h
SOURCES += threads/fileread.cpp \
	threads/cleandispatcher.cpp \
	threads/layoutimagedispatcher.cpp \
	threads/layoutimagethread.cpp
DEFINES += multithread
MULTITHREAD= yes
}
isEmpty(MULTITHREAD){
    HEADERS += fileformats/file_read.h  
    SOURCES += fileformats/file_read.cpp 
}
#
# license handler
#
exists( license/license.h ){
	DEFINES += FULL_VERSION
HEADERS += license/license.h \
	   license/licenseinput.h \
	   dialog/licenseselector.h
SOURCES += license/license.cpp \
	   license/licenseinput.cpp \
	   dialog/licenseselector.cpp
FORMS += license/licenseinputdialog.ui \
	 dialog/licenseselectordialog.ui
QT += network
}
exists( license/key.h ){
	HEADERS += license/key.h 
	DEFINES += LICENSE_INPUT
	RESOURCES += license/key.qrc
}
#
# netlist tools
#
!CONFIG(genisys){
exists( net/netlist.h ){
message("extension netlist")
FORMS += net/netwidgetdialog.ui \
	net/edittechnologylayerdialog.ui
HEADERS += net/netlist.h \
	net/netdock.h \
	net/netwidget.h \
	net/netlistnode.h \
	net/netlibrary.h \
	net/netlistmodule.h \
	net/netlistdevice.h \
	net/netlistdeviceconnection.h \
	net/connectbuilder.h \
	net/connectoperator.h \
	net/edittechnologylayer.h \
	net/linkmode.h \
	net/placemode.h \
	net/routemode.h \
	fileformats/odb.h \
	fileformats/lef.h \
	fileformats/def.h
SOURCES += net/netlist.cpp \
	net/netdock.cpp \
	net/netwidget.cpp \
	net/netlistnode.cpp \
	net/netlibrary.cpp \
	net/netlistmodule.cpp \
	net/netlistdevice.cpp \
	net/netlistdeviceconnection.cpp \
	net/connectbuilder.cpp \
	net/edittechnologylayer.cpp \
	net/linkmode.cpp \
	net/placemode.cpp \
	net/routemode.cpp \
	fileformats/odb.cpp \
	fileformats/def.cpp \
	fileformats/lef.cpp
DEFINES += netlistutility
}
}

#
# barcode tools
#
!CONFIG(genisys){
exists( barcode/barcodemodule.h ){
message("extension barcode")
FORMS += barcode/dataentrydialog.ui
HEADERS += barcode/barcodemodule.h \
	   barcode/barcodemode.h \
	   barcode/code39.h \
	   barcode/code128.h \
	   barcode/datamatrix.h
SOURCES += barcode/barcodemodule.cpp \
	   barcode/barcodemode.cpp \
	   barcode/code39.cpp \
	   barcode/code128.cpp \
	   barcode/datamatrix.cpp
DEFINES += barcodeutility
}
}

#
# text edit
#
exists( ../qscintilla/qscintilla.pro ){
#FORMS += barcode/dataentrydialog.ui
HEADERS += textedit/textedit.h \
	   textedit/textdisplay.h
SOURCES += textedit/textedit.cpp \
	   textedit/textdisplay.cpp
DEFINES += TEXTEDIT
INCLUDEPATH += ../qscintilla/qscintilla
LIBS += -lqscintilla2
QMAKE_LIBDIR += ../qscintilla
}

#
# extraction tools
#
!CONFIG(genisys){
exists( extraction/extractionmodule.h ){
message("extension extraction")
FORMS += extraction/extractionwidgetdialog.ui
HEADERS += extraction/extractionmodule.h \
	   extraction/extractiondock.h \
	   extraction/extractionwidget.h \
	   extraction/fastresistance.h \
	   extraction/fastcap.h \
	   extraction/resistormode.h \
	   extraction/extractionresthread.h
SOURCES += extraction/extractionmodule.cpp \
	   extraction/extractiondock.cpp \
	   extraction/extractionwidget.cpp \
	   extraction/fastresistance.cpp \
	   extraction/fastcap.cpp \
	   extraction/resistormode.cpp \
	   extraction/extractionresthread.cpp
DEFINES += extractionutility
}
}

#
# translation tools
#
exists( translation/translation.pro ){
include(translation/translation.pro)
DEFINES += translationutility
}

#
# background tools
#
!CONFIG(genisys){
exists( background/backgroundmodule.h){
message("extension background")
FORMS += background/backgroundwidgetdialog.ui
HEADERS += background/backgroundmodule.h \
	   background/backgrounddock.h \
	   background/backgroundwidget.h \
           background/backgroundpicture.h 
SOURCES += background/backgroundmodule.cpp \
	   background/backgrounddock.cpp \
	   background/backgroundwidget.cpp \
           background/backgroundpicture.cpp
DEFINES += backgroundutility
}
}

#
# openAccess
#
#CONFIG(openaccess) {
!CONFIG(genisys){
exists( ../oa/src/src.pro){
message("extension openaccess")
FORMS += oa/selectviewdialog.ui \
         oa/oacellinfodialog.ui
HEADERS += oa/oalayout.h \
	   oa/oaschematic.h \
	   oa/oatest.h \
	   oa/oaconvert.h \
	   oa/oamodule.h \
	   oa/selectview.h \
	   oa/oacellinfo.h \
	   oa/tclinterpreter.h \
	   oa/cdfparser.h
SOURCES += oa/oatest.cpp \
	   oa/oaschematic.cpp \
	   oa/oalayout.cpp \
	   oa/oaconvert.cpp \
	   oa/oamodule.cpp \
	   oa/selectview.cpp \
	   oa/oacellinfo.cpp \
	   oa/tclinterpreter.cpp \
	   oa/cdfparser.cpp
DEFINES += OPENACCESS
exists ( ../../oa/include/oa/oaBase.h ) {
    INCLUDEPATH += ../../oa/include/oa
    INCLUDEPATH += ../../oa/include/oaLang
    QMAKE_LIBDIR += ../../oa/lib
    message("OpenAccess use ../../oa")
} else {
exists ( /home/thies/oa/include/oa/oaBase.h ) {
    INCLUDEPATH += /home/thies/oa/include/oa
    INCLUDEPATH += /home/thies/oa/include/oaLang
    QMAKE_LIBDIR += /home/thies/oa/lib
    message("OpenAccess use /home/thies/oa")
} else {
    message("OpenAccess use ../oa/src")
    INCLUDEPATH += ../oa/src/base
    INCLUDEPATH += ../oa/src/common
    INCLUDEPATH += ../oa/src/design
    INCLUDEPATH += ../oa/src/build
    INCLUDEPATH += ../oa/src/dm
    INCLUDEPATH += ../oa/src/cm
    INCLUDEPATH += ../oa/src/plugIn
    INCLUDEPATH += ../oa/src/tech
    INCLUDEPATH += ../oa/src/util
    INCLUDEPATH += ../oa/src/wafer
    INCLUDEPATH += ../oa/oaLang/tcl
    INCLUDEPATH += ../oa/oaLang/base
    INCLUDEPATH += ../oa/oaLang/info
    INCLUDEPATH += ../oa/oaLang/help
    INCLUDEPATH += ../oa/oaLang/plugIn
    INCLUDEPATH += ../oa/oaLang/tclBase
    INCLUDEPATH += ../oa/oaLang/tclCommon
    INCLUDEPATH += ../oa/oaLang/tclEngine
    QMAKE_LIBDIR += ../oa/lib
    LIBS += -loaCM
}}
LIBS += -loaBase -loaCommon -loaPlugIn -loaDM -loaTech -loaDesign -loaWafer
LIBS += -loaTcl  -loaTclBase -loaLangBase -loaLangInfo -loaTclPlugIn 
# -loaTclEngine
LIBS += -loaTclCommon -loaTclHelp
win32{
 LIBS += -ltcl85t
 INCLUDEPATH += ../../libs/tcl
}
else {
 LIBS += -ltcl
 INCLUDEPATH += /usr/include/tcl8.4
 !exists (/usr/lib/libtcl.so) {
   !exists (/usr/lib64/libtcl.so) {
   LIBS -= -ltcl
   LIBS += -ltcl8.5
   }
 }
}

#-loaUtil

QMAKE_CXXFLAGS_WARN_ON -= -Wall
QMAKE_CXXFLAGS_WARN_OFF += -Wno-ctor-dtor-privacy
#message($(QMAKE_CXXFLAGS_WARN_OFF))
}
}
#}

exists (addon/addon3dlayout.h) {
DEFINES += ADDON3D
}

exists (addon/custommode.cpp) {
DEFINES += ADDON_CUSTOMMODE
}

!CONFIG(genisys){
exists (schematic/schematic.h) {
DEFINES += SCHEMATIC
include(schematic/schematic.pro)
message("extension schematic")
}
}

CONFIG(genisys){
    
    DEFINES += GENISYS
exists (codemeter/codemeter.pro) {
	DEFINES += CODEMETER
	include(codemeter/codemeter.pro)
	message("use codemeter")
	}
    message("GENISYS version")

}