/***************************************************************************
 *   Copyright (C) 2005 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "parservalue.h"
#include "keywords.h"
#include "general/errorreport.h"
#include <qrect.h>




void macro::rectHandler_registerKeywords(keywords **keyword_){
 *keyword_= new keywords(*keyword_);
 (*keyword_)->keyword="rect";
 (*keyword_)->type=type;
 (*keyword_)->typeHandler=&macro::rectHandler_typeHandler;
}
void macro::rectHandler_typeHandler(int *counter,keywords **keyword_,bool single){
generalTypeProcessing(counter,keyword_,ptrRect,varRect,single);
}

returnValue macro::rectHandler_classHandler(int *counter, keywords *keyword_,returnValue* r,bool left){
 QString s;
 returnValue ret;
 parserValue p;
if (r->type==ptrRect){
   if (checkClassPointer(counter)) {
   }
   else { 
   	if (left) { compute(r,counter,keyword_);return ret;}
     	else return *r;
	}
   }
 else if (r->type==varRect){
     if (checkDot(counter)) {
   }
   else {
   	if (left) {compute(r,counter,keyword_);return ret;}
     	else return *r;
	}
    }
QRect *c= r->getRect();
 p=next(counter);
 if (((p.type==keyword)&&(p.value=="left"))) {
 	testParenOpen(counter);
	testParenClose(counter);
	ret.setInt(c->left());
  	}
 else if (((p.type==keyword)&&(p.value=="top"))) {
 	testParenOpen(counter);
	testParenClose(counter);
	ret.setInt(c->top());
  	}
 else if (((p.type==keyword)&&(p.value=="right"))) {
 	testParenOpen(counter);
	testParenClose(counter);
	ret.setInt(c->right());
  	}
 else if (((p.type==keyword)&&(p.value=="bottom"))) {
 	testParenOpen(counter);
	testParenClose(counter);
	ret.setInt(c->bottom());
  	}
 else if (((p.type==keyword)&&(p.value=="setLeft"))) {
 	testParenOpen(counter);
	returnValue i=calculate(counter,keyword_);
	testParenClose(counter);
	c->setLeft(i.getInt());
  	}
 else if (((p.type==keyword)&&(p.value=="setRight"))) {
 	testParenOpen(counter);
	returnValue i=calculate(counter,keyword_);
	testParenClose(counter);
	c->setRight(i.getInt());
  	}
 else if (((p.type==keyword)&&(p.value=="setTop"))) {
 	testParenOpen(counter);
	returnValue i=calculate(counter,keyword_);
	testParenClose(counter);
	c->setTop(i.getInt());
  	}
 else if (((p.type==keyword)&&(p.value=="setBottom"))) {
 	testParenOpen(counter);
	returnValue i=calculate(counter,keyword_);
	testParenClose(counter);
	c->setBottom(i.getInt());
  	}
 else {
  	error->addItem(tr("Class rect has no member")+p.value,1,message((*counter)));
	throw 1;
 	}
 if (left)  if (!checkSemicolon(counter)) {throw 15;}  
 return ret;
}


