/***************************************************************************
 *   Copyright (C) 2009 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 ***************************************************************************/

#include "parservalue.h"
#include "keywords.h"
#include "general/errorreport.h"
#include "general/drawingfield.h"

#include "net/netlist.h"




void macro::netListHandler_registerKeywords(keywords **keyword_){
  *keyword_= new keywords(*keyword_);
 (*keyword_)->keyword="netList";
 (*keyword_)->type=type;
 (*keyword_)->typeHandler=&macro::netListHandler_typeHandler;
}

void macro::netListHandler_typeHandler(int *counter,keywords **keyword_,bool single){
generalTypeProcessing(counter,keyword_,ptrNetList,varNetList,single);
}

returnValue macro::netListHandler_classHandler(int *counter, keywords *keyword_,returnValue *r,bool left){
 QString s;
 returnValue ret;
 parserValue p;
 if (r->type==ptrNetList){
   if (checkClassPointer(counter)) {
   }
   else { 
   	if (left) { compute(r,counter,keyword_);return ret;}
     	else return *r;
	}
   }
 else throw 1;
 netList *d= r->getNetList();
 p=next(counter);
//variables
 // variables
 if ((p.type==keyword)&&(p.value=="cellname")){
 		returnValue r2;
		r2.type=varString;
		r2.deleteAfter=false;
		r2.s=&(d->cellname);
		r2=stringHandler_classHandler(counter,keyword_,&r2,left);
		return r2;}
 // methods

 else if (((p.type==keyword)&&(p.value=="getExternalNodes"))) { testParenOpen(counter); 
	testParenClose(counter);
	ret.setStringList(d->getExternalNodes());
	ret=stringListHandler_classHandler(counter,keyword_,&ret,false);
	}
 else if (((p.type==keyword)&&(p.value=="getNodes"))) { testParenOpen(counter); 
	testParenClose(counter);
	ret.setStringList(d->getNodes());
	ret=stringListHandler_classHandler(counter,keyword_,&ret,false);
	}
 else if (((p.type==keyword)&&(p.value=="devicesCount"))) { testParenOpen(counter); 
	testParenClose(counter);
	ret.setInt(d->devicesCount());
	}
 else if (((p.type==keyword)&&(p.value=="getDevice"))) { testParenOpen(counter); 
	returnValue pos1=calculate(counter,keyword_);testParenClose(counter);
	ret.setPtrNetListDevice(d->getDevice(pos1.getInt()));
	ret=netListDeviceHandler_classHandler(counter,keyword_,&ret,false);
	}
 else if (((p.type==keyword)&&(p.value=="getNode"))) { testParenOpen(counter); 
	returnValue pos1=calculate(counter,keyword_);testParenClose(counter);
	ret.setInt(d->getNode(pos1.getString()));
	}
 else {
  	error->addItem(tr("Class netlist has no member ")+p.value,1,message((*counter)));
	throw 1;
 	}
 if (left)  if (!checkSemicolon(counter)) {throw 15;}  
 return ret;
}


