/***************************************************************************
 *   Copyright (C) 2005 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "file.h"
#include <QTextStream>
#include <QDir>

file::file()
{
opened=false;
}

file::~file()
{
}

bool file::open(bool mode){
  if (opened) return false;
  File.setFileName(filename);
  bool b;
  if (mode) {
	b=File.open(QIODevice::ReadOnly);
	}
  else {
	b=File.open(QIODevice::WriteOnly);
	}
 if (b) opened=true;
 return b;
}

QString file::read(){
  if (!opened) return QString("");
  QTextStream stream(&File);
  return stream.readAll();
}

void file::write(QString s){
  if (!opened) return ;
  QTextStream stream(&File);
  stream<<s;
}

void file::close(){
  File.close();
  opened=false;
}

void file::find(QString p,QString s){
  QDir dir = QDir::root();
  if (!dir.cd(p)) { dir.home(); path=dir.homePath(); }
  path=dir.path();
  dir.setFilter(QDir::Files );
  QStringList l;
  l<<s;
  list = dir.entryList(l);
  num=0;
  return findNext();
}

void file::findDir(QString p,QString s){
  QDir dir = QDir::root();
  if (!dir.cd(p)) { dir.home(); path=dir.homePath(); }
  path=dir.path();
  dir.setFilter(QDir::Dirs|QDir::Hidden);
  QStringList l;
  l<<s;
  list = dir.entryList(l);
  num=0;
  return findNext();
}

void file::findNext(){
if (num<list.size()) {filename=path+"/"+list.at(num);}
else filename="";
 num++;
}


void file::setCurrentPath(QString path){
QDir::setCurrent(path);
}

QString file::currentPath(){
return QDir::currentPath();
}

QString file::homePath(){
return QDir::homePath();
}

QString file::tempPath(){
return QDir::tempPath();
}

bool  file::exists(){
QFile f(filename);
if (f.exists()) return true;
return false;
}

bool file::remove(){
  return QFile::remove(filename);
}
