/***************************************************************************
 *   Copyright (C) 2005 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "parservalue.h"
#include "keywords.h"
#include "general/errorreport.h"
#include "general/drawingfield.h"

#include "drc/drc.h"




void macro::drcHandler_registerKeywords(keywords **keyword_){
  *keyword_= new keywords(*keyword_);
 (*keyword_)->keyword="drc";
 (*keyword_)->type=type;
 (*keyword_)->typeHandler=&macro::drcHandler_typeHandler;
}

void macro::drcHandler_typeHandler(int *counter,keywords **keyword_,bool single){
generalTypeProcessing(counter,keyword_,ptrDrc,ptrDrc,single);
}

returnValue macro::drcHandler_classHandler(int *counter, keywords *keyword_,returnValue *r,bool left){
 QString s;
 returnValue ret;
 parserValue p;
 if (r->type==ptrDrc){
   if (checkClassPointer(counter)) {
   }
   else { 
   	if (left) { compute(r,counter,keyword_);return ret;}
     	else return *r;
	}
   }
 else if (r->type==varDrc){
     if (checkDot(counter)) {
   }
   else {
   	if (left) {compute(r,counter,keyword_);return ret;}
     	else return *r;
	}
    }
 drc *d= r->getDrc();
 p=next(counter);
 // variables
 if ((p.type==keyword)&&(p.value=="errorLayer")){
 		returnValue r2;
		r2.type=varInt;
		r2.deleteAfter=false;
		r2.i=&(d->errorLayer);
		if (left) compute(&r2,counter,keyword_);
		else ret=r2;
		return ret;}
 else if ((p.type==keyword)&&(p.value=="errorCount")){
 		returnValue r2;
		r2.type=varInt;
		r2.deleteAfter=false;
		r2.i=&(d->errorCount);
		if (left) compute(&r2,counter,keyword_);
		else ret=r2;
		return ret;}
 else if ((p.type==keyword)&&(p.value=="error")){
 		returnValue r2;
		r2.type=varInt;
		r2.deleteAfter=false;
		r2.i=&(d->error);
		if (left) compute(&r2,counter,keyword_);
		else ret=r2;
		return ret;}
 else if ((p.type==keyword)&&(p.value=="ruleName")){
 		returnValue r2;
		r2.type=varString;
		r2.deleteAfter=false;
		r2.s=&(d->ruleName);
		r2=stringHandler_classHandler(counter,keyword_,&r2,left);
		return r2;}
 else if ((p.type==keyword)&&(p.value=="result")){
 		returnValue r2;
		r2.type=varString;
		r2.deleteAfter=false;
		r2.s=&(d->result);
		r2=stringHandler_classHandler(counter,keyword_,&r2,left);
		return r2;}
 // methods
 else if (((p.type==keyword)&&(p.value=="setErrorLayerToActiveLayer"))) { testParenOpen(counter); testParenClose(counter);
	d->setErrorLayerToActiveLayer();}
 else {
  	error->addItem(tr("Class drc has no member ")+p.value,1,message((*counter)));
	throw 1;
 	}
 if (left)  if (!checkSemicolon(counter)) {throw 15;}  
 return ret;
}

