/***************************************************************************
 *   Copyright (C) 2008 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "parservalue.h"
#include "keywords.h"
#include "general/errorreport.h"
#include "general/drawingfield.h"

#include "barcode/barcodemodule.h"




void macro::barcodeModuleHandler_registerKeywords(keywords **keyword_){
  *keyword_= new keywords(*keyword_);
 (*keyword_)->keyword="barcodeModule";
 (*keyword_)->type=type;
 (*keyword_)->typeHandler=&macro::barcodeModuleHandler_typeHandler;
}

void macro::barcodeModuleHandler_typeHandler(int *counter,keywords **keyword_,bool single){
generalTypeProcessing(counter,keyword_,ptrBarcodeModule,ptrBarcodeModule,single);
}

returnValue macro::barcodeModuleHandler_classHandler(int *counter, keywords *keyword_,returnValue *r,bool left){
 QString s;
 returnValue ret;
 parserValue p;
 if (r->type==ptrBarcodeModule){
   if (checkClassPointer(counter)) {
   }
   else { 
   	if (left) { compute(r,counter,keyword_);return ret;}
     	else return *r;
	}
   }
 else throw 1;
 barcodeModule *d= r->getBarcodeModule();
 p=next(counter);
 // methods
 if (((p.type==keyword)&&(p.value=="data"))) {	
		returnValue r2;
		r2.type=varString;
		r2.deleteAfter=false;
		r2.s=&d->data;
		if (left) compute(&r2,counter,keyword_);
		else ret=r2;
		return ret;}
 else if (((p.type==keyword)&&(p.value=="ratio"))) { 
		returnValue r2;
		r2.type=varDouble;
		r2.deleteAfter=false;
		r2.d=&d->ratio;
		if (left) compute(&r2,counter,keyword_);
		else ret=r2;
		return ret;}
 else if (((p.type==keyword)&&(p.value=="placeBarcode"))) { testParenOpen(counter); 	
	returnValue par1=calculate(counter,keyword_);testComma(counter);
	returnValue par2=calculate(counter,keyword_);testParenClose(counter);
	d->placeBarcode(*par1.getPoint(),*par2.getPoint());}
 else if (((p.type==keyword)&&(p.value=="addBarcode"))) { testParenOpen(counter);
	returnValue par1=calculate(counter,keyword_);testParenClose(counter);
	d->addBarcode(par1.getString());}
 else if (((p.type==keyword)&&(p.value=="setCode39"))) { testParenOpen(counter);
	testParenClose(counter);
	d->setCode39();}
 else  if (((p.type==keyword)&&(p.value=="setCode39Mod43"))) { testParenOpen(counter); 
	testParenClose(counter);
	d->setCode39Mod43();}
 else if (((p.type==keyword)&&(p.value=="setCode128"))) { testParenOpen(counter);
	testParenClose(counter);
	d->setCode128();}
 else if (((p.type==keyword)&&(p.value=="setCode128A"))) { testParenOpen(counter);
	testParenClose(counter);
	d->setCode128A();}
 else if (((p.type==keyword)&&(p.value=="setCode128B"))) { testParenOpen(counter);
	testParenClose(counter);
	d->setCode128B();}
 else if (((p.type==keyword)&&(p.value=="setCode128C"))) { testParenOpen(counter);
	testParenClose(counter);
	d->setCode128C();}
 else if (((p.type==keyword)&&(p.value=="setDatamatrix"))) { testParenOpen(counter);
	testParenClose(counter);
	d->setDatamatrix();}
 
 else {
  	error->addItem(tr("Class barcodemodul has no member ")+p.value,1,message((*counter)));
	throw 1;
 	}
 if (left)  if (!checkSemicolon(counter)) {throw 15;}  
 return ret;
}



