/***************************************************************************
 *   Copyright (C) 2006 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "userunitsvalidator.h"

userunitsValidator::userunitsValidator(QObject * parent)
    : QValidator(parent)
{
    d = 0;
    uunit=1;
}



userunitsValidator::userunitsValidator(double userunits, QObject * parent)
    : QValidator(parent)
{
   uunit=userunits;
   calDecimals();
}


userunitsValidator::~userunitsValidator()
{
}


void userunitsValidator::calDecimals(){
  int digits=0;
  d=0;
  double h=uunit;
  if (h<=0) return;
  while (h<1) { h*=10; digits++;}
  d=digits;
}

QValidator::State userunitsValidator::validate(QString & input, int &) const
{   if (input.size()>11) return Invalid;
	QString di;
	di.setNum(d);
    QRegExp empty(QString::fromLatin1("-{0,1}\\d{0,11}\\.{0,1}\\d{0,"+di.toAscii()+"}"));
    if (input.contains(' '))
        return Invalid;
   // if (b >= 0 && input.startsWith(QLatin1Char('-')))
   //     return Invalid;
    if (empty.exactMatch(input))
        return Acceptable;
    bool ok = true;
    double entered = input.toDouble(&ok);
//printf("%f %d\n",entered,d);
    int nume = input.count('e', Qt::CaseInsensitive);
    if (nume==0) return Invalid;
    if (!ok) {
        // explicit exponent regexp
        QRegExp expexpexp(QString::fromLatin1("[Ee][+-]?(\\d*)$"));
        int eePos = expexpexp.indexIn(input);
        if (eePos > 0 && nume == 1) {
            QString mantissa = input.left(eePos);
            entered = mantissa.toDouble(&ok);
            if (!ok)
                return Invalid;
            if (expexpexp.cap(1).isEmpty())
                return Intermediate;
        } else if (eePos == 0) {
            return Intermediate;
        } else {
            return Invalid;
        }
    }
    int i = input.indexOf('.');
    if (i >= 0 && nume == 0) {
        // has decimal point (but no E), now count digits after that
        i++;
        int j = i;
        while(input[j].isDigit())
            j++;
        if (j - i > d)
            return Intermediate;
    }

    //if (entered < b || entered > t)
     //   return Intermediate;
    return Acceptable;
}







void userunitsValidator::setUserunits(double userunits)
{
  if (userunits==uunit) return;
    uunit=userunits;
    calDecimals();
}



void userunitsValidator::setDecimals(int decimals)
{
    d= decimals;
}
