/***************************************************************************
 *   Copyright (C) 2004 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef TEXTRENDER_H
#define TEXTRENDER_H
//#in clude <ft2build.h>
//#in clude FT_FREETYPE_H
#include <QMutex>
#include <QList>
#include "elements/pointarray.h"
#include <QStringList>

typedef struct FT_LibraryRec_  *FT_Library;
typedef struct FT_FaceRec_*  FT_Face;
/**
@author Juergen Thies
*/

class textRender{
public:
	textRender();
	~textRender();

	static void reset();
	static QStringList internalFonts;
	bool libraryInit();
	bool initFace();
	bool initFallBackFace();
    bool available();
	QList<pointArray> renderText(QString s, int width, int presentation, QPoint point, strans trans );
protected:
static int fontNum;
int currentFontNum;
bool libraryInitDone;
bool fallBackInitDone;
bool fallBackFound;
FT_Library library;
FT_Face face;
FT_Face fallbackFace;

static void bezier2(double px0, double py0,double px1, double py1,double px2, double py2,int depth, pointArray *a, int maxDepth);
static void bezier3(double px0, double py0,double px1, double py1,double px2, double py2,double px3, double py3,int depth, pointArray *a,int maxDepth);

};

#endif
