/***************************************************************************
 *   Copyright (C) 2005 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "paintpixmapthread.h"
#include "drawingfield.h"
#include "elements/cell.h"
#include "elements/celllist.h"
#include "general/layoutimagepainter.h"
#ifdef SCHEMATIC
#include "schematic/sheet.h"
#include "schematic/schematicdisplay.h"
#endif
paintPixmapThread::paintPixmapThread(drawingField* dr)
 : QThread(),drawpixmap(1,1,1,1,0.001)
{
//  restart=false;
 // close=false;
  d=dr;
  paintAbort=&abort;
  abort=false;
  timer.setSingleShot(true);
  connect(&timer,SIGNAL(timeout()),this,SLOT(updates()));
  connect(this,SIGNAL(timerStart(int)),&timer,SLOT(start(int)),Qt::QueuedConnection);
#ifdef multithread
        setMultiThread();
	paintDetailsLast=1;
#endif	

}
#ifdef SCHEMATIC
paintPixmapThread::paintPixmapThread(schematicDisplay* sc)
 : QThread(),drawpixmap(1,1,1,1,0.5)
{
//  restart=false;
 // close=false;
  d=NULL;
  schem=sc;
  paintAbort=&abort;
  abort=false;
  timer.setSingleShot(true);
  connect(&timer,SIGNAL(timeout()),this,SLOT(updates()));
  connect(this,SIGNAL(timerStart(int)),&timer,SLOT(start(int)),Qt::QueuedConnection);
#ifdef multithread
  setMultiThread();
#endif	

}
#endif

paintPixmapThread::~paintPixmapThread()
{
	endPaint();

}

void paintPixmapThread::updates(){
	if (isRunning()){
		emit updateRequest();
		timer.start(200);
	}
}

void paintPixmapThread::startPaint(){

  //printf("6: %d ms\n", setup::centralTimer.elapsed());
     if (isRunning())  abortPaint();
#ifndef Q_OS_WIN32
		start(QThread::HighestPriority);
#else
		start(QThread::InheritPriority);
#endif
	emit timerStart(350);
}

void paintPixmapThread::abortPaint(){
  if (isRunning()){
	mutex.lock();
//   	restart = false;
  	mutex.unlock();
	abort=true;

   	//d->pixmap->paintAbort = true;
	wait();

	abort=false;
   	//d->pixmap->paintAbort = false;
  
  }
}

void paintPixmapThread::endPaint(){
	abortPaint();
}



void paintPixmapThread::run(){
//printf("paint start\n");
#ifdef printtime
  //setup::centralTimer.start();
#endif
  drawTime.start();
  if (d!=NULL){
  if (d->mutexPaintTryLock()) {
   	mutex.lock();
   	finnished=false;
   	mutex.unlock();
	//d->firstCell->paintInfoClear();
/*	cellList *e=d->firstCell;
    while (e!=NULL){
		e->thisCell->paintInfoClear();
		e=e->nextCell;
	}*/
   	drawPrepare();
	reset();
   	//drawTrans.translate(element::runden(1.0/drawTrans.mag),-element::runden(1.0/drawTrans.mag));
   	//image->fill(setup::backgroundColor.rgb());
   	//cellrefDepth=0;
   	if (setup::showGrid) imagePainter->drawGrid(d->gridX,d->gridY,d->gridOffsetX,d->gridOffsetY); 
 //printf("painta: %d ms\n", setup::centralTimer.elapsed());
	d->currentCell->paint(imagePainter,true);
 //printf("paintb: %d ms\n", setup::centralTimer.elapsed());

#ifdef multithread
	if (d->paintDetailLevel==0) {
		waitFinishedReduceDetails();
		paintDetailsLast=getDetailLevel();
		}
        else waitFinished();

	int usedTime=drawTime.elapsed();
	if ((usedTime<200)&&(!abort)&&(paintDetailsLast>1)&&(d->paintDetailLevel==0)){
		paintDetailsLast--;
		}
#endif	
	//if ((usedTime>600)&&(paintDetailsLast<4))
	//	paintDetailsLast++;
	if (d->mode==170){
		if ((d->paintNode>=0)&&(d->modestep==1)) d->currentCell->paintNode(d->paintNode,imagePainter);
		if ((d->paintDevice.isEmpty()==false)&&(d->modestep==2)) d->currentCell->paintDevice(d->paintDevice,imagePainter);
		if ((d->paintNode>=0)&&(d->paintDevice.isEmpty()==false)&&(d->modestep==3)) d->currentCell->paintDeviceNode(d->paintDevice,d->paintNode,imagePainter);

	}
 //printf("paintc: %d ms\n", setup::centralTimer.elapsed());
   	d->currentCell->paintSelect(imagePainter);
   imageChanged=true; // to ganantee a final update, due to problem on some systems
#ifdef printtime
 // printf("paint: %d ms\n", setup::centralTimer.elapsed());
#endif
  emit d->drawingTime(drawTime.elapsed());
   	emit updateRequest();
	d->mutexPaintUnlock();}
   mutex.lock();
   finnished=true;
   mutex.unlock();
   exit(0);}
   else {
//paint schematic
#ifdef SCHEMATIC
   	mutex.lock();
   	finnished=false;
   	mutex.unlock();
	if (schem->mutexPaintTryLock()){
	    drawPrepare();
	    reset();
	    schem->currentSheet->paint(imagePainter);
#ifdef multithread
	    waitFinished();
#endif	
	    schem->mutexPaintUnlock();
	    }
   	mutex.lock();
   	finnished=true;
   	mutex.unlock();
#endif
   	exit(0);
   }

}



