/***************************************************************************
 *   Copyright (C) 2010 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 ***************************************************************************/
#ifndef OAINFO_H
#define OAINFO_H 

#include <QStringList>

//!  openaccess info 
/*!
This class contains some methods giving information on the used OpenAccess library.
@nomacro
*/
class oaInfo: public QObject{
Q_OBJECT
public:
//! use OpenAccess
/*!
 returns true, if OpenAccess is available.
*/
static bool openAccess();
//! is OpenAccess Library
/*!
 returns true, if it is a valid openAccess library
*/
static bool isLib(QString name,QString path);
//! is OpenAccess Library
/*!
 returns true, if path contains a valid openAccess library
*/
static bool isLib(QString path);
//! OpenAccess Library Name
/*!
 returns the name of the given library. If empy it is no valid library.
*/
static QString getLibName(QString path); 
//! OpenAccess Library Cell
/*!
 returns a list of all cell in the library
*/
static QStringList getCellNames(QString lib); 
//! OpenAccess Library CellViews
/*!
 returns a list of all view in the cell
*/
static QStringList getViewNames(QString lib,QString cell); 
//! OpenAccess CellView Type
/*!
 returns a the type of the given cellview
*/
static QString getViewType(QString lib,QString cell,QString view); 
};

#endif

