/***************************************************************************
 *   Copyright (C) 2010 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 ***************************************************************************/
#include "general/oainfo.h"

#ifdef OPENACCESS
#include "oa/oaconvert.h"
#endif
#include <QFileInfo>

bool oaInfo::openAccess(){
#ifdef OPENACCESS
return true;
#endif
return false;
}

bool oaInfo::isLib(QString path){
#ifdef OPENACCESS
return oaLib::exists(oaString(path.toAscii().data()));
#endif
return false;
}

bool oaInfo::isLib(QString name,QString path){
#ifdef OPENACCESS
  return oaConvert::checkLib(name,path);
#endif  
  return false;
}


QString oaInfo::getLibName(QString path){
#ifdef OPENACCESS
QFileInfo fi(path);
if (!fi.isDir()) return QString("");
int i=path.lastIndexOf("/");
if (i<0) return QString("");
QString name=fi.fileName();
bool b=oaConvert::checkLib(name,path);
if (b) return name;
#endif
return QString();
}

QStringList oaInfo::getCellNames(QString lib){
#ifdef OPENACCESS
return oaConvert::getCells(lib);
#endif
return QStringList();
}

QStringList oaInfo::getViewNames(QString lib,QString cell){
#ifdef OPENACCESS
return oaConvert::getViews(lib,cell);
#endif
return QStringList();
}

QString oaInfo::getViewType(QString lib,QString cell,QString view){
#ifdef OPENACCESS
return oaConvert::getViewType(lib,cell,view);
#endif
return QString();
}
