/***************************************************************************
 *   Copyright (C) 2008 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef LAYOUTIMAGEPAINTER_H
#define LAYOUTIMAGEPAINTER_H
//#in clude <ft2build.h>
//#in clude FT_FREETYPE_H
#include "elements/element.h"
#include "elements/pointarray.h"
#include "general/textrender.h"
#include <QImage>

/**
	@author Juergen Thies <layout@juergenthies.de>
*/
class elementList;
class element;
class layoutImage;
  typedef struct  FT_Bitmap_ FT_Bitmap;
class layoutImagePainter:public textRender{
public:
    layoutImagePainter(layoutImage *im);

virtual ~layoutImagePainter();


virtual void drawPolygon(pointArray *p,uint color,uint style);
virtual void drawPolygon(pointArray *p,uint color);
virtual void drawPoint(QPoint p,uint color);
virtual void drawPixel(QPoint p,uint color);
virtual void drawDot(QPoint p,uint color);
virtual void drawTarget(QPoint p,uint color);
virtual void drawRing(QPoint p,uint color);
virtual void drawLine(QPoint p1, QPoint p2,uint color);
virtual void drawCircle(QPoint p1, QPoint p2,uint color);
virtual void drawArc(QPoint p1, QPoint p2,QPoint p3,uint color);
virtual void drawElement(element *e);
virtual void drawImage(QImage i,int x ,int y);
virtual void drawFTBitmap(FT_Bitmap *b,int x ,int y,uint color);
virtual void drawGrid(int gridX,int gridY,int gridOffsetX, int gridOffsetY);
virtual void drawText(QString s, int width,  QPoint point, strans trans,uint color);

bool visibleBox(const QPoint p1, const QPoint p2);
bool visiblePoint(QPoint p1);

int drawPixelSize;
pointArray drawBox;
int cellrefDepth;
bool *paintAbort;
strans drawTrans;
quint8 detailLevel;
void setTrans(strans drawTrans);

void resize();
#ifdef multithread
 void delegate(elementList *, int num);
 bool multiThreadDraw();
#endif

protected:
static bool defaultAbort;
layoutImage *LImage;
QImage *image;
uint color;
uint fillStyle;

int w,h;
int maxX, maxY, minX, minY;
int pmaxX, pmaxY, pminX, pminY;

QImage *fill;

bool dir;

uint outSize;
pointArray *in;
pointArray out;

bool elementDraw;
element *elementToDraw;

bool convert();
bool convertFill();
virtual void drawLineLimit(QPoint p1, QPoint p2);
virtual void drawLine(QPoint p1, QPoint p2);
virtual void drawLineFill(QPoint p1, QPoint p2);
void setLimits() {
	w=fill->width();
	h=fill->height();
	maxX=w-1;
	maxY=h-1;
	minX=0;
	minY=0;}
QPoint limit(QPoint);
QPoint raster(QPoint pos,int gridX,int gridY,int gridOffsetX, int gridOffsetY);
void drawElement();
  private:
    inline bool visibleBoxFull(const QPoint p1, const QPoint p2);
    inline bool visibleBoxFast(const QPoint p1, const QPoint p2);
friend class cell;
};

#endif
