/***************************************************************************
 *   Copyright (C) 2004 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "errorreport.h"
#include "reportview.h"
#include "reportitem.h"
#include "general/setup.h"

QString errorreport::lastReport;
int errorreport::lastRang;

errorreport::errorreport(QObject *parent, const char *)
 : QObject(parent)
{
items=new reportitem();
}


errorreport::~errorreport()
{
delete items;
}

void errorreport::setTitle(const QString &titel){
  title=titel;
}

void errorreport::addItem(const QString &type, int rang,const QString &value){
 items->insert(type,rang,value);
  }

void errorreport::generateReport(){
report=title+"\n\n";
bool added;
int rang=0;
QString s;
for (int i=0;i<5;i++){
	added=false;
	reportitem *r=items->next;
	while (r!=NULL) {
		if (r->rang==i) {
			if (!(added)) {
				added=true;
				switch (i) {
				case 0: 
					report+="Fatal errors:\n\n";
					break;
				case 1: 
					report+="Errors:\n\n";
					break;
				case 2: 
					report+="Strong warnings:\n\n";
					break;
				case 3: 
					report+="Warnings:\n\n";
					break;
				case 4: 
					report+="Informations:\n\n";
					break;
				}
				}
			report+=s.setNum(r->count)+" "+r->type;
			if (!(r->value.empty())){
				report+=" (";
				r->value.sort();
    				for ( QStringList::Iterator it = r->value.begin(); it != r->value.end(); ++it ) {
					report+= *it+",";
					}
				report=report.left(report.length()-1);
				report+=")";
				}
			report+="\n";
			}
		r=r->next;
		}
	if (added) report+="\n\n";
	else if (rang==i) rang=i+1; 
	}
lastRang=rang;
lastReport=report;	
}

void errorreport::showReport(){
  generateReport();
  if (lastRang<=setup::showReport) {
 		 reportview r(report);
 		 r.exec();
		 }
} 

QString errorreport::getReport(){
 generateReport();
 return report;
}

void errorreport::showLastReport(){
  reportview r(lastReport);
  r.exec();
}

int errorreport::getLastRang(){
  return lastRang;
}

QString errorreport::getLastRangString(){
switch (lastRang) {
	case 0: 
		return "with fatal errors";
		break;
	case 1: 
		return "with errors";
		break;
	case 2: 
		return "with strong warnings";
		break;
	case 3: 
		return "with warnings";
		break;
	case 4: 
		return "with informations";
		break;
	}
return "";
}

