/***************************************************************************
 *   Copyright (C) 2008 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef PIXEL_H
#define PIXEL_H
#include "general/layers.h"
#include <qobject.h>
#include "general/errorreport.h"
#include "filegeneral.h"
/**
@author Juergen Thies
*/
class drawingField;

class pixel : public QObject
{
Q_OBJECT
public:
    pixel(QObject *parent = 0, const char *name = 0);

    ~pixel();
static void open(QString filename,drawingField *);
static void import(QString filename,drawingField *);
static void update(QString filename,drawingField *);
static void save(QString filename,drawingField *);
static drawingField *df;
private:
errorreport report;
void load(QString filename,drawingField *,  fileOpenType type);
QImage *image;
int posX,posY;
int layer;
int Space;
pointArray pa;
bool add;
void addPolygonH();
void addPolygonV();
};

#endif
