/***************************************************************************
 *   Copyright (C) 2004 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include "textproperties.h"
#include <qspinbox.h>
#include <qlineedit.h>
#include "general/setup.h"
#include <qradiobutton.h>
#include <qstring.h>
#include "text.h"
#include <qcheckbox.h>
#include <qvalidator.h>
#include <qpushbutton.h>
#include "elements/element.h"
#include "elements/text.h"
#include "general/drawingfield.h"
#include "general/userunitsvalidator.h"
#include "propertyedit.h"

textproperties::textproperties(drawingField *dr)
: textpropertiesdialog()
{setupUi(this);
d=dr;
layerNr->setMaximum(layersMax-1);
layerNr->setMinimum(0);
userunits=d->userunits;
userunitsValidator v(d->userunits,this);
decimals=v.decimals();
connect(layerNr,SIGNAL(valueChanged(int)),this,SLOT(setLayerName(int)));
connect(toPolygon,SIGNAL( clicked()),this,SLOT(DoneToPolygon()));
connect(deleteText,SIGNAL( clicked()),this,SLOT(DoneDeleteText()));
mag->setValidator(new QDoubleValidator(0.000001,1000000000,6,mag));
angle->setValidator(new QDoubleValidator(0,360,3,angle));
orginX->setValidator(new userunitsValidator(d->userunits,orginX));
orginY->setValidator(new userunitsValidator(d->userunits,orginY));
textWidth->setDecimals(decimals);
connect(mag,SIGNAL(textChanged(const QString &)),this,SLOT(checkInput(const QString &)));
connect(angle,SIGNAL(textChanged(const QString &)),this,SLOT(checkInput(const QString &)));
connect(orginX,SIGNAL(textChanged(const QString &)),this,SLOT(checkInput(const QString &)));
connect(orginY,SIGNAL(textChanged(const QString &)),this,SLOT(checkInput(const QString &)));
connect(textWidth,SIGNAL(valueChanged(const QString &)),this,SLOT(checkInput(const QString &)));
connect(attributeButton,SIGNAL(clicked()),this,SLOT(showAttributes()));
connect(selectFont,SIGNAL(clicked()),this,SLOT(selectFontSlot()));
connect(fullDisplay,SIGNAL( clicked()),this,SLOT(displayAll()));
setModal(true);
}

textproperties::~textproperties()
{
}

/*$SPECIALIZATION$*/
void textproperties::reject()
{
  QDialog::reject();
}

void textproperties::accept()
{
  updateElement();
  QDialog::accept();
}

void textproperties::selectFontSlot(){
emit d->requestFontSetup();
}

void textproperties::updateElement(){
  element->layerNum=layerNr->value();
  element->datatype=datatype->value();
  if (textWidth->value()>0) element->width=element::round(textWidth->value()/userunits);
  else element->width=(int)textWidth->value();
  element->name=textname->text();
  element->point=point;
  element->trans=trans;
  if (topLeft->isChecked()) {element->presentation=0;}
  else if (topCenter->isChecked()) {element->presentation=1;}
  else if (topRight->isChecked()) {element->presentation=2;}
  else if (centerLeft->isChecked()) {element->presentation=4;}
  else if (centerCenter->isChecked()) {element->presentation=5;}
  else if (centerRight->isChecked()) {element->presentation=6;}
  else if (bottomLeft->isChecked()) {element->presentation=8;}
  else if (bottomCenter->isChecked()) {element->presentation=9;}
  else if (bottomRight->isChecked()) {element->presentation=10;}
  strans t;
  t.reset();
  t.scale(mag->text().toDouble());
  t.rotate(-angle->text().toDouble());
  if (mirror_x->isChecked()){t.toggleMirror_x();}
  element->trans=t;
  element->point=QPoint(element::round(orginX->text().toDouble()/userunits),element::round(orginY->text().toDouble()/userunits));
}

void textproperties::setElement(txt *p){
   element=p;
   layerNr->setValue(p->layerNum);
   datatype->setValue(p->datatype);
   bool hide_=true;
   if (p->datatype==0) {datatypeBox->hide();hide_=false;}
   setLayerName(p->layerNum);
   point=p->point;
   textWidth->setValue(p->width);
   if (p->width>0)
		{ 
	textWidth->setDecimals(decimals);
	textWidth->setValue((double)(p->width)*userunits);
	}
   else textWidth->setDecimals(0);
   trans=p->trans;
   textname->setText(p->name);
   switch (p->presentation){
   case 0: topLeft->setChecked(true);break;
   case 1: topCenter->setChecked(true);break;
   case 2: topRight->setChecked(true);break;
   case 4: centerLeft->setChecked(true);break;
   case 5: centerCenter->setChecked(true);break;
   case 6: centerRight->setChecked(true);break;
   case 8: bottomLeft->setChecked(true);break;
   case 9: bottomCenter->setChecked(true);break;
   case 10: bottomRight->setChecked(true);break;
   }
   QString s;
   s.setNum(p->trans.mag,'g',6);
   mag->setText(s);
   s.setNum(p->trans.angle,'g',6);
   angle->setText(s);
   if (p->trans.mirror_x){mirror_x->setChecked(true);}
   else {mirror_x->setChecked(false);}
   s.setNum((double)(p->point.x())*userunits,'f',decimals);
   orginX->setText(s);
   s.setNum((double)(p->point.y())*userunits,'f',decimals);
   orginY->setText(s);
   OK->setFocus();
   if (element->property.size()==0) attributeButton->hide();
   else if (hide_) fullDisplay->hide();
}


 void textproperties::displayAll(){
fullDisplay->hide();
datatypeBox->show();
attributeButton->show();
}

void textproperties::setLayerName(int val){
   layerName->setText(layers::num[val].name);
}

void textproperties::checkInput(const QString &){
QString s;
s=mag->text();
bool b=true;
int i=0;
   if (textWidth->value()>0) {
     textWidth->setDecimals(decimals);
     toPolygon->setEnabled(true);
   }
   else {
     textWidth->setDecimals(0);
     toPolygon->setEnabled(false);
   }
if (mag->validator()->validate(s,i)!=QValidator::Acceptable){b=false;}
s=angle->text();
if (angle->validator()->validate(s,i)!=QValidator::Acceptable){b=false;}
s=orginX->text();
if (orginX->validator()->validate(s,i)!=QValidator::Acceptable){b=false;}
s=orginY->text();
if (orginY->validator()->validate(s,i)!=QValidator::Acceptable){b=false;}
OK->setEnabled(b);
}

void textproperties::showAttributes(){
propertyEdit pe(&element->property);
pe.exec();
}
