/***************************************************************************
 *   Copyright (C) 2004 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef STRANS_H
#define STRANS_H

#include <qmatrix.h>

/**
@author Juergen Thies
*/

//! transformation
/*!
transformation used e.g. for placeing component
@nomacro
*/
class strans 
{
public:
//! create transformation
/*!
create a identical transformation
*/
    strans();
    ~strans();
    QMatrix matrix;
    double mag;
    double angle;
    bool mirror_x;
    QPoint mapDraw (const QPoint p)const;
    QPointF mapDrawF (const QPoint p)const;
public:
    void scale(const double d);
    void scale(const double x,const double y);
    void reset();
//! toggle mirror x
/*!
toggles the mirrow on the x axis
*/
    void toggleMirror_x();
//! set mirror x
/*!
set the mirror on the x axis
*/
    void setMirror_x();
//! clear mirror x
/*!
clears the mirror on the x axis
*/
    void clearMirror_x();
//! rotate
/*!
rotates with angle
*/
    void rotate(const double angle); 
    void translate(const int x, const int y);
    void invert();
    strans & operator*= (const strans &s);
    QPoint mapIn(QPoint p)const;
    QPoint mapOut(QPoint p)const;
    friend bool operator== (const strans &r1,const strans &r2);
    
};

#endif
