/***************************************************************************
 *   Copyright (C) 2008 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "shortselect.h"

shortSelect::shortSelect()
{
data=0;
}


shortSelect::~shortSelect()
{
}

void shortSelect::setBit(char bit){
	switch (bit){
		case 0: data|=1;
			return ;
		case 1: data|=2;
			return ;
		case 2: data|=4;
			return ;
		case 3: data|=8;
			return ;
	}
}


void shortSelect::clearBit(char bit){
	switch (bit){
		case 0: data&=254-128;
			return ;
		case 1: data&=253-128;
			return ;
		case 2: data&=251-128;
			return ;
		case 3: data&=247-128;
			return ;
	}
}

bool shortSelect::testBit(char bit){
	switch (bit){
		case 0: return (data&1)?true:false;
		case 1: return (data&2)?true:false;
		case 2: return (data&4)?true:false;
		case 3: return (data&8)?true:false;
	}
return false;
}
void shortSelect::setBit(char bit,bool b){
if (testBit(bit)&&(!b)) clearBit(bit);
else if((!testBit(bit))&&(b)) setBit(bit);

}

