/***************************************************************************
 *   Copyright (C) 2004 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include "pathproperties.h"
#include <qspinbox.h>
#include <qlineedit.h>
#include <QTableWidget>
#include <QTableWidgetItem>
#include "path.h"
#include "general/setup.h"
#include <qradiobutton.h>
#include <qstring.h>
#include <qstringlist.h>
#include <qpushbutton.h>
#include "general/userunitsvalidator.h"
#include "propertyedit.h"

pathproperties::pathproperties(double uunits)
: pathpropertiesdialog()
{
setupUi(this);
layerNr->setMaximum(layersMax-1);
layerNr->setMinimum(0);
userunits=uunits;
userunitsValidator v(uunits,this);
decimals=v.decimals();
QStringList l;
l<<"x";
l<<"y";
coordinates->setHorizontalHeaderLabels(l);
valid=new userunitsValidator(uunits,this);
centerX->setValidator(valid);
centerY->setValidator(valid);
radius->setValidator(valid);
connect(layerNr,SIGNAL(valueChanged(int)),this,SLOT(setLayerName(int)));
connect(coordinates,SIGNAL( itemClicked(QTableWidgetItem *)),this,SLOT(setEdit(QTableWidgetItem *)));
connect(toPolygon,SIGNAL( clicked()),this,SLOT(DoneToPolygon()));
connect(closeToPolygon,SIGNAL( clicked()),this,SLOT(DoneCloseToPolygon()));
connect(deletePath,SIGNAL( clicked()),this,SLOT(DoneDeletePath()));
connect(coordinates,SIGNAL(  currentItemChanged ( QTableWidgetItem * , QTableWidgetItem * )),this,SLOT(updateItem(QTableWidgetItem *,QTableWidgetItem *)));
connect(attributeButton,SIGNAL(clicked()),this,SLOT(showAttributes()));
connect(fullDisplay,SIGNAL( clicked()),this,SLOT(displayAll()));
connect(editPoints,SIGNAL( clicked()),this,SLOT( editPoint()));
connect(centerX,SIGNAL(textChanged(const QString &)),this,SLOT(checkInput(const QString &)));
connect(centerY,SIGNAL(textChanged(const QString &)),this,SLOT(checkInput(const QString &)));
connect(radius,SIGNAL(textChanged(const QString &)),this,SLOT(checkInput(const QString &)));
editType-> setCurrentIndex(0);
setModal(true);
}

pathproperties::~pathproperties()
{
centerX->setValidator(NULL);
centerY->setValidator(NULL);
radius->setValidator(NULL);
delete valid;
}

 void pathproperties::setEdit(QTableWidgetItem *i){
 coordinates->editItem(i);
 }
/*$SPECIALIZATION$*/
void pathproperties::reject()
{
  QDialog::reject();
}

void pathproperties::updateElement(){
 if (editType-> currentIndex()!=0) editPoint();
 coordinates->setCurrentItem(NULL);
 element->layerNum=layerNr->value();
 element->datatype=datatype->value();
  element->width=abs(element::round(pathWidth->value()/userunits));
  if (noCaps->isChecked()){element->cap=0;}
  if (roundCaps->isChecked()){element->cap=1;}
  if (squareCaps->isChecked()){element->cap=2;}
   if (array.size()>0) element->pointarray=array;
}

void pathproperties::accept()
{ updateElement();
  QDialog::accept();
  
}

void pathproperties::setElement(path *p,bool basicEditing){
   element=p;
   layerNr->setValue(p->layerNum);
   datatype->setValue(p->datatype);
   bool hide_=true;
   if (p->datatype==0) {datatypeBox->hide();hide_=false;}
   setLayerName(p->layerNum);
   array=p->pointarray;
   if (array.size()>MAXITEMS/2-1) array.resize(0);
   pathWidth->setDecimals(decimals);
   pathWidth->setValue((double)(p->width)*userunits);
   switch (p->cap){
   case 0: noCaps->setChecked(true);
   	break;
   case 1: roundCaps->setChecked(true);
   	break;
   case 2: squareCaps->setChecked(true);
   	break;
   }
   if (!basicEditing)
   if (p->isArc(&center,&radiusValue,&startAngle,&endAngle)) {
	//printf("arc\n");
	numCirclePoints=array.size();
	setArc();
	}
   //coordinates->resizeColumnToContents(1);
   //coordinates->resizeColumnToContents(0);
   //coordinates->setColumnWidth(1,95);
   //coordinates->setColumnWidth(0,95);
   setCoordinates();
   OK->setFocus();
   if (element->property.size()==0) attributeButton->hide();
   else if (hide_) fullDisplay->hide();
}

 void pathproperties::displayAll(){
fullDisplay->hide();
datatypeBox->show();
attributeButton->show();
}

void pathproperties::setCoordinates(){
 QString s;
 coordinates->setRowCount(array.size());
 coordinates->setColumnCount(2);
 for (int i=0; i<array.size();i++){
	s.setNum((double)(array.point(i).x())*userunits,'f',decimals);
 	//s.setNum(array.point(i).x());
	item[i*2].setText(s);
	if (item[i*2].tableWidget()==NULL)coordinates->setItem(i,0,&item[i*2]);
	//s.setNum(array.point(i).y());
	s.setNum((double)(array.point(i).y())*userunits,'f',decimals);
	item[i*2+1].setText(s);
	if (item[i*2+1].tableWidget()==NULL) coordinates->setItem(i,1,&item[i*2+1]);
 }
 //coordinates->resizeColumnsToContents ();
 coordinates->resizeColumnToContents(1);
 coordinates->resizeColumnToContents(0);
}





void pathproperties::updateItem(QTableWidgetItem *,QTableWidgetItem *c){
if (c!=NULL){
  if ( coordinates->column(c)==0)
  array.setPoint(coordinates->row(c),element::round(c->text().toDouble()/userunits),array.point(coordinates->row(c)).y());
  else 
  array.setPoint(coordinates->row(c),array.point(coordinates->row(c)).x(),element::round(c->text().toDouble()/userunits));
  setCoordinates();}

}


void pathproperties::setLayerName(int val){
   layerName->setText(layers::num[val].name);
}

void pathproperties::showAttributes(){
propertyEdit pe(&element->property);
pe.exec();
}

void pathproperties::editPoint(){
   for (int i=0; i<array.size();i++){
	if (item[i*2].tableWidget()!=NULL)coordinates->takeItem(i,0);
	if (item[i*2+1].tableWidget()!=NULL)coordinates->takeItem(i,1);
   }
  if (editType->currentIndex()==1){
	center=QPoint(element::round(centerX->text().toDouble()/userunits), element::round(centerY->text().toDouble()/userunits));
	radiusValue=element::round(radius->text().toDouble()/userunits);
	numCirclePoints=numPoints->value();
	startAngle=angleStart->value();
	endAngle=angleEnd->value();
	QMatrix m1,m2;
	m1.rotate(startAngle);
	m2.rotate(endAngle);
	double l=endAngle-startAngle;
	if (l<=0) l+=360;
	array=element::spirale(center,center+m1.map(QPoint(radiusValue,0)), center+m2.map(QPoint(radiusValue,0)),l/(numCirclePoints-1));
	}
  editType-> setCurrentIndex(0);
  setCoordinates();
}

void pathproperties::setArc(){
editType-> setCurrentIndex(1);
   QString s;
   s.setNum((double)(center.x())*userunits,'f',decimals);
   centerX->setText(s);
   s.setNum((double)(center.y())*userunits,'f',decimals);
   centerY->setText(s);
   s.setNum((double)(radiusValue)*userunits,'f',decimals);
   radius->setText(s);
   numPoints->setValue(numCirclePoints);
   angleStart->setValue(startAngle);
   angleEnd->setValue(endAngle);
}

void pathproperties::checkInput(const QString &){
if (editType->currentIndex()==1){
	QString s;
	bool b=true;
	int i=0;
	s=centerX->text();
	if (centerX->validator()->validate(s,i)!=QValidator::Acceptable){b=false;}
	s=centerY->text();
	if (centerY->validator()->validate(s,i)!=QValidator::Acceptable){b=false;}
	s=radius->text();
	if (radius->validator()->validate(s,i)!=QValidator::Acceptable){b=false;}
	OK->setEnabled(b);
	}
}
