/***************************************************************************
 *   Copyright (C) 2010 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 ***************************************************************************/
#ifndef ELEMENTITERATOR_H
#define ELEMENTITERATOR_H

#include "element.h"
#include "strans.h"
#include "cell.h"
#include <QStack>
/**
@author Juergen Thies
*/

class classHierachieIterator{
  public:
  elementList *el;
  strans matrix;
  int ix,iy;
  //QPoint refMin, refMax;
  bool array;
  classHierachieIterator(){el=NULL;ix=0;iy=0;array=false;matrix.reset();}
};

enum iteratorType{iteratorShapeOnLayer,iteratorShapeOnLayerRegion,iteratorShape,iteratorShapeRegion};

class elementIterator{
public:
    elementIterator(cell*,iteratorType,int l=0);
    elementIterator(const elementIterator &);
    ~elementIterator();

    
    bool next();
    void copyElement(cell *workCell);
    
    element *e;
    iteratorType type;
    cell *iteratorCell;
    int layer;
    classHierachieIterator currentMap;
    void setRegion(QPoint min,QPoint max);
    void toPolygon();
  private:
    void init();
    QPoint rMin,rMax;
    inline bool levelUp();
    inline void levelDown();
    void clear();
    inline void prepare();
    inline bool process();
    inline void next_();
    bool start;
   
    QStack<classHierachieIterator> stack;
};

#endif
