/***************************************************************************
 *   Copyright (C) 2011 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 ***************************************************************************/
#include "drc/drcdock.h"
#include "drc/drcwidget.h"

#include <QResizeEvent>
#include <QBoxLayout>
#include <QPainter>
#include <QStyle>
#include <QStyleOption>
/**
@author Juergen Thies
*/
drcDock::drcDock(const QString & title)
 : QDockWidget(title)
{
 
 setObjectName(title);
 setFeatures(QDockWidget::AllDockWidgetFeatures);
 setWindowTitle (title);
//setWindowTitle (tr("GPL License"));
 drcsWidget=new drcWidget();
  drcsWidget->setGeometry(0,20,100,100);
  setWidget(drcsWidget);
  setMinimumSize(41,61);
  setMaximumSize(300,1500);
  setSizePolicy(QSizePolicy::Minimum,QSizePolicy::Maximum);
  setFeatures(QDockWidget::DockWidgetClosable|QDockWidget::DockWidgetMovable|QDockWidget::DockWidgetFloatable);
  


}


drcDock::~drcDock(){
delete drcsWidget;
}


void drcDock::resizeEvent ( QResizeEvent * e ){
  //printf("resize %d %d\n",e->size().width(),e->size().height());
  QDockWidget::resizeEvent(e);
  repaint();
}

void drcDock::paintEvent ( QPaintEvent * event ){
QDockWidget::paintEvent (event );
//if (resizeRuning) return;
}



