/***************************************************************************
 *   Copyright (C) 2005 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "drc.h"
#include <QFileDialog>
#include "general/drawingfield.h"
#include "widgets/selectwidget.h"
#ifdef BOOL_LAYOUT
#include "boolle/booleanhandler.h"
#else
#include "boolgpl/booleanhandler.h"
#endif
#include <qmessagebox.h>
#include "layout.h"
#include "elements/path.h"
#include "elements/polygon.h"
#include "elements/text.h"
#include "elements/celllist.h"
#include "elements/elementiterator.h"
#include "general/guiworkthread.h"
#include "drc/drcdock.h"
#include "dialog/helpwindow.h"
#include "general/paintpixmapthread.h"

#ifdef netlistutility
#endif

/*
drc::drc()
 : QObject()
{
errorLayer=0;
//booleanTool=new booleanHandler(drawing);
reportedErrors=NULL;
dock=NULL;
}*/

drc::~drc()
{
  if (dock!=NULL) {
  	for (int i=0;i<violationListItems.size();++i){
		delete violationListItems[i];
	}
	violationListItems.clear();
        delete dock;
  }
}


drc::drc(drawingField *dr,layout *lay):drcRegionMode(dr){
  booleanTool=new booleanHandler(dr,lay);
  //booleanTool->noMessage=true;
  errorLayer=0;
  d=dr;
  l=lay;
  ruleName="DRC-Rule";
  result="";
  reportedErrors=NULL;
  dock=NULL;
  updateDockRunning=false;updateDockRetrigger=false;
  drcToList=true;drcToCell=true;drcArea=drcCell;
  drcType=drcClearViolationHelp;
  connect (this,SIGNAL(finished(QPoint,QPoint)),this,SLOT(setCheckRegion(QPoint,QPoint)));
}

void drc::showDock(){
  if (dock==NULL) initDock();
  dock->show();
}

void drc::initDock(){
}

void drc::updateGui(){
  d->paint();
  d->recountSelect();
  emit d->cellsChange();
  d->setModifyAdded();
}

void drc::updateDock(){
  if (updateDockRunning){
    updateDockRetrigger=true;
    return;
  }
  updateDockRunning=true;
  updateDockRetrigger=false;
  dock->drcsWidget->drcListResults->setChecked(drcToList);
  dock->drcsWidget->drcPrintResults->setChecked(drcToCell);
  if (drcArea==drcCell)  dock->drcsWidget->drcCell->setChecked(true);
  else if (drcArea==drcRegion)  dock->drcsWidget->drcRegion->setChecked(true); 
  else if (drcArea==drcView)  dock->drcsWidget->drcView->setChecked(true); 
  // dock->drcsWidget->violationList
  if (violationList.size()<violationListItems.size()){
      	for (int i=0;i<violationListItems.size();++i){
		delete violationListItems[i];
	}
	violationListItems.clear();
  }
  for (int i=0;i<violationList.size();++i){
    QListWidgetItem *item;
    if (violationListItems.size()>i) item=violationListItems[i];
    else {
      item=new QListWidgetItem(dock->drcsWidget->violationList,i);
      violationListItems<<item;
      //printf("add %d %d %d\n",violationListItems.size(),violationList.size(),i);
    }
    QString s;
    s.setNum(violationList.at(i).value,'g');
    if (violationList.at(i).value!=0)
      s=violationList.at(i).rule+" ="+s;
    else s=violationList.at(i).rule;
    item->setText(s);
    if (violationList.at(i).status==0)
      item->setIcon(helpWindow::getIcon(violationList.at(i).check));
    else if (violationList.at(i).status==1)
      item->setIcon(QIcon(":/icons/ok.png"));
    else if (violationList.at(i).status==2)
      item->setIcon(QIcon(":/icons/deleteicon.xpm"));
    else
      item->setIcon(QIcon());
  }
  updateDockRunning=false;
  if (updateDockRetrigger) updateDock();
}


void drc::setRuleName(QString s){
 d->macroAdd("layout->drcTool->ruleName= \""+s+"\";");
 ruleName= s;
}

QString drc::getReport(){
QString r=result;
if (r.count("\n")>40){
	QStringList sl=r.split("\n");
	for (int i=sl.size()-1;i>=0;i--){
	  if (sl[i].indexOf("no errors")>0) {
		sl.removeAt(i);
		}
	}
	r=sl.join("\n");
	}
return r;
}

void drc::showReport(){
QString r=getReport();
QMessageBox::information(NULL,tr("Design Rule Checker"),r);
}


/*void drc::prepareCheck(bool copyMode){
}*/


/*void drc::completeCheck(){
}*/

void drc::prepareCheck(helpText drctype){
}

void drc::completeCheck(bool useWorkCell,bool reportWorkCell){
}

bool operator==(const drcErrorItem& e1,const drcErrorItem& e2){
  if (e1.rule!=e2.rule) return false;
  if (e1.check!=e2.check) return false;
  if (e1.value!=e2.value) return false;
  if ((e1.pos1==e2.pos1)&&(e1.pos2==e2.pos2)) return true;
  if ((e1.pos1==e2.pos2)&&(e1.pos2==e2.pos1)) return true;
  return false;
}

void drc::reportError(QPoint p1,QPoint p2, double value){
if (drcToCell){
  elementList *el=new elementList;
  el->nextElement=reportedErrors;
  pointArray pa;
  pa<<p1<<p2;
  el->thisElement=new path(pa,errorLayer);
  reportedErrors=el;
  el=new elementList;
  el->nextElement=reportedErrors;
  QString s;
  s.setNum(d->userunits*value,'g',6);
  el->thisElement=new txt(errorLayer,p1/2+p2/2,s);
  el->thisElement->setWidth(-15);
  reportedErrors=el;
}
if (drcToList){
  drcErrorItem ei(ruleName,drcType,d->userunits*value);
  ei.pos1=p1;ei.pos2=p2;
  bool add=true;
  for (int i=violationList.size()-10;i<violationList.size();++i){
    if (i>=0) if (ei==violationList.at(i)) add=false;
  }
  if (add) violationList<<ei;
}
countErrors++;
}



void drc::reportError(QPoint p, double value){
if (drcToCell){
  elementList *el=new elementList;
  el->nextElement=reportedErrors;
  QString s;
  s.setNum(d->userunits*value,'g',6);
  el->thisElement=new txt(errorLayer,p,s);
  el->thisElement->setWidth(-15);
  reportedErrors=el;
}
if (drcToList){
  drcErrorItem ei(ruleName,drcType,d->userunits*value);
  ei.pos1=p;ei.pos2=p;
  bool add=true;
  for (int i=violationList.size()-10;i<violationList.size();++i){
    if (i>=0) if (ei==violationList.at(i)) add=false;
  }
  if (add) violationList<<ei;
}
countErrors++;
}

void drc::reportErrorDeg(QPoint p, double value){
if (drcToCell){
  elementList *el=new elementList;
  el->nextElement=reportedErrors;
  QString s;
  s.setNum(value,'g',4);
  s+="";
  el->thisElement=new txt(errorLayer,p,s);
  el->thisElement->setWidth(-15);
  reportedErrors=el;
}
if (drcToList){
  drcErrorItem ei(ruleName,drcType,value);
  ei.pos1=p;ei.pos2=p;
  bool add=true;
  for (int i=violationList.size()-10;i<violationList.size();++i){
    if (i>=0) if (ei==violationList.at(i)) add=false;
  }
  if (add) violationList<<ei;
}
countErrors++;
}

void drc::reportError(element *e){
if (drcToCell){
  elementList *el=new elementList;
  el->nextElement=reportedErrors;
  el->thisElement=e->copy();
  el->thisElement->layerNum=errorLayer;
  if (el->thisElement->isText()) el->thisElement->setWidth(-14);
  reportedErrors=el;
}
if (drcToList){
  drcErrorItem ei(ruleName,drcType,0);
  QPoint min=QPoint(INT_MAX,INT_MAX);
  QPoint max=QPoint(INT_MIN,INT_MIN);
  e->minimum(&min);
  e->maximum(&max);
  if (min.x()<=max.x()){
    ei.pos1=min;ei.pos2=max;
  }
  bool add=true;
  for (int i=violationList.size()-10;i<violationList.size();++i){
    if (i>=0) if (ei==violationList.at(i)) add=false;
  }
  if (add) violationList<<ei;
}
countErrors++;
}

/*void drc::addError(){
}*/





void drc::noElementOnActiveLayer(){
  //d->macroAdd("layout->drcTool->ruleName= \"no Element on Layer "+d->str(d->activeLayer)+"\";");
  //ruleName= "no Element on Layer "+d->str(d->activeLayer);
  noElementOnLayer(d->activeLayer);
}

void drc::noPathOnActiveLayer(){
  //d->macroAdd("layout->drcTool->ruleName= \"no Path on Layer "+d->str(d->activeLayer)+"\";");
  //ruleName= "no Path on Layer "+d->str(d->activeLayer);
  noPathOnLayer(d->activeLayer);
}

void drc::noBoxOnActiveLayer(){
  //d->macroAdd("layout->drcTool->ruleName= \"no Box on Layer "+d->str(d->activeLayer)+"\";");
  //ruleName= "no Box on Layer "+d->str(d->activeLayer);
  noBoxOnLayer(d->activeLayer);
}



void drc::noPolygonOnActiveLayer(){
  //d->macroAdd("layout->drcTool->ruleName= \"no Polygon on Layer "+d->str(d->activeLayer)+"\";");
  //ruleName= "no Polygon on Layer "+d->str(d->activeLayer);
  noPolygonOnLayer(d->activeLayer);
}

void drc::noTextOnActiveLayer(){
  //d->macroAdd("layout->drcTool->ruleName= \"no Text on Layer "+d->str(d->activeLayer)+"\";");
  //ruleName= "no Text on Layer "+d->str(d->activeLayer);
  noTextOnLayer(d->activeLayer);
}

void drc::toBoolean(int layer, bool set,cell *c,bool useDrcArea){
elementIterator it(c,iteratorShapeOnLayer,layer);
if (useDrcArea) setDrcRegion(&it);
pointArray pa;
  while (it.next()){
    if (it.e->isText()){}
    else if (it.e->isPolygon()) pa=it.e->getPoints();
    else if (it.e->isPath()){
      if (it.e->getWidth()>0){
	element *e=it.e->convertToPolygon();
	pa=e->getPoints();
	delete e;
      }
    }
    else if (it.e->isBox()){
	element *e=it.e->convertToPolygon();
	pa=e->getPoints();
	delete e;
    }
    if (!it.e->isText()){
      if (set) booleanTool->setA(&pa);
      else booleanTool->setB(&pa);
    }
  }
}

void drc::fromBoolean(int layer, cell *c){
  bool has=true;
  polygon p;
  p.layerNum=layer;
  p.select=false;
  while (has){
    pointArray pa=booleanTool->getResultingPolygon();
    if (pa.size()>0){
        p.setPoints(pa);
	c->addElement(p.copy());
    }
    else has=false;
  }
}


void drc::moveCellRefs(cell *source, cell *dest){
  elementList *el=source->firstElement;
  while (el!=NULL){
    if (el->thisElement!=NULL)
      if (el->thisElement->depend()!=NULL){
	switch (drcArea){
	  case drcCell:{
		element *e=el->thisElement->copy();
		dest->addElement(e);
	  }
		break;
	  case drcRegion:{
		if (el->thisElement->inRect(region)){
		  element *e=el->thisElement->copy();
		  dest->addElement(e);
		}}
	       break;
	  case drcView:{
		if (el->thisElement->inRect(region)){
		  element *e=el->thisElement->copy();
		  dest->addElement(e);
		}}
	       break;
	}
	
      }
    el=el->nextElement;
  }
}

void drc::moveLayer(int layer, cell *source, cell *dest){
  elementList *el=source->firstElement;
  while (el!=NULL){
    if (el->thisElement!=NULL)
      if (el->thisElement->depend()==NULL)
	if (el->thisElement->layerNum==layer)
      {
	switch (drcArea){
	  case drcCell:{
	    element *e=el->thisElement->copy();
	    dest->addElement(e);
	  }
	    break;
	  case drcRegion:{
	       if (el->thisElement->inRect(region)){
		 element *e=el->thisElement->copy();
		 dest->addElement(e);
	       }}
	       break;
	  case drcView:{
	       if (el->thisElement->inRect(view)){
		 element *e=el->thisElement->copy();
		 dest->addElement(e);
	       }}
	       break;
	}
	
      }
    el=el->nextElement;
  }
}

void drc::mergeLayer(int layer, cell *source, cell *dest){
  toBoolean(layer,true,source,true);
  booleanTool->ignoreB();
  QList<pointArray> array=booleanTool->getAPlusB();
  uint size=array.size();
  polygon p;
  p.layerNum=layer;
  p.select=false;
  for (uint i=0;i<size;++i){
       p.setPoints(array.at(i));
       dest->addElement(p.copy());
  } 
}

void drc::makeHierarchie(cell *c){
}

void drc::setDrcRegion(elementIterator *it){
  switch (drcArea){
    case drcCell: break;
    case drcRegion:
      it->setRegion(QPoint(region.left(),region.bottom()),QPoint(region.right(),region.top()));
      break;
    case drcView:
      it->setRegion(QPoint(view.left(),view.bottom()),QPoint(view.right(),view.top()));
      break;
  }
}



void drc::minimumElementDistanceOnActiveLayer(int distance){  
//d->macroAdd("layout->drcTool->ruleName= \"Minimum Element Distance on Layer "+d->str(d->activeLayer)+"\";");
 // ruleName= "Minimum Element Distance on Layer "+d->str(d->activeLayer);
  minimumElementDistance(distance,d->activeLayer);
}

void drc::overlapingElementsOnActiveLayer(){
 // d->macroAdd("layout->drcTool->ruleName= \"Overlaping Elements on Layer "+d->str(d->activeLayer)+"\";");
 // ruleName= "Overlaping Elements on Layer "+d->str(d->activeLayer);
  overlapingElements(d->activeLayer);
}


void drc::noCircleOnActiveLayer(){
  noCircleOnLayer(d->activeLayer);
}

void drc::onlyCircleOnActiveLayer(){
  onlyCircleOnLayer(d->activeLayer);
}


void drc::noCircleOnActiveLayerGui(){
setup::ngpl();
 d->macroAdd("layout->drcTool->ruleName= \"no Circle on Layer "+d->str(d->activeLayer)+"\";");
 ruleName= "no Circle on Layer "+d->str(d->activeLayer);
 if (l->isGuiThread()){
  		l->workThread->startOperation("drcNoCircle","","",d->activeLayer);
 	}
	else{
	  if ( d->mutexChangeGuiTryLock()){
	      noCircleOnActiveLayer();
	      d->mutexChangeUnlock();
	      updateGui();
	  }
	} 
}

void drc::onlyCircleOnActiveLayerGui(){
setup::ngpl();
d->macroAdd("layout->drcTool->ruleName= \"only Circle on Layer "+d->str(d->activeLayer)+"\";");
 ruleName= "only Circle on Layer "+d->str(d->activeLayer);
 if (l->isGuiThread()){
  		l->workThread->startOperation("drcOnlyCircle","","",d->activeLayer);
 	}
	else{
	  if ( d->mutexChangeGuiTryLock()){
	      onlyCircleOnActiveLayer();
	      d->mutexChangeUnlock();
	      updateGui();
	  }
	} 
}


void drc::noElementOnActiveLayerGui(){
setup::ngpl();
d->macroAdd("layout->drcTool->ruleName= \"no Element on Layer "+d->str(d->activeLayer)+"\";");
 ruleName= "no Element on Layer "+d->str(d->activeLayer);
 if (l->isGuiThread()){
  		l->workThread->startOperation("drcNoElement","","",d->activeLayer);
 	}
	else{
	  if ( d->mutexChangeGuiTryLock()){
	      noElementOnActiveLayer();
	      d->mutexChangeUnlock();
	      updateGui();
	  }
	}
}

void drc::noPathOnActiveLayerGui(){
setup::ngpl();
d->macroAdd("layout->drcTool->ruleName= \"no Path on Layer "+d->str(d->activeLayer)+"\";");
 ruleName= "no Path on Layer "+d->str(d->activeLayer);
 if (l->isGuiThread()){
  		l->workThread->startOperation("drcNoPath","","",d->activeLayer);
 	}
	else{
	  if ( d->mutexChangeGuiTryLock()){
	      noPathOnActiveLayer();
	      d->mutexChangeUnlock();
	      updateGui();
	  }
	}
}

void drc::noBoxOnActiveLayerGui(){
setup::ngpl();
d->macroAdd("layout->drcTool->ruleName= \"no Box on Layer "+d->str(d->activeLayer)+"\";");
 ruleName= "no Box on Layer "+d->str(d->activeLayer);
 if (l->isGuiThread()){
  		l->workThread->startOperation("drcNoBox","","",d->activeLayer);
 	}
	else{
	  if ( d->mutexChangeGuiTryLock()){
	      noBoxOnActiveLayer();
	      d->mutexChangeUnlock();
	      updateGui();
	  }
	}
}

void drc::noPolygonOnActiveLayerGui(){
setup::ngpl();
d->macroAdd("layout->drcTool->ruleName= \"no Polygon on Layer "+d->str(d->activeLayer)+"\";");
 ruleName= "no Polygon on Layer "+d->str(d->activeLayer);
 if (l->isGuiThread()){
  		l->workThread->startOperation("drcNoPolygon","","",d->activeLayer);
 	}
	else{
	  if ( d->mutexChangeGuiTryLock()){
	      noPolygonOnActiveLayer();
	      d->mutexChangeUnlock();
	      updateGui();
	  }
	}  
}

void drc::noTextOnActiveLayerGui(){
setup::ngpl();
d->macroAdd("layout->drcTool->ruleName= \"no Text on Layer "+d->str(d->activeLayer)+"\";");
 ruleName= "no Text on Layer "+d->str(d->activeLayer);
 if (l->isGuiThread()){
  		l->workThread->startOperation("drcNoText","","",d->activeLayer);
 	}
	else{
	  if ( d->mutexChangeGuiTryLock()){
	      noTextOnActiveLayer();
	      d->mutexChangeUnlock();
	      updateGui();
	  }
	} 
}

void drc::overlapingElementsOnActiveLayerGui(){
setup::ngpl();
d->macroAdd("layout->drcTool->ruleName= \"Overlaping Elements on Layer "+d->str(d->activeLayer)+"\";");
ruleName= "Overlaping Elements on Layer "+d->str(d->activeLayer);
if (l->isGuiThread()){
  		l->workThread->startOperation("drcOverlapingElementsOnActiveLayer");
 	}
	else {
	if ( d->mutexChangeGuiTryLock()){
		overlapingElements(d->activeLayer);
		d->mutexChangeUnlock();
		updateGui();
		}
	}
}


inline void drc::message(bool end){
    ++messageCounter;
    if (((messageCounter%100)==0)||end){
		if ((messageTimer.elapsed()>200)||end){
			QString sh;
			sh.setNum(messageCounter);
			d->showMessage(ruleName+tr(", %1 shapes checked.").arg(sh));
			messageTimer.start();
			}
		}
}

void drc::setCheckCell(){
  drcArea=drcCell;
  emit updateDockRequired();
  d->macroAdd("layout->drcTool->setCheckCell();");
}

void drc::setCheckRegion(QPoint p1,QPoint p2){
}

void drc::setCheckView(){
  drcArea=drcView;
  emit updateDockRequired();
  d->macroAdd("layout->drcTool->setCheckView();");
}
void drc::setList(bool b){
  drcToList=b;
  emit updateDockRequired();
  QString s="true";
  if (!b) s="false";
  d->macroAdd("layout->drcTool->setList("+s+");");
}

void drc::setGraphical(bool b){
  drcToCell=b;
  emit updateDockRequired();
  QString s="true";
  if (!b) s="false";
  d->macroAdd("layout->drcTool->setGraphical("+s+");");
}

void drc::checkAreaChangedGui(){
  if (dock->drcsWidget->drcCell->isChecked()) drcArea=drcCell;
  if (dock->drcsWidget->drcRegion->isChecked()) drcArea=drcRegion; 
  if (dock->drcsWidget->drcView->isChecked()) drcArea=drcView; 
}

void drc::illustrationChangedGui(int){
  if (dock->drcsWidget->drcListResults->checkState()!=0) drcToList=true;
  else drcToList=false;
  if (dock->drcsWidget->drcPrintResults->checkState()!=0) drcToCell=true;
  else drcToCell=false;
}

void drc::toggleViolationView(){
}

void drc::setRegionMode(){
  d->setMode(this);
  d->macroAdd("layout->drcTool->setRegionMode();");
}

void drc::addViolation(QString name,double value, QPoint p1, QPoint p2, int type,int status){
  helpText drcT=drcClearViolationHelp;
  switch (type){
    case 1: drcT=drcMinSizeHelp; break;
    case 2: drcT=drcOverlapingElementsHelp; break;
    case 3: drcT=drcMinElementDisHelp; break;
    case 4: drcT=drcNotchesHelp; break;
    case 5: drcT=drcNoHolesHelp; break;
    case 6: drcT=drcDimensionHelp; break;
    case 7: drcT=drcAreaHelp; break;
    case 8: drcT=drcAnglesHelp; break;
    case 9: drcT=drcPerimeterHelp; break;
    case 10: drcT=drcMinDistanceHelp; break;
    case 11: drcT=drcMinDistanceOrOverlapHelp; break;
    case 12: drcT=drcInsideHelp; break;
    case 13: drcT=drcEnclosureHelp; break;
    case 14: drcT=drcMinOverHelp; break;
    case 15: drcT=drcOverlapDistanceHelp; break;
    case 16: drcT=drcLayerCombinationHelp; break;
    case 17: drcT=drcOnGridHelp; break;
    case 18: drcT=drcOnlyCircleHelp; break;
    case 19: drcT=drcNoElementHelp; break;
    case 20: drcT=drcNoPathHelp; break;
    case 21: drcT=drcNoBoxHelp; break;
    case 22: drcT=drcNoPolygonHelp; break;
    case 23: drcT=drcNoTextHelp; break;
    case 24: drcT=drcNoCircleHelp; break;
  }
  drcErrorItem ei(name,drcT,value);
  ei.pos1=p1;ei.pos2=p2;
  ei.status=status;
  violationList<<ei;
  emit updateDockRequired();  
}

void drc::saveViolationList(QString filename){
}

void drc::saveViolationList(){
 saveViolationList(QFileDialog::getSaveFileName(l,QString(),QString(),QString("layout (*.layout)")));
}

void drc::loadViolationList(QString filename){
}

void drc::loadViolationList(){
  loadViolationList(QFileDialog::getOpenFileName(l,QString(),QString(),QString("layout (*.layout)")));
}

void drc::clearViolationView(){
  violationList.clear();
  d->macroAdd("layout->drcTool->clearViolationView();");
  emit updateDockRequired();
}

void drc::violationListClicked( QListWidgetItem * item){
  //center violation
  int i=item->type();
  if (i>=violationList.size())return;
  QPoint max,min;
  max=violationList.at(i).pos1;
  min=violationList.at(i).pos2;
  if (max.x()<min.x()) {min.setX(max.x());max.setX(violationList.at(i).pos2.x());}
  if (max.y()<min.y()) {min.setY(max.y());max.setY(violationList.at(i).pos2.y());}
  double difx=(double)max.x()-(double)min.x();
  double dify=(double)max.y()-(double)min.y();
  if (difx<10) difx=20;
  if (dify<10) dify=20;
  double scale1=(d->height()/5-10)/dify;
  double scale2=(d->width()/5-10)/difx;
  if (scale1>scale2){scale1=scale2;}
  if (scale1>5) {scale1=5;}
  if (scale1<=0){scale1=1;}
  d->setView(scale1,(int)(-(max.x()+min.x())/2+d->width()/2/scale1),(int)((max.y()+min.y())/2+d->height()/2/scale1));
}
void drc::violationListDblClicked( QListWidgetItem * item){
  //change status violation
  int i=item->type();
  if (i<violationList.size()){
    violationList[i].status+=1;
    if (violationList[i].status==3) violationList[i].status=0;
    if (violationList.at(i).status==0)
      item->setIcon(helpWindow::getIcon(violationList.at(i).check));
    else if (violationList.at(i).status==1)
      item->setIcon(QIcon(":/icons/ok.png"));
    else if (violationList.at(i).status==2)
      item->setIcon(QIcon(":/icons/deleteicon.xpm"));
    else
      item->setIcon(QIcon());
  }
  //emit updateDockRequired();
}

drcErrorItem::drcErrorItem(QString s){
  rule=s;
  status=0;
  check=drcClearViolationHelp;
}

drcErrorItem::drcErrorItem(QString s,helpText type,double val){
  rule=s;
  value=val;
  check=type;
  status=0;
}

//basic checks:

void drc::minimumSize(int distance,int layer,bool mergeBefore, bool sharpAngles){
}


void drc::overlapingElements(int layer){
}


void drc::minimumElementDistance(int distance,int layer,bool mergeBefore){
  //printf("start %d %d %d\n",distance);
}

void drc::minimumNotchOnLayer(int notchsize, int layer, bool mergeBefore,bool testSlots){
}

void drc::noHolesOnLayer(int layer,bool mergeBefore){
}

void drc::dimensionOnLayer(int lengthMin,int lengthMax,int widthMin,int widthMax, int layer, bool mergeBefore){
}


void drc::maximumDimensionOnLayer(int length,int width, int layer, bool mergeBefore){
}

void drc::minimumDimensionOnLayer(int length,int width, int layer, bool mergeBefore){
}

void drc::minimumAreaOnLayer(int layer, double areavalue ,bool mergeBefore){
}

void drc::maximumAreaOnLayer(int layer, double areavalue ,bool mergeBefore){
}


void drc::angle90OnLayer(int layer,bool mergeBefore){
}

void drc::angle45OnLayer(int layer,bool mergeBefore){
}

void drc::maximumAngleOnLayer(double anglevalue, int layer, bool mergeBefore){
}

void drc::minimumPerimeterOnLayer(int layer, int perimeter ,bool mergeBefore){
}

void drc::maximumPerimeterOnLayer(int layer, int perimeter,bool mergeBefore){
}

void drc::minimumDistance(int distance,int layer1, int layer2){
#ifdef netlistutility
#endif
}

void drc::minimumDistanceOrOverlap(int distance,int layer1, int layer2,bool mode){
}


void drc::inside(int distance,int insideLayer, int layer1, int layer2, int layer3){
}


void drc::minimumEnclosure(int distance,int layer1,int layer2){
}


void drc::minimumOverlap(int distance,int layer1, int layer2){
}

void drc::minimumOverlapDistance(int distance,int layer1,int layer2){
}

void drc::layerCombination(int layer1,int layer2, int layer3,int layer4, int layer5){
}

void drc::onGrid(int size,int layer){
}

void drc::onlyCircleOnLayer(int layer){
}

void drc::noElementOnLayer(int layer){
  prepareCheck(drcNoElementHelp);
  elementIterator it(checkCell,iteratorShapeOnLayer,layer);
  setDrcRegion(&it);
  while (it.next()){
    {
      reportError(it.e);
      ++error;
    }
    message();
  }
  completeCheck(false,false);
  d->macroAdd("layout->drcTool->noElementOnLayer("+d->str(layer)+");");
}

void drc::noPathOnLayer(int layer){
  prepareCheck(drcNoPathHelp);
  elementIterator it(checkCell,iteratorShapeOnLayer,layer);
  setDrcRegion(&it);
  while (it.next()){
    if (it.e->isPath()) {
      reportError(it.e);
      ++error;
    }
    message();
  }
  completeCheck(false,false);
  d->macroAdd("layout->drcTool->noPathOnLayer("+d->str(layer)+");");
}

void drc::noBoxOnLayer(int layer){
  prepareCheck(drcNoBoxHelp);
  elementIterator it(checkCell,iteratorShapeOnLayer,layer);
  setDrcRegion(&it);
  while (it.next()){
    if (it.e->isBox()) {
      reportError(it.e);
      ++error;
    }
    message();
  }
  completeCheck(false,false);
  d->macroAdd("layout->drcTool->noBoxOnLayer("+d->str(layer)+");");
}

void drc::noPolygonOnLayer(int layer){
}

void drc::noTextOnLayer(int layer){
}

void drc::noCircleOnLayer(int layer){
}
