/***************************************************************************
 *   Copyright (C) 2005 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef HELPWINDOW_H
#define HELPWINDOW_H

#include "ui_helpwindowdialog.h"
#include <QDialog>
#include <QUrl>
#include <QString>
#include "widgets/mousewidget.h"
/**
@author Juergen Thies
*/
class helpWindow : public QDialog, private Ui::helpWindowDialog
{
  Q_OBJECT
private:
  QUrl url;
public:
  helpWindow(QWidget* parent = 0);
  ~helpWindow();
  /*$PUBLIC_FUNCTIONS$*/
  
public slots:
  /*$PUBLIC_SLOTS$*/
  void showHelp();
  void showHelp(helpText mode);
  void showHelp(QString name);
  void showModeHelp(int mode);
 // void updateUrl();
  void setUrl(QString url);
  void showSetupHelp(){
     //setUrl("setup.html#open");
     setUrl("SetupDialog");
  }
  void showRExtractHelp(){
     //setUrl("setup.html#open");
     setUrl("ExtractionResistor");
  }
  static QString getWhatsthis(helpText mode);
  static QString getMenuname(helpText mode);
  static QIcon getIcon(helpText mode);
  static QKeySequence getShortKey(helpText mode);
  static int getMode(helpText mode);
protected:
  /*$PROTECTED_FUNCTIONS$*/

protected slots:
  /*$PROTECTED_SLOTS$*/

};

#endif

