/***************************************************************************
 *   Copyright (C) 2005 by Juergen Thies                                   *
 *   layout@juergenthies.de                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <qlineedit.h>
#include <qvalidator.h>
#include "drcmindistanceoverlap.h"
#include "elements/element.h"

drcMinDistanceOverlap::drcMinDistanceOverlap(double ,int layer,QWidget* )
: drcMinDistanceOverlapDialog()
{
setupUi(this);
layerNr1->setMaximum(layersMax-1);
layerNr2->setMaximum(layersMax-1);
connect(layerNr1,SIGNAL(valueChanged(int)),this,SLOT(setLayerName1(int)));
connect(layerNr2,SIGNAL(valueChanged(int)),this,SLOT(setLayerName2(int)));
layerNr1->setValue(layer);
if (layer<layersMax-1)layerNr2->setValue(layer+1);
setModal(true);
}

drcMinDistanceOverlap::~drcMinDistanceOverlap()
{
}


void drcMinDistanceOverlap::setLayerName1(int i){
if (i>=0) layerName1->setText(layers::num[i].name);
}
void drcMinDistanceOverlap::setLayerName2(int i){
if (i>=0) layerName2->setText(layers::num[i].name);
}

/*$SPECIALIZATION$*/
bool drcMinDistanceOverlap::dialog(double uunits, int *value, int *layer1, int *layer2, bool * offContact){
   drcMinDistanceOverlap d(uunits,*layer1);
    d.show();
    int i=d.exec();
    d.hide();
    switch (i) {
    case QDialog::Rejected :
    	return false;
    case QDialog::Accepted :
	*value=element::runden(d.drcValue->value()/uunits);
	*layer1=d.layerNr1->value();
	*layer2=d.layerNr2->value();
	*offContact=d.offContact->isChecked();
	return true;
   }
  return false;
}

