#ifndef _MUTPROBS_H
#define _MUTPROBS_H

/* classes for storing probabilities of mutation of an L string
	see mutprobs.cpp for explanations of each probability
*/

#include <cmath>
#include <iostream>
#include <string>
#include <map>

using namespace std;
#include "probability.h"

enum {MutRec=0, MutDAng, MutDThick,
      DelParam,
      AddRotPar, ChgRotPar,
      AddMovPar, ChgMovPar,
	  AddAngPar, ChgAngPar,
 	  AddGrvPar, ChgGrvPar,
	  AddLenPar, ChgLenPar,
	  AddThkPar, ChgThkPar, 
      AddColPar, ChgColPar,
      ParametricMutations,

      DelRule=0, NewRule, DupRule,
      AddCurly, ClrCurly, DelCurly, 
      AddSquare, ClrSquare, DelSquare,
      AddChar, DelChar, ChgChar, SwchChar,
      AlgorithmicMutations,

      JitterProb=0, JitterRecStdev,
      JitterAngThickStdev,
      JitterMoveStdev,
      JitterBrackStdev, JitterIncDecStdev, 
      JitterTropeStdev, JitterColStdev,
      MutationModifierMutations,

      Abbrv=0, DescName, ProbDesc, ValDesc, NumDescFields
};


class mut_mut_class {
public:
	mut_mut_class();
	bool param(int which, float *val) {return MutMod[which].mut(val);};
	bool param(int which, int *val) {return MutMod[which].mut(val);};
	static const char *MutModDesc[MutationModifierMutations][NumDescFields];
	static float MutModDefaults[MutationModifierMutations][2];
	Probability MutMod[MutationModifierMutations];
};

class mut_class {
 public:
  mut_class();
  void mutate(mut_mut_class &m);
  friend void operator<<(string &out, mut_class &m);
  friend ostream& operator<<(ostream& out, mut_class &m);
  friend void operator>>(const string &in, mut_class &m);
  friend istream& operator>>(istream &in, mut_class &m);

  static const string DefaultNewRule;
  static const char *ParameterDesc[ParametricMutations][NumDescFields];
  static const char *AlgorithmDesc[AlgorithmicMutations][NumDescFields];
  static const float ParameterDefaults[ParametricMutations][2];
  static const float AlgorithmDefaults[AlgorithmicMutations][2];
  Probability Parameter[ParametricMutations];
  Probability Algorithm[AlgorithmicMutations];
};


#endif
