#include "mutprobs.h"
#include <sstream>

//prob of occurance (p)  ----  associated parameter (m)

const string mut_class::DefaultNewRule="F";

const char *mut_class::ParameterDesc[ParametricMutations][NumDescFields] = 
{
{"@", "Change Recursion Depth",
 "Prob. of the recursion depth mutating (per generation)",
 "St dev. of the amount added to the recursion depth, if mutated"}, 

{"<", "Change Default Angle",
 "Prob. of the default angle mutating [per generation]",
 "St dev. of the amount added to the default angle, if mutated"},
 
{"|", "Change Default Thickness",
	"Prob. of the default thickness mutation [per parameter per generation]",
	"St dev. of the amount the default thickness is multiplied by, if mutated"},

{"p", "Delete associated parameter",
	"Prob. of deletion of a parameter (a value in round brackets) [per parameter per generation]",
	""},
	
{"R", "Append parameter to a Rotation Character",
 "Prob. of appending a parameter to a rotation char (<>+-^&~) [per char per generation]",
 "St dev. of the amount added to current default angle value to obtain a value for the new parameter"},
 
{"r", "Tweak parameter of a Rotation Character",
 "Prob. of changing a parameter attached to a rotation char (<>+-^&~) [per char per generation]",
 "St dev. of amount added to the parameter"},
 
{"M", "Append parameter to a Movement Character",
 "Prob. of appending a parameter to a movement char (FfZzg) [per character per generation]",
 "St. dev of amount added to parameter (base value is 1 for Ffg and 0.5 for Zz)"},

{"m", "Tweak parameter of a Movement Character",
 "Prob. of changing the value of a movement char (FfZzg) [per character per generation]",
 "St. dev of amount added to parameter."},
 
{"L", "Append parameter to a Length-Adjusting Character",
	"Prob. of changing the value of a length-adjusting char (\"') [per character per generation]",
	"St dev. of amount added to base value (base value is 1.1 for \" and 0.9 for ')"},

{"l", "Tweak parameter of a Length-Adjusting Character",
 "Prob. of changing the value of a length-adjusting char (\"') [per character per generation]",
 "St dev. of amount added to attached parameter"},
 
{"A", "Add parameter to an Angle-Adjusting Character",
 "Prob. of changing the value of an angle-adjusting char (:;) [per char per generation]",
 "St dev. of amount added to base value (base value is 1.1 for ; and 0.9 for :)"},

{"a", "Tweak parameter of an Angle-Adjusting Character",
	"Prob. of changing the value of an angle-adjusting char (:;) [per char per generation]",
	"St dev. of amount added to attached parameter"},
	
{"T", "Add parameter to a Thickness-Adjusting Character",
	"Prob. of changing the value of a thickness-adjusting char (?!) [per char per generation]",
	"St dev. of amount added to base value (base value is 1.4 for ? and 0.7 for !)"},

{"t", "Tweak a Thickness-Adjusting Character",
	"Prob. of changing the value of a thickness-adjusting char (?!) [per char per generation]",
	"St dev. of amount added to attached parameter"},
	
{"G", "Add parameter to a Gravity Character",
	"Prob. of changing the value of a gravity char (t) [per char per generation]",
	"St. dev of amount added to base value (base value is 0.2)"},

{"g", "Tweak a Gravity Character",
	"Prob. of changing the value of a gravity char (t) [per char per generation]",
	"St. dev of amount added to parameter"},
	
{"C", "Append Parameter to a Colour Character",
 "Prob. of appending a parameter (always 0) to a colour char (c) [per char per generation]",
 ""},

{"c", "Change Parameter of a Colour Character",
 "Prob. of changing a parameter attached to a colour char (c) [per char per generation]",
 "Approximate st dev. of integer amount added to the colour value"}};

const float mut_class::ParameterDefaults[ParametricMutations][2] =
{
{0.1, 1}, //recursion prob, value
{0.1, 5}, //default angle prob, value
{0.1, 0.1}, //default thickness prob, value
{0.1,0}, //delete parameter prob
{0.05, 20}, //rotation value add, value
{0.05, 20}, //rotation value change
{0.05, 0.1}, //movement character add
{0.05,0.1}, //movement character change
{0.05,0.1}, //length adjust add
{0.05,0.1}, //length adjust change
{0.05, 0.1}, // angle add
{0.05, 0.1}, // angle change
{0.05, 0.2}, // thickness add
{0.05, 0.2}, // thickness change
{0.05, 0.05}, // gravity add
{0.05, 0.05}, // gravity change
{0.05, 3}, //colour add
{0.05, 3}, //colour change
};

///////////

const char *mut_class::AlgorithmDesc[AlgorithmicMutations][NumDescFields] = 
{
{"-", "Delete Rule",
 "Prob. of deleting a rule [per rule]",
 ""},
 
{"+", "Add New Rule",
 "Prob. of adding a new rule [per generation]",
 ""},
 
{"=", "Duplicate Rule",
 "Prob. of duplicating a randomly chosen rule [per generation]",
 ""},
 
{"{", "Add a Pair of Curly Brackets",
 "Prob. of adding a pair of curly brackets [per rule, approximately]",
 "St dev. of initial distance between brackets, if added"},

{"/", "Clear a Pair of Curly Brackets",
 "Prob. of deleting a pair of curly brackets along with their contents [per pair of curly brackets]",
 ""},

{"}", "Delete a Pair of Curly Brackets",
 "Prob. of deleting a pair of curly brackets [per pair of curly brackets]",
 ""},

{"[",  "Add a Pair of Square Brackets",
 "Prob. of adding a pair of square brackets [per rule, approximately]",
 "St dev. of initial distance between brackets, if added"},
 
{"\\", "Clear a Pair of Square Brackets",
 "Prob. of deleting a pair of square brackets along with their contents [per pair of square brackets]",
 ""},
 
{"]","Delete a Pair of Square Brackets",
 "Prob. of deleting a pair of square brackets [per pair of square brackets]",
 ""},

{"N", "Add a New Character",
 "Prob. of adding a randomly chosen character (excluding brackets and unused rule names) [per rule, approximately]",
 ""},
 
{"n", "Delete a Character",
 "Prob. of deleting a char (excluding square/curly brackets) [per char]",
 ""},
 
{"_", "Change one Character for another",
 "Prob. of changing a char (not square/curly brackets) for another with no parameters [per char]",
    ""},

{">", "Switch one Character for another",
 "Prob. of switching a char with the atom in front of it [per char]",
 ""}
};

 
const float mut_class::AlgorithmDefaults[AlgorithmicMutations][2]={
	{0.01,0}, //delete rule
	{0.01,0}, //add rule
	{0.01,0}, //dup rule
	{0.01,5}, //add curly
	{0.01,0}, //clear curly
	{0.01,0}, //delete curly
	{0.01,5}, //add square
	{0.01,0}, //clear square
	{0.01,0}, //delete square
	{0.01,0}, //add character
	{0.02,0}, //delete character
	{0.01,0}, //change char
	{0.02,0}, //swap char
};


//////////////////////////////////////////////////////////////
const char *mut_mut_class::MutModDesc[MutationModifierMutations][NumDescFields] =
{
	{"P","Change a Probability of Mutation",
		"",
		"St dev of probability change"},
	
	{"R","Change st dev. associated with recursion",
		"",
		"St dev of st dev change"},
	
	{"A","Change stdev. associated with angle/thickness",
		"",
		""},
	
	{"M","Change stdev. associated with movement",
		"",
		""},
	
	{"B","",
		"",
		""},
	
	{"I","",
		"",
		""},
	
	{"T","",
		"",
		""},
	
	{"L","",
		"",
		""},
};



const float MutModDefaults[MutationModifierMutations][2]=
{
	{0,0},
	{0,0},
	{0,0},
	{0,0},
	{0,0},
	{0,0},
	{0,0},
	{0,0}
};

///////////////////////////////////////////////////////////////
mut_mut_class::mut_mut_class() {
	for (int i=0; i < MutationModifierMutations; i++) {
	//		MutMod[i].init(MutModDefaults[i][0]);
	};
	
};

//////////////////////////////////////////////////////////////

mut_class::mut_class()
{
  for (int i=0; i < ParametricMutations; i++) {
    if (strlen(ParameterDesc[i][ValDesc]))
      Parameter[i].init(ParameterDefaults[i][0],ParameterDefaults[i][1]);
    else
      Parameter[i].init(ParameterDefaults[i][0]);
  };
  for (int i=0; i < AlgorithmicMutations; i++) {
    if (strlen(AlgorithmDesc[i][ValDesc]))
      Algorithm[i].init(AlgorithmDefaults[i][0],AlgorithmDefaults[i][1]);
    else
      Algorithm[i].init(AlgorithmDefaults[i][0]);
  };
}

void operator<<(string &out, mut_class &m) {
	std::ostringstream os;
	os << m << std::endl;
	out = os.str();
};

ostream& operator<<(ostream &out, mut_class &m) {
  for (int i=0; i < ParametricMutations; i++)
    out << m.ParameterDesc[i][0] << "=" 
		<< m.Parameter[i] << "\t#" 
	<< m.ParameterDesc[i][1] << endl;
  out << endl;;
  for (int i=0; i < AlgorithmicMutations; i++)
    out << m.AlgorithmDesc[i][0] << "=" 
	<< m.Algorithm[i] << "\t#" 
	<< m.AlgorithmDesc[i][1] << endl;
  return out;
}
  
void operator>>(const string &in, mut_class &m) {
	/* format for input is X prob (stdev)
    char c;
	float f;
    in >> c;
	for (i=0; i<ParametricMutations; i++)
		if (c==ParameterDesc[i][0][0]) {
			//read in value
			if (in >> skipws >> f)
				m.Parameter[i].set(f);
			break;
		};
  for (i=0;i<AlgorithmicMutations; i++)
    if (c==AlgorithmDesc[i][0]) {
		if (in >> skipws >> f)
			m.Parameter[i].set(f);
      break;
    };
  };*/
}

istream& operator>>(istream &in, mut_class &m)
{
	return in;
};


void mut_class::mutate(mut_mut_class &m) {
float f;
  if(m.param(JitterProb, &f))         Parameter[MutRec].jitter(f);
  if(m.param(JitterRecStdev, &f))     Parameter[MutRec].jitter_stdev(f);
  if(m.param(JitterProb, &f))         Parameter[MutDAng].jitter(f);
  if(m.param(JitterAngThickStdev,&f)) Parameter[MutDAng].jitter_stdev(f);
  if(m.param(JitterProb, &f))         Parameter[MutDThick].jitter(f);
  if(m.param(JitterAngThickStdev,&f)) Parameter[MutDThick].jitter_stdev(f);

  if(m.param(JitterProb, &f))         Parameter[DelParam].jitter(f);
  if(m.param(JitterProb, &f))         Parameter[AddRotPar].jitter(f);
  if(m.param(JitterAngThickStdev,&f)) Parameter[AddRotPar].jitter_stdev(f);
  if(m.param(JitterProb, &f))         Parameter[ChgRotPar].jitter(f);
  if(m.param(JitterAngThickStdev,&f)) Parameter[ChgRotPar].jitter_stdev(f);
  if(m.param(JitterProb, &f))         Parameter[AddMovPar].jitter(f);
  if(m.param(JitterMoveStdev,&f))     Parameter[AddMovPar].jitter_stdev(f);
  if(m.param(JitterProb, &f))         Parameter[ChgMovPar].jitter(f);
  if(m.param(JitterMoveStdev,&f))     Parameter[ChgMovPar].jitter_stdev(f);
  if(m.param(JitterProb, &f))         Parameter[AddAngPar].jitter(f);
  if(m.param(JitterIncDecStdev,&f))  Parameter[AddAngPar].jitter_stdev(f);
  if(m.param(JitterProb, &f))         Parameter[ChgAngPar].jitter(f);
  if(m.param(JitterIncDecStdev,&f))  Parameter[ChgAngPar].jitter_stdev(f);
  if(m.param(JitterProb, &f))         Parameter[AddGrvPar].jitter(f);
  if(m.param(JitterTropeStdev,&f))    Parameter[AddGrvPar].jitter_stdev(f);
  if(m.param(JitterProb, &f))         Parameter[ChgGrvPar].jitter(f);
  if(m.param(JitterTropeStdev,&f))    Parameter[ChgGrvPar].jitter_stdev(f);
  if(m.param(JitterProb, &f))         Parameter[AddLenPar].jitter(f);
  if(m.param(JitterIncDecStdev,&f)) Parameter[AddLenPar].jitter_stdev(f);
  if(m.param(JitterProb, &f))         Parameter[ChgLenPar].jitter(f);
  if(m.param(JitterIncDecStdev,&f)) Parameter[ChgLenPar].jitter_stdev(f);
  if(m.param(JitterProb, &f))         Parameter[AddThkPar].jitter(f);
  if(m.param(JitterIncDecStdev,&f)) Parameter[AddThkPar].jitter_stdev(f);
  if(m.param(JitterProb, &f))         Parameter[ChgThkPar].jitter(f);
  if(m.param(JitterIncDecStdev,&f)) Parameter[ChgThkPar].jitter_stdev(f);
  if(m.param(JitterProb, &f))         Parameter[AddColPar].jitter(f);
  if(m.param(JitterColStdev,&f))      Parameter[AddColPar].jitter_stdev(f);
  if(m.param(JitterProb, &f))         Parameter[ChgColPar].jitter(f);
  if(m.param(JitterColStdev,&f))      Parameter[ChgColPar].jitter_stdev(f);


  if(m.param(JitterProb, &f))         Algorithm[NewRule].jitter(f);
  if(m.param(JitterProb, &f))         Algorithm[DupRule].jitter(f);
  if(m.param(JitterProb, &f))         Algorithm[DelRule].jitter(f);
  if(m.param(JitterProb, &f))         Algorithm[AddCurly].jitter(f);
  if(m.param(JitterBrackStdev, &f))   Algorithm[AddCurly].jitter_stdev(f);
  if(m.param(JitterProb, &f))         Algorithm[AddSquare].jitter(f);
  if(m.param(JitterBrackStdev, &f))   Algorithm[AddSquare].jitter_stdev(f);
  if(m.param(JitterProb, &f))         Algorithm[ClrCurly].jitter(f);
  if(m.param(JitterProb, &f))         Algorithm[DelCurly].jitter(f);
  if(m.param(JitterProb, &f))         Algorithm[ClrSquare].jitter(f);
  if(m.param(JitterProb, &f))         Algorithm[DelSquare].jitter(f);
  if(m.param(JitterProb, &f))         Algorithm[AddChar].jitter(f);
  if(m.param(JitterProb, &f))         Algorithm[DelChar].jitter(f);
  if(m.param(JitterProb, &f))         Algorithm[ChgChar].jitter(f);
  if(m.param(JitterProb, &f))         Algorithm[SwchChar].jitter(f);
};
  
