#include <cmath>
#include <string>
#include <stdio.h>
#include <sstream>

#ifdef WIN32
#define snprintf _snprintf
#endif

#include "Lsys.h"

using namespace std;

const string Lsys::basic_tree="6\n45\n40\nccA\nA=B[+A][-A][^A][&A]\nB=cFF'(0.71)\n@";

char random_char(const string &s) {
	return(s[Probability::Rand.integer(s.length())]);
return 'a';
}

Lsys::Lsys(mut_mut_class *mmc){
  MM=mmc;
  changed=false;
  clear();
}

Lsys::~Lsys(){
  clear();
}


void Lsys::clear() {
  bounds[0]=0;bounds[1]=0;bounds[2]=0;bounds[3]=0;bounds[4]=0;bounds[5]=0;
  rec.read("0", "");
  ang.read("45", "");
  thick.read("50", "");
  comments.assign("");
  axiom.clear();
  rules.clear();
};

void Lsys::operator<<(char *in) {
  read_in(in);
};

void Lsys::operator<<(const char *in) {
  read_in(in);
};

void Lsys::operator<<(string &in){
  read_in(in);
};

void Lsys::operator<<(const string &in){
  read_in(in);
};

void Lsys::operator<<(istream &in) {
  string temp;
  char c;
  while(in.good()) {
    in.get(c);
    temp+=c;
  };
  in.clear();
  read_in(temp);
}

  
bool Lsys::read_in(const string &data) {
  string line, temp;
  int line_num=REC;
  bool more_lines=true;
  clear();
  size_t pos1=0, pos2;
  
  while(more_lines) {
    //cut into lines
    pos2=data.find('\n', pos1);
    if (pos2==string::npos) {
      line=data.substr(pos1, string::npos);
      more_lines=false;
    } else {
      line=data.substr(pos1, pos2-pos1);
      pos1=pos2+1;
    };
    Lline::remove_surrounding_whitespace(line);
    if (line.length()!=0) {
      if (line[0]=='#') {
	line.erase(0,1);
	comments+=line;
	comments+="\n";
      } else if (line[0]=='@') {
	more_lines=false;
      } else {
	switch(line_num) {
	case REC:
	  more_lines=rec.read(line) && more_lines;
	  rec.erase(rec.number_length(0));
	  break;
	case ANG:
	  more_lines=ang.read(line) && more_lines;
	  ang.erase(ang.number_length(0));
	  break;
	case THICK:
	  more_lines=thick.read(line) && more_lines;
	  thick.erase(thick.number_length(0));
	  break;
	case AXIOM:
	  more_lines=axiom.read(line) && more_lines;
	  break;
	default:{
	  Lrule temp;
	  more_lines=temp.read(line) && more_lines;
	  rules.push_back(temp);
	};
	}; //end switch
	line_num++;
      }; //end if (line[0]=='#') 
    };
  }; //end while;
  if (line_num>AXIOM)
    return true;
  else
    return false;
}

ostream& operator<<(ostream &out, Lsys &l) {
  string temp;
  size_t pos1=0, pos2=0;

  while(1) {
    pos2=l.comments.find('\n', pos1);
    if (pos2==string::npos) break; //only print comments ending in \n
    out << "#" << l.comments.substr(pos1,pos2-pos1+1);
    if (pos2+1>=l.comments.length()) break;
    pos1=pos2+1;
  };
  out << l.rec << endl;
  out << l.ang << endl;
  out << l.thick << endl;
  out << l.axiom << endl;

  for(int i=0;i<l.num_rules();i++) {
    out << l.rules[i] << endl;
  };
  return out;
}

string Lsys::get_Lstring() {
	ostringstream o;
	o << *this;
	return o.str();
}	

void operator<<(string &out, Lsys &l) {
	out = l.get_Lstring();
}

string Lsys::get_rules_as_one_string() const {
  string temp="";
  for(vector<Lrule>::const_iterator i=rules.begin();i!=rules.end();++i) {
    temp += i->name;
    temp += i->c_str();
    temp += '\n';
  };
  return temp;
};

string Lsys::used_rules() const {
  string temp="";
  for(vector<Lrule>::const_iterator i=rules.begin();i!=rules.end();++i) {
    temp+=i->name;
  };
  return temp;
}

string Lsys::available_rules() const {
  string s=Lrule::l_chars;
  string to_del=used_rules();
  for (int i=s.length()-1;i>=0;i--)
    if (to_del.find(s[i])!=string::npos)
      s.erase(i,1);
  return s;
}

bool Lsys::del_rule(int which) {
 if ((which<0) || (which>=num_rules()))
    return false;
  vector<Lrule>::iterator i=rules.begin();
  i+=which;
  rules.erase(i);
  return(changed=true);
}

void Lsys::add_rule(char name, string str, string comm) {
  rules.push_back(Lrule(name, str, comm));
  changed=true;
}

void Lsys::derive_from(const Lsys &l) {
  *this=l;
  mutate_rec();
  mutate_ang();
  mutate_thick();
  mutate_rules(); //do before axiom, to introduce new rules
  mutate_axiom();

  M.mutate(*MM);
  changed=true;
}

void Lsys::mutate_rec(){
  char str[21];
  float fval;
  int ival;
  if (rec_is_int()) {
    if(M.Parameter[MutRec].mut(&ival)) {
      ival+=(int) get_rec();
      if (ival < 1) ival=1; 
      snprintf(str,20, "%i", ival);
      rec.assign(str);
    };
  } else {
    if (M.Parameter[MutRec].mut(&fval)) {
      fval+=get_rec();
      if (fval < 1) fval=1.0;
      snprintf(str,20, "%.2f", fval);
      rec.assign(str);
    };
  };
}

void Lsys::mutate_ang(){
  char str[20];
  float fval;
  if (M.Parameter[MutDAng].mut(&fval)) {
    fval+=get_ang();
    snprintf(str,20, "%.2f", fval);
    ang.assign(str);
  };
}

void Lsys::mutate_thick(){
  char str[20];
  float fval;
  if (M.Parameter[MutDThick].mut(&fval)) {
	  fval+=1;
	  if (fval<0) return;
	  fval*=get_thick();
    snprintf(str,20, "%.2f", fval);
    thick.assign(str);
  };
}

void Lsys::mutate_axiom(){
  mutate_str(axiom);
};

void Lsys::mutate_rules(){
  //delete rules
  for(int i=num_rules();i>0;i--)
    if (M.Algorithm[DelRule].mut()) {
      del_rule(i-1);
    };

  //add rules
  if (M.Algorithm[NewRule].mut()) {
    string s=available_rules();
    if (s.length()!=0) {
      add_rule(s[0],M.DefaultNewRule);
    };
  };
  
  //duplicate
  if (M.Algorithm[DupRule].mut()) {
    string s=available_rules();
    if (s.length()!=0) {
      add_rule(s[0],rules[(Probability::Rand.integer(num_rules()))].c_str());
    };
  };

  for(int i=num_rules()-1;i>=0;i--) {
    mutate_str(rules[i]);
  };
};

string foo(size_t d) {
  if (d!=string::npos)
    return string(d-1, ' ')+"^";
  else
    return string("");
};

bool Lsys::mutate_algorithm(Lline &s, size_t &pos) {
  size_t d, pos2;
  int val;
  bool retval=false;
  string poss_chars=Lrule::special_chars+used_rules();
  //tackle adding new characters & brackets before the current char
  //all these are proportional to the length of the string,
  //to avoid building up hugely long strings
  
  // Add curly brackets
  if (M.Algorithm[AddCurly].mut(&val, 1.0/(1.0+s.length()))) { 
      pos2=s.clip_to_string(pos+val);       //check that insertion point for the other bracket is good
      pos2=s.atom_start(pos2);           //check it isn't in the middle of a ()
      if (pos>pos2) {
	s.insert(pos,"}");
	s.insert(pos2,"{");
	pos++;
      } else {
	s.insert(pos2,"}");
	s.insert(pos,"{");   
      };
      pos++;
      return(true);
    };

    // Add square brackets
    if (M.Algorithm[AddSquare].mut(&val, 1.0/(1.0+s.length()))) { 
      pos2=s.clip_to_string(pos+val);       //check that insertion point for the other bracket is good
      pos2=s.atom_start(pos2);           //check it isn't in the middle of a ()
      if (pos>pos2) {
	s.insert(pos,"]");
	s.insert(pos2,"[");
	pos++;
      } else {
	s.insert(pos2,"]");
	s.insert(pos,"[");
      };
      pos++;
      return(true);
    };

    // add a new character before new
    if (M.Algorithm[AddChar].mut(1.0f/(1.0f+s.length()))) {
      s.insert(pos, 1, random_char(poss_chars));
      pos++;
      retval=true;
    };

    //Now tackle modifying the current character
    d=s.atom_size(pos);
    
    //switch this character with the next
    if ((pos+d < s.length()) && M.Algorithm[SwchChar].mut()) {
      size_t d2=s.atom_size(pos+d);
      string sub=s.substr(pos+d, d2);
      s.erase(pos+d, d2);
      s.insert(pos, sub);
      d=d2;
      retval=true;
    };

    switch (s[pos]) {
    case '(':
    case ')':
      cout << "Something may be wrong: I have found an open or close bracket where I shouldn't have done." << endl;
      cout << "This could be caused by a faulty Lstring (brackets after a letter that doesn't take a parameter)" << endl;
      cout << "or by a bug in the program." << endl;
    case '}':
    case ']':
      break;
    case '{':
      if (M.Algorithm[ClrCurly].mut()) {
	//delete it and stuff in-between: leave square brackets though
	d = s.distance_to_closing(pos,'{','}');
	if (pos<s.length()) {
	  if (d==string::npos) d=s.length()-pos-1;
	  do {
	    if ((s[pos+d]!=']') && (s[pos+d]!='['))
	      s.erase(pos+d,1);
	  } while (d--);
	};
	return(true);
      } else if (M.Algorithm[ClrCurly].mut()) {
	//delete it + its closing brace
	d = s.distance_to_closing(pos,'{','}');
	if (d!=string::npos) s.erase(pos+d,1);
	s.erase(pos,1);
	return(true);
      };
      break;
    case '[':
      if (M.Algorithm[ClrSquare].mut()) {
	//delete it and stuff in-between
	d = s.distance_to_closing(pos,'[',']');
	if (pos<s.length()) {
	  if (d==string::npos) d=s.length()-pos-1;
	  do {
	    if ((s[pos+d]!='}') && (s[pos+d]!='{'))
	      s.erase(pos+d,1);
	  } while (d--);
	};
	return(true);
      } else if (M.Algorithm[DelSquare].mut()) {
	//delete it + its closing brace
	d = s.distance_to_closing(pos,'[',']');
	if (d!=string::npos) s.erase(pos+d,1);
	s.erase(pos,1);
	return(true);
      };
      break;
    default:
      if (M.Algorithm[DelChar].mut()) {
	//mutate this char
	s.erase(pos,d);
	return(true);
      } else if (M.Algorithm[ChgChar].mut()) { 
	s.erase(pos,d);
	s.insert(pos, 1, random_char(poss_chars));
	pos++; //move on
	return(true);
      };
    }; // end switch
         
    //if we have reached here, no algorithm mutants have occurred. Move on an atom.
    pos+=d;
    return(retval);
}

bool Lsys::mutate_parameter(Lline &s, size_t &pos) {
  size_t d=1;
  char curr_char=s[pos];
  
  if (Lline::is_param_char(curr_char)) {
    //find atom
    d=s.atom_size(pos);
    if (d>1 && (M.Parameter[DelParam].mut())) { 
      //delete parameter
      s.erase(pos+1,d-1);
      pos++;
      return(true);
    } else {
      //get the parameter value
      bool mut=false;
      float f=0, base_val=-1.0f;
      if (d >= 3) {
	char *end;
	string sub=s.substr(pos+2, d-2);
	base_val=strtod(sub.c_str(), &end);
	if (end==sub.c_str()) base_val=-1.0f; //no conversion
      };


      switch(curr_char) {
      case '+':
      case '-':
      case '&':
      case '^':
      case '<':
      case '>':
      case '~':
	if (base_val < 0.0f) {
	  if (mut=M.Parameter[AddRotPar].mut(&f))
	    f+=get_ang();
	} else {
	  if (mut=M.Parameter[ChgRotPar].mut(&f))
	    f+=base_val;
	};
	while (f>180.0)  f-=360.0; //make sure angle doesn't
	while (f<-180.0) f+=360.0; //get too large	    };
	break;
	
      case 'F': 
      case 'f':
      case 'g':
	if (base_val< 0.0f) { //no parameter already
	  if (mut=M.Parameter[AddMovPar].mut(&f))
	    f+=100.0f;
	} else {
	  if (mut=M.Parameter[ChgMovPar].mut(&f))
	    f+=base_val;			  
	};
	break;
      case 'Z':
      case 'z':
	if (base_val< 0.0f) { //no parameter already
	  if (mut=M.Parameter[AddMovPar].mut(&f))
	    f+=50.0f;
	} else {
	  if (mut=M.Parameter[ChgMovPar].mut(&f))
	    f+=base_val;			  
	};
	break;
	
      case '"':
	if (base_val<0.0f) {
	  if (mut=M.Parameter[AddLenPar].mut(&f)) 
	    f+=1.1;
	} else {
	  if (mut=M.Parameter[ChgLenPar].mut(&f))
	    f+=base_val;
	};
	break;
      case '\'':
	if (base_val<0.0f) {
	  if (mut=M.Parameter[AddLenPar].mut(&f)) 
	    f+=0.9;
	} else {
	  if (mut=M.Parameter[ChgLenPar].mut(&f))
	    f+=base_val;
	};
	break;
	
      case ';':
	if (base_val < 0.0f) {
	  if (mut=M.Parameter[AddAngPar].mut(&f)) 
	    f+=1.1f;
	} else {
	  if (mut=M.Parameter[ChgAngPar].mut(&f)) 
	    f+=base_val;
	};
	if (f<= 0.0f) f=0.0f; // don't allow angles less then 0
	break;
      case ':':
	if (base_val < 0.0f) {
	  if (mut=M.Parameter[AddAngPar].mut(&f)) 
	    f+=0.9f;
	} else {
	  if (mut=M.Parameter[ChgAngPar].mut(&f)) 
	    f+=base_val;
	};
	break;
	
      case '?':
	if (base_val < 0.0f) {
	  if (mut=M.Parameter[AddThkPar].mut(&f)) 
	    f+=1.4;
	} else {
	  if (mut=M.Parameter[ChgThkPar].mut(&f)) 
	    f+=base_val;
	};
	break;
      case '!':
	if (base_val < 0.0f) {
	  if (mut=M.Parameter[AddThkPar].mut(&f)) 
	    f+=0.7;
	} else {
	  if (mut=M.Parameter[ChgThkPar].mut(&f)) 
	    f+=base_val;
	};
	break;

      case 't':
	if (base_val < 0.0f) {
	  if (mut=M.Parameter[AddGrvPar].mut(&f)) 
	    f+=0.2;
	} else {
	  if (mut=M.Parameter[ChgGrvPar].mut(&f)) 
	    f+=base_val;
	};
	break;
	
      case 'c':
	if (base_val < 0.0f) {
	  if (mut=M.Parameter[AddColPar].mut(&f)) 
	    f+=0;
	} else {
	  if (mut=M.Parameter[ChgColPar].mut(&f)) 
	    f+=base_val;
	};
	break;
	
      default:
	break;
      }; //end switch

      if (mut) {
	char str[21];
	snprintf(str,20, "(%.2f)", f);
	//cut off zeroes (e.g. for colour parameter)
	while (str[strlen(str)-2]=='0') {
	  str[strlen(str)-2]=')';
	  str[strlen(str)-1]='\0';
	};
	if (str[strlen(str)-2]=='.') {
	  str[strlen(str)-2]=')';
	  str[strlen(str)-1]='\0';
	};
	s.replace(pos+1,d-1,str);
	pos += (strlen(str) +1);
	return(true);
      };
    }; //end else (not just deleted)
  }; //end "is a parameter char"
  pos+=d;
  return(false);
};

void Lsys::mutate_str(Lline &str){
  for (size_t position=0; position < str.length();)
    mutate_algorithm(str,position);
  for (size_t position=0; position < str.length();)
    mutate_parameter(str,position);
}


