#include <iostream>
#include "Lline.h"

const string Lline::l_chars="ABCDEHIJKLMNOPQRSTUVWXYabdehijklmnopqrsuvwxyFGZcfgtz<>&^+-|%$~\"';:?!0123456789.(){}[]";
const string Lline::special_chars="FfZzGgct<>&^+-|%$~\"';:?!.";
const string Lline::param_chars="FfZzGg<>&^+-~\"';:?!ct";

bool Lline::is_param_char(char c) {
  static bool *param_array=Lline::param_char_array();
  if (c < 0) c=0;
  return param_array[static_cast<unsigned char>(c)];
};

bool *Lline::param_char_array() {
  static bool pa[129];
  for (int i=0;i<129; i++)
    pa[i]=false;
  
  for (int i=param_chars.length()-1;i>=0;i--) 
    pa[static_cast<unsigned char>(param_chars[i])]=true;
  
  return pa;
};

bool Lline::read(const string &main, const string &comm) {
  this->assign(main);
  comment.assign(comm);
  if (main.find('@')==npos)
    return false;
  return true;
}

bool Lline::read(const string &s) {
  //split string into line+comment
  size_t cutpoint=s.find('#');
  size_t atpoint=s.find('@');
  string s2;
  if ((atpoint!=npos) && ((cutpoint==npos) || (atpoint<cutpoint))) {
    string s2=s.substr(0,atpoint);
    cutpoint=s.find('#');
    
    this->assign(s2,0,cutpoint);
    if (cutpoint==npos) comment.erase();
    else                comment.assign(s2,cutpoint, npos);
    return false;

  } else {

    this->assign(s,0,cutpoint);
    if (cutpoint==npos) comment.erase();
    else                comment.assign(s,cutpoint, npos);
    return true;
  };
};



void Lline::clear() {
  comment.assign("");
  this->assign("");
};

size_t Lline::next_atom(size_t pos) {
  return pos+atom_size(pos);
}


size_t Lline::atom_size(const size_t position) {
  //an atom is a parameter character with a possible (xxx) appended
  if (position>=length())
    return 0;
  if ((is_param_char((*this)[position])) && (position+1 < length()))
    return bracket_width(position+1)+1;
  if ((*this)[position]=='(')
    return bracket_width(position);
  return 1; //no valid brackets
};

size_t Lline::clip_to_string(const int position) {
  //return a position on the string (i.e. deal with positions <0 or >length)
  if (position<0) return(0);
  else if ((size_t) position >= length()) return(length());
  else return((size_t) position);
}

size_t Lline::atom_start(const size_t &position) {
  //return a position that is guaranteed not to be in the middle of a pair of round brackets
  size_t open_bracket=rfind('(',position);
  if (open_bracket == string::npos) 
    return position;
  size_t close_bracket=find(')', open_bracket);
  if (close_bracket == string::npos)
    return length();
  
  if (close_bracket < position)
    return position; //we are OK - not in the middle of ()

  //cope with being in the middle of a () by going to the start of it
  if (open_bracket == 0)
    return(0);
  else {
    if (is_param_char((*this)[open_bracket-1]))
      return(open_bracket-1);
    else
      return(open_bracket);
  };
};


size_t Lline::bracket_width(const size_t position) {
  if ((*this)[position]!='(')
    return 0; //no valid ()
  size_t p=find(')', position);
  if (p==npos) 
    return(length()-position);
  else
    return(p-position+1);
};

size_t Lline::distance_to_closing(const size_t position, const char open, const char close) {
  size_t pos=position, l=length();
  for(int level=0; pos<l;pos++) {
    if ((*this)[pos]==open) level+=1;
    else if ((*this)[pos]==close) level-=1;
    if (level <= 0)
      return(pos-position);
  };
  return(npos);
}

size_t Lline::number_length(size_t position){
  size_t pos1 = find_first_not_of("1234567890- ", position);
  if (pos1!=npos)
    if ((*this)[pos1]=='.') {
      pos1= find_first_not_of("1234567890", pos1+1);
      };
  if (pos1==npos)
    return length()-position;
  else
    return(pos1-position);
};

void Lline::remove_surrounding_whitespace(string &in) {
  //trailing w/s is bloody pain to do with STL::string
  size_t pos=in.find_last_not_of("\t\n\v\r ");
  if (pos!=string::npos)
    in.erase(pos+1);
  else
    in.erase();
  in.erase(0,in.find_first_not_of("\t\n\v\r ")); //leading w/s is easy
};

ostream& operator<<(ostream& out, Lline& l) {
  out << l.c_str();
  if (l.comment.length())
    out << "\t#" << l.comment;
  return(out);
}

/////////////

bool Lrule::read(const char &N, const string &main, const string &comment) {
  name=N;
  return Lline::read(main, comment);
};

bool Lrule::read(const char &N, const string &s) {
  name=N;
  return Lline::read(s);
};

bool Lrule::read(const string &s) {
  char n=s[0];
  if (s.length() < 2)
    return read(n, "");
  else {
    return(read(n, s.substr(s[1]=='=' ?2:1,npos)));
  };
};

void Lrule::clear() {
  name='\0';
  Lline::clear();
}

ostream& operator<<(ostream& out, Lrule& l) {
  out << l.name << '=' << l.c_str();
  if (l.comment.length())
    out << "\t#" << l.comment;
  return(out);
}
