import se.datadosen.jalbum.JAFilter;
import java.awt.*;
import java.awt.image.*;

/**
 * Title:        JAlbum simple image filter sharpening images
 * Copyright:    Copyright (c) 2003
 * Company:      Datadosen
 * @author David Ekholm
 * @version 1.0
 */
public class SharpenFilter implements JAFilter {

		// Implements JAFilter
    public String getName() {
        return "Sharpen filter";
    }

		// Implements JAFilter
    public String getDescription() {
        return "Sharpen images";
    }

		// Implements JAFilter
    public BufferedImage filter(BufferedImage bi, java.util.Map vars) {
		Graphics2D g = bi.createGraphics();

		Kernel kernel = new Kernel(3, 3,
			new float[] {
				0.f, -0.3f, 0.f,
				-0.3f, 2.2f, -0.3f,
				0.f, -0.3f, 0.f });

		BufferedImageOp op = new ConvolveOp(kernel, ConvolveOp.EDGE_NO_OP, null);
		bi = op.filter(bi, null);
		return bi;
    }
}
