/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.editor;

import edu.stanford.ejalbert.BrowserLauncher;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import net.jalbum.editor.JFindDialog;
import net.jalbum.editor.Main;
import net.jalbum.editor.OperationCanceledException;
import net.jalbum.io.PCWriter;
import org.fife.io.UnicodeReader;
import org.fife.ui.autocomplete.AbstractCompletionProvider;
import org.fife.ui.autocomplete.AutoCompletion;
import org.fife.ui.autocomplete.Completion;
import org.fife.ui.autocomplete.DefaultCompletionProvider;
import org.fife.ui.autocomplete.ExternalURLHandler;
import org.fife.ui.autocomplete.MarkupTagCompletion;
import org.fife.ui.autocomplete.VariableCompletion;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;
import org.fife.ui.rtextarea.SearchEngine;
import se.datadosen.component.JStackLabel;
import se.datadosen.component.ToggleAction;
import se.datadosen.util.IO;
import se.datadosen.util.StringCodec;

public class JTextPad
extends JFrame {
    static final int menuShortcutKeyMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    public static final String APP_NAME = "Jalbum Textpad";
    public static final String VERSION = "1.2";
    public static Map<String, String> fileTypes = new HashMap<String, String>();
    JMenuBar menuBar = new JMenuBar();
    JMenu fileMenu;
    JMenu editMenu;
    JMenu tabsMenu;
    JMenu lineTerminationMenu;
    JMenu viewMenu;
    JMenu helpMenu;
    JRadioButtonMenuItem pcTerminationStyle = new JRadioButtonMenuItem("PC style");
    JRadioButtonMenuItem unixTerminationStyle = new JRadioButtonMenuItem("UNIX style");
    ButtonGroup terminationStyle = new ButtonGroup();
    RSyntaxTextArea textArea;
    AutoCompletion autoCompletion;
    DefaultCompletionProvider provider;
    RTextScrollPane textScroller;
    JStackLabel statusBar;
    JFileChooser fileChooser;
    PrinterJob printerJob;
    int textHash;
    static List<JTextPad> windows;
    static Map<File, JTextPad> editors;
    static Point lastLocation;
    Action undoAction;
    Action newAction;
    Action openAction;
    Action closeAction;
    Action saveAction;
    Action saveAsAction;
    Action pageSetupAction;
    Action printAction;
    static Action exitAction;
    Action findAction;
    Action findNextAction;
    Action replaceAction;
    Action replaceNextAction;
    Action replaceAllAction;
    Action goToAction;
    Action completeCodeAction;
    Action tabSizeAction;
    ToggleAction emulatedTabs;
    Action convertTabsToSpaces;
    Action convertSpacesToTabs;
    ToggleAction lineWrapAction;
    ToggleAction lineNumbersAction;
    ToggleAction whiteSpaceAction;
    ToggleAction highlightCurrentLineAction;
    Action aboutAction;
    JFindDialog findDialog;

    public AbstractCompletionProvider getCompletionProvider() {
        return this.provider;
    }

    void openFile(File file) {
        try {
            String line;
            byte[] raw = IO.readBytes(file);
            StringCodec sc = new StringCodec();
            String tmp = sc.decode(raw);
            if (tmp.indexOf(13) >= 0) {
                this.pcTerminationStyle.setSelected(true);
            } else {
                this.unixTerminationStyle.setSelected(true);
            }
            String encoding = sc.getDetectedEncoding();
            StringBuilder buf = new StringBuilder();
            BufferedReader reader = new BufferedReader(new UnicodeReader(new ByteArrayInputStream(raw), encoding));
            while ((line = reader.readLine()) != null) {
                buf.append(line);
                buf.append('\n');
            }
            String text = buf.toString();
            this.fileChooser.setSelectedFile(file);
            this.getRootPane().putClientProperty("Window.documentFile", file);
            this.setSyntaxStyle();
            this.textArea.setText(text);
            this.textArea.setCaretPosition(0);
            this.textArea.discardAllEdits();
            this.getRootPane().putClientProperty("Window.documentModified", Boolean.FALSE);
            this.textHash = text.hashCode();
            this.updateTitle();
            editors.put(file, this);
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this, "Can't open file " + file.getName() + ": " + ex.getMessage(), APP_NAME, 0);
        }
    }

    private void writeTextFile(String content, File file, String encoding) throws IOException {
        Writer writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), encoding);
        if (this.pcTerminationStyle.isSelected()) {
            writer = new PCWriter(writer);
        }
        writer.write(content);
        ((Writer)writer).close();
    }

    void saveFile(File file) {
        try {
            String text = this.textArea.getText();
            this.writeTextFile(text, file, "UTF-8");
            this.textHash = text.hashCode();
            this.getRootPane().putClientProperty("Window.documentModified", Boolean.FALSE);
            this.fileChooser.setSelectedFile(file);
            this.setSyntaxStyle();
            this.updateTitle();
            this.statusBar.setText("Document written to " + file.getAbsolutePath());
            this.getRootPane().putClientProperty("Window.documentFile", file);
            editors.put(file, this);
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this, "Can't write to file " + file.getName() + ": " + ex.getMessage(), APP_NAME, 0);
        }
    }

    void ensureNoLoss() throws OperationCanceledException {
        int currentTextHash = this.textArea.getText().hashCode();
        if (currentTextHash != this.textHash) {
            int answer = JOptionPane.showConfirmDialog(this, "Save changes to " + this.getDocumentTitle() + "?", APP_NAME, 1, 2);
            if (answer == 1) {
                return;
            }
            if (answer == 0) {
                this.saveAction.actionPerformed(null);
            } else {
                throw new OperationCanceledException();
            }
        }
    }

    public File getCurrentDirectory() {
        return this.fileChooser.getCurrentDirectory();
    }

    public void setCurrentDirectory(File dir) {
        this.fileChooser.setCurrentDirectory(dir);
    }

    public void setSyntaxStyle() {
        String ext = IO.extensionOf(this.getWorkingFile()).toLowerCase();
        String syntaxStyle = fileTypes.get(ext);
        if (syntaxStyle == null) {
            syntaxStyle = "text/plain";
        }
        this.textArea.setSyntaxEditingStyle(syntaxStyle);
        this.updateStatusBar();
    }

    public JTextPad() {
        this.terminationStyle.add(this.pcTerminationStyle);
        this.terminationStyle.add(this.unixTerminationStyle);
        this.pcTerminationStyle.setSelected(true);
        this.textArea = new RSyntaxTextArea(60, 120);
        this.provider = new DefaultCompletionProvider(){

            protected boolean isValidChar(char ch) {
                if (ch == ':') {
                    return true;
                }
                return super.isValidChar(ch);
            }
        };
        this.statusBar = new JStackLabel();
        this.fileChooser = new JFileChooser();
        this.printerJob = PrinterJob.getPrinterJob();
        this.textHash = 0;
        this.undoAction = RSyntaxTextArea.getAction(6);
        this.newAction = new AbstractAction("New"){
            {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(78, menuShortcutKeyMask));
            }

            public void actionPerformed(ActionEvent e) {
                JTextPad newTextPad = new JTextPad();
                newTextPad.setCurrentDirectory(JTextPad.this.getCurrentDirectory());
                Point loc = JTextPad.this.getLocation();
                newTextPad.setLocation(loc.x + 25, loc.y + 25);
                newTextPad.setVisible(true);
            }
        };
        this.openAction = new AbstractAction("Open..."){
            {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(79, menuShortcutKeyMask));
            }

            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = new JFileChooser();
                chooser.setCurrentDirectory(JTextPad.this.fileChooser.getCurrentDirectory());
                chooser.setSelectedFile(JTextPad.this.fileChooser.getSelectedFile());
                chooser.setMultiSelectionEnabled(true);
                int choice = chooser.showOpenDialog(JTextPad.this);
                File[] files = chooser.getSelectedFiles();
                if (choice == 0) {
                    lastLocation = JTextPad.this.getLocation();
                    for (File f : files) {
                        JTextPad.getEditor(f);
                    }
                }
            }
        };
        this.closeAction = new AbstractAction("Close"){
            {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(87, menuShortcutKeyMask));
            }

            public void actionPerformed(ActionEvent e) {
                JTextPad.this.ensureNoLoss();
                JTextPad.this.setVisible(false);
                windows.remove(JTextPad.this);
                editors.remove(JTextPad.this.fileChooser.getSelectedFile());
                if (windows.size() == 0) {
                    exitAction.actionPerformed(null);
                }
            }
        };
        this.saveAction = new AbstractAction("Save"){
            {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, menuShortcutKeyMask));
            }

            public void actionPerformed(ActionEvent e) {
                File workingFile = JTextPad.this.getWorkingFile();
                if (workingFile == null) {
                    JTextPad.this.saveAsAction.actionPerformed(e);
                } else {
                    JTextPad.this.saveFile(workingFile);
                }
            }
        };
        this.saveAsAction = new AbstractAction("Save As..."){

            public void actionPerformed(ActionEvent e) {
                editors.remove(JTextPad.this.fileChooser.getSelectedFile());
                int choice = JTextPad.this.fileChooser.showSaveDialog(JTextPad.this);
                File selectedFile = JTextPad.this.fileChooser.getSelectedFile();
                if (choice == 0 && selectedFile != null) {
                    if (selectedFile.exists()) {
                        int answer = JOptionPane.showConfirmDialog(JTextPad.this, "" + selectedFile.getAbsolutePath() + " already exists.\nDo you wish to replace it?", "Save As", 1, 2);
                        if (answer == 0) {
                            JTextPad.this.saveFile(selectedFile);
                            return;
                        }
                        if (answer == 1) {
                            return;
                        }
                    }
                    JTextPad.this.saveFile(selectedFile);
                    return;
                }
                throw new OperationCanceledException();
            }
        };
        this.pageSetupAction = new AbstractAction("Page Setup..."){
            {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(80, menuShortcutKeyMask | 1));
            }

            public void actionPerformed(ActionEvent e) {
                PageFormat pf = JTextPad.this.printerJob.pageDialog(JTextPad.this.printerJob.defaultPage());
                JTextPad.this.printerJob.setPrintable(JTextPad.this.textArea, pf);
            }
        };
        this.printAction = new AbstractAction("Print..."){
            {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(80, menuShortcutKeyMask));
            }

            public void actionPerformed(ActionEvent e) {
                boolean doPrint = JTextPad.this.printerJob.printDialog();
                if (doPrint) {
                    try {
                        JTextPad.this.printerJob.print();
                    }
                    catch (PrinterException ex) {
                        JOptionPane.showMessageDialog(JTextPad.this, "An error occured during printing: " + ex.getMessage(), JTextPad.APP_NAME, 0);
                    }
                }
            }
        };
        this.findAction = new AbstractAction("Find..."){
            {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(70, menuShortcutKeyMask));
            }

            public void actionPerformed(ActionEvent e) {
                JTextPad.this.findDialog.setMode(JFindDialog.Mode.find);
                JTextPad.this.findDialog.setVisible(true);
            }
        };
        this.findNextAction = new AbstractAction("Find Next"){
            {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(114, 0));
            }

            public void actionPerformed(ActionEvent e) {
                if (JTextPad.this.findDialog.toFind.getText().length() == 0) {
                    JTextPad.this.findAction.actionPerformed(e);
                } else {
                    boolean found = SearchEngine.find(JTextPad.this.textArea, JTextPad.this.findDialog.toFind.getText(), JTextPad.this.findDialog.down.isSelected(), JTextPad.this.findDialog.matchCase.isSelected(), JTextPad.this.findDialog.wholeWords.isSelected(), JTextPad.this.findDialog.regExp.isSelected());
                    if (!found) {
                        JTextPad.this.statusBar.setText("Search passed the end of file");
                    }
                }
            }
        };
        this.replaceAction = new AbstractAction("Replace..."){
            {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(82, menuShortcutKeyMask));
            }

            public void actionPerformed(ActionEvent e) {
                JTextPad.this.findDialog.setMode(JFindDialog.Mode.replace);
                JTextPad.this.findDialog.setVisible(true);
            }
        };
        this.replaceNextAction = new AbstractAction("Replace"){

            public void actionPerformed(ActionEvent e) {
                if (JTextPad.this.findDialog.toFind.getText().length() == 0) {
                    return;
                }
                boolean found = SearchEngine.replace(JTextPad.this.textArea, JTextPad.this.findDialog.toFind.getText(), JTextPad.this.findDialog.replaceWith.getText(), JTextPad.this.findDialog.down.isSelected(), JTextPad.this.findDialog.matchCase.isSelected(), JTextPad.this.findDialog.wholeWords.isSelected(), JTextPad.this.findDialog.regExp.isSelected());
                if (!found) {
                    JTextPad.this.statusBar.setText("Search passed the end of file");
                }
            }
        };
        this.replaceAllAction = new AbstractAction("Replace All"){

            public void actionPerformed(ActionEvent e) {
                if (JTextPad.this.findDialog.toFind.getText().length() == 0) {
                    return;
                }
                int count = SearchEngine.replaceAll(JTextPad.this.textArea, JTextPad.this.findDialog.toFind.getText(), JTextPad.this.findDialog.replaceWith.getText(), JTextPad.this.findDialog.matchCase.isSelected(), JTextPad.this.findDialog.wholeWords.isSelected(), JTextPad.this.findDialog.regExp.isSelected());
                JTextPad.this.statusBar.setText("" + count + " occurences of " + JTextPad.this.findDialog.toFind.getText() + " replaced");
            }
        };
        this.goToAction = new AbstractAction("Go To..."){
            {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(71, menuShortcutKeyMask));
            }

            public void actionPerformed(ActionEvent e) {
                String s = JOptionPane.showInputDialog(JTextPad.this, "Line Number:", "Goto line", -1);
                int line = Integer.parseInt(s) - 1;
                try {
                    int i = JTextPad.this.textArea.getLineStartOffset(line);
                    JTextPad.this.textArea.setCaretPosition(i);
                }
                catch (BadLocationException ex) {
                    // empty catch block
                }
            }
        };
        this.completeCodeAction = new AbstractAction("Complete Code"){
            {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(32, 2));
            }

            public void actionPerformed(ActionEvent e) {
                JTextPad.this.autoCompletion.doCompletion();
            }
        };
        this.tabSizeAction = new AbstractAction("Set tab size"){

            public void actionPerformed(ActionEvent e) {
                String s = JOptionPane.showInputDialog(JTextPad.this, "Tab size:", "" + JTextPad.this.textArea.getTabSize());
                int tabSize = Integer.parseInt(s);
                JTextPad.this.textArea.setTabSize(tabSize);
            }
        };
        this.emulatedTabs = new ToggleAction("Emulate tabs with spaces"){

            public void actionPerformed(ActionEvent e) {
                JTextPad.this.textArea.setTabsEmulated(this.isSelected());
            }
        };
        this.convertTabsToSpaces = new ToggleAction("Convert tabs to spaces"){

            public void actionPerformed(ActionEvent e) {
                JTextPad.this.textArea.convertTabsToSpaces();
            }
        };
        this.convertSpacesToTabs = new ToggleAction("Convert spaces to tabs"){

            public void actionPerformed(ActionEvent e) {
                JTextPad.this.textArea.convertSpacesToTabs();
            }
        };
        this.lineWrapAction = new ToggleAction("Line Wrap"){
            {
                this.setSelected(true);
            }

            public void actionPerformed(ActionEvent e) {
                JTextPad.this.textArea.setLineWrap(this.isSelected());
            }
        };
        this.lineNumbersAction = new ToggleAction("Line Numbers"){
            {
                this.setSelected(true);
            }

            public void actionPerformed(ActionEvent e) {
                JTextPad.this.textScroller.setLineNumbersEnabled(this.isSelected());
            }
        };
        this.whiteSpaceAction = new ToggleAction("White Space"){

            public void actionPerformed(ActionEvent e) {
                JTextPad.this.textArea.setWhitespaceVisible(this.isSelected());
            }
        };
        this.highlightCurrentLineAction = new ToggleAction("Highlight current line"){
            {
                this.setSelected(true);
            }

            public void actionPerformed(ActionEvent e) {
                JTextPad.this.textArea.setHighlightCurrentLine(this.isSelected());
            }
        };
        this.aboutAction = new AbstractAction("About Jalbum Textpad"){

            public void actionPerformed(ActionEvent e) {
                JPanel panel = new JPanel();
                panel.setLayout(new GridLayout(0, 1));
                panel.add(new JLabel("Jalbum Textpad 1.2"));
                panel.add(new JLabel("By David Ekholm, Jalbum"));
                panel.add(new JLabel("Thanks to Robert Futrell for providing the excellent"));
                panel.add(new JLabel("text editor engine RSyntaxTextArea!"));
                JOptionPane.showMessageDialog(JTextPad.this, panel, "About Jalbum Textpad", 1);
            }
        };
        this.findDialog = new JFindDialog(this);
        this.initComponents();
    }

    public JTextPad(File workingFile) {
        this.terminationStyle.add(this.pcTerminationStyle);
        this.terminationStyle.add(this.unixTerminationStyle);
        this.pcTerminationStyle.setSelected(true);
        this.textArea = new RSyntaxTextArea(60, 120);
        this.provider = new /* invalid duplicate definition of identical inner class */;
        this.statusBar = new JStackLabel();
        this.fileChooser = new JFileChooser();
        this.printerJob = PrinterJob.getPrinterJob();
        this.textHash = 0;
        this.undoAction = RSyntaxTextArea.getAction(6);
        this.newAction = new /* invalid duplicate definition of identical inner class */;
        this.openAction = new /* invalid duplicate definition of identical inner class */;
        this.closeAction = new /* invalid duplicate definition of identical inner class */;
        this.saveAction = new /* invalid duplicate definition of identical inner class */;
        this.saveAsAction = new /* invalid duplicate definition of identical inner class */;
        this.pageSetupAction = new /* invalid duplicate definition of identical inner class */;
        this.printAction = new /* invalid duplicate definition of identical inner class */;
        this.findAction = new /* invalid duplicate definition of identical inner class */;
        this.findNextAction = new /* invalid duplicate definition of identical inner class */;
        this.replaceAction = new /* invalid duplicate definition of identical inner class */;
        this.replaceNextAction = new /* invalid duplicate definition of identical inner class */;
        this.replaceAllAction = new /* invalid duplicate definition of identical inner class */;
        this.goToAction = new /* invalid duplicate definition of identical inner class */;
        this.completeCodeAction = new /* invalid duplicate definition of identical inner class */;
        this.tabSizeAction = new /* invalid duplicate definition of identical inner class */;
        this.emulatedTabs = new /* invalid duplicate definition of identical inner class */;
        this.convertTabsToSpaces = new /* invalid duplicate definition of identical inner class */;
        this.convertSpacesToTabs = new /* invalid duplicate definition of identical inner class */;
        this.lineWrapAction = new /* invalid duplicate definition of identical inner class */;
        this.lineNumbersAction = new /* invalid duplicate definition of identical inner class */;
        this.whiteSpaceAction = new /* invalid duplicate definition of identical inner class */;
        this.highlightCurrentLineAction = new /* invalid duplicate definition of identical inner class */;
        this.aboutAction = new /* invalid duplicate definition of identical inner class */;
        this.findDialog = new JFindDialog(this);
        this.initComponents();
        if (workingFile.isDirectory()) {
            this.setCurrentDirectory(workingFile);
        } else {
            this.setCurrentDirectory(workingFile.getParentFile());
            this.openFile(workingFile);
        }
    }

    public static JTextPad getEditor(File f) {
        JTextPad editor = editors.get(f);
        if (editor != null) {
            editor.toFront();
        } else {
            editor = new JTextPad(f);
            JTextPad.lastLocation.x += 40;
            JTextPad.lastLocation.y += 40;
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            if (JTextPad.lastLocation.x + 300 > screenSize.width || JTextPad.lastLocation.y + 200 > screenSize.height) {
                JTextPad.lastLocation.x = 80;
                JTextPad.lastLocation.y = 80;
            }
            editor.setLocation(lastLocation);
            editor.setVisible(true);
        }
        lastLocation = editor.getLocation();
        return editor;
    }

    public File getWorkingFile() {
        return this.fileChooser.getSelectedFile();
    }

    private String getDocumentTitle() {
        File wf = this.getWorkingFile();
        if (wf == null) {
            return "Untitled";
        }
        String title = "";
        File parent = wf.getParentFile();
        if (parent != null) {
            title = parent.getName() + File.separatorChar;
        }
        title = title + wf.getName();
        return title;
    }

    private void updateTitle() {
        String title = "Jalbum Textpad [" + this.getDocumentTitle() + "]";
        this.setTitle(title);
    }

    private void updateStatusBar() {
        int line = this.textArea.getCaretLineNumber() + 1;
        int col = this.textArea.getCaretOffsetFromLineStart() + 1;
        String style = this.pcTerminationStyle.isSelected() ? "PC" : "UNIX";
        this.statusBar.setText("Mode " + this.textArea.getSyntaxEditingStyle() + " | UTF-8 | " + style + " | Ln " + line + ", Col " + col);
    }

    private static boolean setApplicationModalExclusion(JFrame frmMain) {
        try {
            Class<?> exclusionType = Class.forName("java.awt.Dialog$ModalExclusionType");
            Field field = exclusionType.getField("APPLICATION_EXCLUDE");
            Object value = field.get(exclusionType);
            Method meth = JFrame.class.getMethod("setModalExclusionType", exclusionType);
            meth.invoke((Object)frmMain, value);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void initComponents() {
        JTextPad.setApplicationModalExclusion(this);
        windows.add(this);
        this.printerJob.setPrintable(this.textArea);
        this.updateTitle();
        this.setLocation(80, 80);
        this.textArea.setFont(new Font("Monospaced", 0, this.textArea.getFont().getSize()));
        try {
            this.textArea.setDropTarget(new DropTarget(this.textArea, new DropTargetListener(){

                public void dragEnter(DropTargetDragEvent e) {
                    e.acceptDrag(1);
                }

                public void dragOver(DropTargetDragEvent e) {
                    e.acceptDrag(1);
                }

                public void dragExit(DropTargetEvent e) {
                }

                public void drop(DropTargetDropEvent e) {
                    if ((e.getSourceActions() & 1) == 0) {
                        e.rejectDrop();
                        return;
                    }
                    e.acceptDrop(1);
                    try {
                        List files = (List)e.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                        e.dropComplete(true);
                        lastLocation = JTextPad.this.getLocation();
                        for (File f : files) {
                            JTextPad.getEditor(f);
                        }
                        return;
                    }
                    catch (IOException ex) {
                        System.err.println(ex);
                    }
                    catch (UnsupportedFlavorException ex) {
                        System.err.println(ex);
                    }
                    e.dropComplete(false);
                }

                public void dropActionChanged(DropTargetDragEvent e) {
                }
            }));
        }
        catch (RuntimeException ex) {
            ex.printStackTrace(System.err);
        }
        this.fileMenu = new JMenu("File");
        this.editMenu = new JMenu("Edit");
        this.tabsMenu = new JMenu("Tabs");
        this.lineTerminationMenu = new JMenu("Line termination");
        this.viewMenu = new JMenu("View");
        this.helpMenu = new JMenu("Help");
        this.fileMenu.add(new JMenuItem(this.newAction));
        this.fileMenu.add(new JMenuItem(this.openAction));
        this.fileMenu.add(new JSeparator());
        this.fileMenu.add(new JMenuItem(this.closeAction));
        this.fileMenu.add(new JSeparator());
        this.fileMenu.add(new JMenuItem(this.saveAction));
        this.fileMenu.add(new JMenuItem(this.saveAsAction));
        this.fileMenu.add(new JSeparator());
        this.fileMenu.add(new JMenuItem(this.pageSetupAction));
        this.fileMenu.add(new JMenuItem(this.printAction));
        this.fileMenu.add(new JSeparator());
        this.fileMenu.add(new JMenuItem(exitAction));
        this.editMenu.add(new JMenuItem(RSyntaxTextArea.getAction(6)));
        this.editMenu.add(new JMenuItem(RSyntaxTextArea.getAction(4)));
        this.editMenu.add(new JSeparator());
        this.editMenu.add(new JMenuItem(RSyntaxTextArea.getAction(1)));
        this.editMenu.add(new JMenuItem(RSyntaxTextArea.getAction(0)));
        this.editMenu.add(new JMenuItem(RSyntaxTextArea.getAction(3)));
        this.editMenu.add(new JSeparator());
        this.editMenu.add(new JMenuItem(this.findAction));
        this.editMenu.add(new JMenuItem(this.findNextAction));
        this.editMenu.add(new JMenuItem(this.replaceAction));
        this.editMenu.add(new JMenuItem(this.goToAction));
        this.editMenu.add(new JSeparator());
        this.tabsMenu.add(this.tabSizeAction);
        this.tabsMenu.add(this.emulatedTabs.createJCheckBoxMenuItem());
        this.tabsMenu.add(this.convertTabsToSpaces);
        this.tabsMenu.add(this.convertSpacesToTabs);
        this.editMenu.add(this.tabsMenu);
        this.lineTerminationMenu.add(this.pcTerminationStyle);
        this.lineTerminationMenu.add(this.unixTerminationStyle);
        this.editMenu.add(this.lineTerminationMenu);
        this.editMenu.add(new JSeparator());
        this.editMenu.add(new JMenuItem(this.completeCodeAction));
        this.editMenu.add(new JMenuItem(RSyntaxTextArea.getAction(5)));
        this.viewMenu.add(this.lineWrapAction.createJCheckBoxMenuItem());
        this.viewMenu.add(this.lineNumbersAction.createJCheckBoxMenuItem());
        this.viewMenu.add(this.whiteSpaceAction.createJCheckBoxMenuItem());
        this.viewMenu.add(this.highlightCurrentLineAction.createJCheckBoxMenuItem());
        this.helpMenu.add(new JMenuItem(this.aboutAction));
        this.menuBar.add(this.fileMenu);
        this.menuBar.add(this.editMenu);
        this.menuBar.add(this.viewMenu);
        if (!Main.isMac() || !Main.runsStandalone) {
            this.menuBar.add(this.helpMenu);
        }
        this.setJMenuBar(this.menuBar);
        ActionListener terminationStyleListner = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JTextPad.this.updateStatusBar();
            }
        };
        this.pcTerminationStyle.addActionListener(terminationStyleListner);
        this.unixTerminationStyle.addActionListener(terminationStyleListner);
        this.textScroller = new RTextScrollPane(800, 500, this.textArea, true);
        this.textArea.restoreDefaultSyntaxHighlightingColorScheme();
        this.textArea.setSyntaxEditingStyle("text/plain");
        this.textArea.setLineWrap(true);
        try {
            this.provider.loadFromXML(JTextPad.class.getResourceAsStream("jalbum.xml"));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        this.provider.setListCellRenderer(new DefaultListCellRenderer(){
            private final Color brown = new Color(140, 110, 50);
            private final Color darkGreen = new Color(50, 140, 50);

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component comp = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (!isSelected) {
                    if (value instanceof MarkupTagCompletion) {
                        comp.setForeground(Color.blue);
                    } else if (value instanceof VariableCompletion) {
                        comp.setForeground(this.darkGreen);
                    }
                }
                return comp;
            }
        });
        this.autoCompletion = new AutoCompletion(this.provider){

            protected String getReplacementText(Completion c, Document doc, int start, int len) {
                try {
                    if (start >= 2 && "${".equals(doc.getText(start - 2, 2)) && !JTextPad.this.endsWithCurlyBrace(doc, start)) {
                        return c.getReplacementText() + "}";
                    }
                    return super.getReplacementText(c, doc, start, len);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
        };
        this.autoCompletion.setShowDescWindow(true);
        this.autoCompletion.setDescriptionWindowSize(400, 400);
        this.autoCompletion.setExternalURLHandler(new ExternalURLHandler(){

            public void urlClicked(URL url) {
                System.out.println("URL clicked: " + url.toString());
                try {
                    BrowserLauncher.openURL(url.toString());
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(JTextPad.this, "Can't open URL: " + ex.getMessage(), JTextPad.APP_NAME, 0);
                }
            }
        });
        this.autoCompletion.install(this.textArea);
        this.textArea.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent e) {
                JTextPad.this.updateStatusBar();
            }
        });
        final Thread changeChecker = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            32 var1_1 = this;
                            synchronized (var1_1) {
                                this.wait();
                            }
                            32.sleep(200L);
                            boolean changed = JTextPad.this.undoAction.isEnabled();
                            JTextPad.this.getRootPane().putClientProperty("Window.documentModified", "" + changed);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
        };
        changeChecker.start();
        this.textArea.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                this.check();
            }

            public void removeUpdate(DocumentEvent e) {
                this.check();
            }

            public void changedUpdate(DocumentEvent e) {
                this.check();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void check() {
                Thread thread = changeChecker;
                synchronized (thread) {
                    changeChecker.notify();
                }
            }
        });
        this.add((Component)this.textScroller, "Center");
        JPanel southPanel = new JPanel(new BorderLayout());
        southPanel.setBorder(BorderFactory.createEmptyBorder(0, 6, 2, 6));
        southPanel.add((Component)this.statusBar, "Before");
        southPanel.add((Component)new JLabel(" "), "After");
        this.statusBar.setText("no text");
        this.add((Component)southPanel, "South");
        this.pack();
        this.textArea.requestFocusInWindow();
    }

    private boolean endsWithCurlyBrace(Document doc, int offset) throws BadLocationException {
        char[] chars;
        int len = doc.getLength();
        int remaining = len - offset;
        if (remaining > 100) {
            remaining = 100;
        }
        String text = doc.getText(offset, remaining);
        for (char c : chars = text.toCharArray()) {
            if (c == '}') {
                return true;
            }
            if (Character.isJavaIdentifierPart(c)) continue;
            return false;
        }
        return false;
    }

    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            this.closeAction.actionPerformed(null);
        } else {
            super.processWindowEvent(e);
        }
    }

    static {
        fileTypes.put("txt", "text/plain");
        fileTypes.put("jsp", "text/jsp");
        fileTypes.put("htt", "text/jsp");
        fileTypes.put("inc", "text/jsp");
        fileTypes.put("java", "text/java");
        fileTypes.put("bsh", "text/java");
        fileTypes.put("css", "text/css");
        fileTypes.put("xml", "text/xml");
        fileTypes.put("info", "text/xml");
        fileTypes.put("rss", "text/xml");
        fileTypes.put("html", "text/html");
        fileTypes.put("htm", "text/html");
        fileTypes.put("xhtml", "text/html");
        fileTypes.put("properties", "text/properties");
        fileTypes.put("jap", "text/properties");
        fileTypes.put("js", "text/javascript");
        windows = new ArrayList<JTextPad>();
        editors = new HashMap<File, JTextPad>();
        lastLocation = new Point(80, 80);
        exitAction = new AbstractAction("Exit"){
            {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(81, menuShortcutKeyMask));
            }

            public void actionPerformed(ActionEvent e) {
                while (windows.size() > 0) {
                    JTextPad app = windows.get(0);
                    app.closeAction.actionPerformed(e);
                }
                if (Main.runsStandalone) {
                    System.exit(0);
                }
            }
        };
    }
}

