/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.jalbum;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import se.datadosen.explorer.JAlbumExplorer;
import se.datadosen.jalbum.Actions;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.AlbumObjectFactory;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.PluginContext;

public class JAlbumContext {
    private AlbumBean engine;
    private JAlbumFrame frame;
    private JAlbumExplorer explorer;
    private Actions actions;
    private AlbumObjectFactory albumObjectfactory;
    private PluginContext pluginContext;
    private PropertyChangeSupport changeSupport;
    private static JAlbumContext theInstance;

    private JAlbumContext() {
    }

    public static JAlbumContext getInstance() {
        if (theInstance == null) {
            theInstance = new JAlbumContext();
        }
        return theInstance;
    }

    static JAlbumContext getInstance(JAlbumFrame frame) {
        if (theInstance == null) {
            theInstance = new JAlbumContext();
        }
        theInstance.setFrame(frame);
        return theInstance;
    }

    public AlbumBean getEngine() {
        return this.engine;
    }

    public void setEngine(AlbumBean aEngine) {
        AlbumBean old = this.engine;
        this.engine = aEngine;
        this.firePropertyChange("engine", old, this.engine);
    }

    public JAlbumFrame getFrame() {
        return this.frame;
    }

    public void setFrame(JAlbumFrame aFrame) {
        JAlbumFrame old = this.frame;
        this.frame = aFrame;
        this.firePropertyChange("frame", old, this.frame);
    }

    public JAlbumExplorer getExplorer() {
        return this.explorer;
    }

    public Actions getActions() {
        if (this.actions == null) {
            this.actions = new Actions(this);
        }
        return this.actions;
    }

    public PluginContext getPluginContext() {
        if (this.pluginContext == null) {
            this.pluginContext = new PluginContext(this);
        }
        return this.pluginContext;
    }

    public File getSkinDir() {
        return Config.getConfig().chainedSkinsDir.getFile(this.engine.getSkin());
    }

    public void setExplorer(JAlbumExplorer aExplorer) {
        JAlbumExplorer old = this.explorer;
        this.explorer = aExplorer;
        this.firePropertyChange("explorer", old, this.explorer);
    }

    public AlbumObjectFactory getAlbumObjectfactory() {
        return this.albumObjectfactory;
    }

    public void setAlbumObjectfactory(AlbumObjectFactory aoFactory) {
        AlbumObjectFactory old = this.albumObjectfactory;
        this.albumObjectfactory = aoFactory;
        this.firePropertyChange("albumObjectFactory", old, this.albumObjectfactory);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null || this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public synchronized void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(propertyName, listener);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.changeSupport == null) {
            return;
        }
        this.changeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }
}

