/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.explorer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.jalbum.filterManager.FilterList;
import se.datadosen.explorer.JExplorerPanel;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.Icons;
import se.datadosen.jalbum.JAlbumBorders;
import se.datadosen.jalbum.Msg;
import se.datadosen.util.Platform;
import se.datadosen.util.annotations.ToolTipText;

public class JAlbumObject
extends JComponent
implements Transferable,
PropertyChangeListener {
    public static DataFlavor jAlbumObjectFlavor = new DataFlavor(JAlbumObject.class, "JAlbum object");
    private static Image excludedImage = new ImageIcon(JAlbumObject.class.getResource("images/forbidden.png")).getImage();
    private static ImageIcon defaultImageIcon;
    private static ImageIcon[] stars;
    public static final Font labelFont;
    private Image linkImage;
    public final AlbumObject ao;
    final JExplorerPanel explorer;
    private boolean selected;
    private boolean editing;
    private boolean rubberbanded;
    private boolean isMediaFile;
    private JPanel imagePanel = new JPanel();
    private JPanel buttonPanel = new JPanel(new FlowLayout(0, 1, 1));
    private JPanel statusPanel = new JPanel(new FlowLayout(2, 0, 1));
    private JLabel image;
    private JLabel label;
    private JTextField nameField;
    JPanel labelPanel;
    private boolean renderingDone = false;
    private boolean firstPaint = true;
    private JLabel isCommentedStatus = JAlbumObject.createStatusLabel(Icons.getIcon("small.message"));
    @ToolTipText(value="ui.isFolderThumbnailToolTip")
    private JLabel isFolderThumbnailStatus = JAlbumObject.createStatusLabel(Icons.getIcon("small.folder"));
    @ToolTipText(value="ui.isMediaFileToolTip")
    private JLabel isMediaFileStatus = JAlbumObject.createStatusLabel(Icons.getIcon("small.film"));
    @ToolTipText(value="ui.hasImageFiltersToolTip")
    private JLabel hasImageFiltersToolTip = JAlbumObject.createStatusLabel(Icons.getIcon("small.edited"));
    @ToolTipText(value="ui.hasOriginaToolTip")
    private JLabel hasOriginalStatus = JAlbumObject.createStatusLabel(Icons.getIcon("small.original"));
    private JLabel ratingStatus = JAlbumObject.createStatusLabel(null);

    private static JLabel createStatusLabel(Icon icon) {
        JLabel label = new JLabel(icon);
        label.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        return label;
    }

    private void updateStatusIcons() {
        AlbumObject rep;
        boolean isFolderThumbnail = false;
        if (this.explorer.context.currentFolder != null && (rep = this.explorer.context.currentFolder.getRepresentingAlbumObject()) != null && rep.equals(this.ao)) {
            isFolderThumbnail = true;
        }
        this.isFolderThumbnailStatus.setVisible(isFolderThumbnail);
        this.isCommentedStatus.setVisible(this.ao.getComment().length() > 0);
        Integer rating = (Integer)this.ao.getProperties().get("rating");
        if (rating != null && rating > 0 && rating <= 5) {
            if (this.ratingStatus == null) {
                throw new RuntimeException("APAAADSDSS");
            }
            if (this.ratingStatus.getIcon() != stars[rating - 1]) {
                this.ratingStatus.setIcon(stars[rating - 1]);
                this.ratingStatus.setToolTipText(Msg.get("ui.ratingToolTip", rating));
            }
            this.ratingStatus.setVisible(true);
        } else {
            this.ratingStatus.setVisible(false);
        }
        FilterList filterList = (FilterList)this.ao.getProperties().get("filterList");
        this.hasImageFiltersToolTip.setVisible(filterList != null && filterList.getPosition() > 0);
        this.isMediaFileStatus.setVisible(this.isMediaFile);
        Boolean includeOriginal = (Boolean)this.ao.getProperties().get("includeOriginal");
        this.hasOriginalStatus.setVisible(includeOriginal != null && includeOriginal != false);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        throw new NotSerializableException("JAlbum Objects are not serializable");
    }

    public JAlbumObject(final AlbumObject ao, JExplorerPanel context) {
        this.ao = ao;
        this.explorer = context;
        ao.addPropertyChangeListener(this);
        this.linkImage = Platform.isMac() ? new ImageIcon(JAlbumObject.class.getResource("images/link_mac.png")).getImage() : new ImageIcon(JAlbumObject.class.getResource("images/link.png")).getImage();
        this.setLayout(new BorderLayout());
        try {
            if (ao.isDisplayableImage()) {
                this.image = new JLabel(defaultImageIcon);
            } else {
                this.image = new JLabel(ao.getRepresentingIcon(context.iconBounds, false));
                this.renderingDone = true;
            }
        }
        catch (IOException ex) {
            this.image = new JLabel("No image");
            this.renderingDone = true;
        }
        this.image.setPreferredSize(context.iconBounds);
        this.image.setLayout(new BorderLayout());
        this.buttonPanel.setOpaque(false);
        this.statusPanel.setOpaque(false);
        this.statusPanel.add(this.isFolderThumbnailStatus);
        this.statusPanel.add(this.isMediaFileStatus);
        this.statusPanel.add(this.hasImageFiltersToolTip);
        this.statusPanel.add(this.ratingStatus);
        this.statusPanel.add(this.isCommentedStatus);
        this.statusPanel.add(this.hasOriginalStatus);
        this.statusPanel.add(Box.createHorizontalStrut(1));
        JPanel northPanel = new JPanel(new BorderLayout());
        northPanel.setOpaque(false);
        northPanel.add((Component)this.buttonPanel, "West");
        northPanel.add((Component)this.statusPanel, "East");
        this.image.add((Component)northPanel, "North");
        this.imagePanel.setLayout(new BorderLayout());
        this.imagePanel.setOpaque(false);
        this.imagePanel.add((Component)this.image, "Center");
        this.add((Component)this.imagePanel, "North");
        this.updateStatusIcons();
        this.label = new JLabel(ao.getName());
        this.label.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                e.setSource(JAlbumObject.this);
                e.translatePoint(JAlbumObject.this.labelPanel.getX(), JAlbumObject.this.labelPanel.getY());
                JAlbumObject.this.explorer.context.mouseOnComponentAdapter.mousePressed(e);
            }

            public void mouseReleased(MouseEvent e) {
                e.setSource(JAlbumObject.this);
                e.translatePoint(JAlbumObject.this.labelPanel.getX(), JAlbumObject.this.labelPanel.getY());
                JAlbumObject.this.explorer.context.mouseOnComponentAdapter.mouseReleased(e);
            }
        });
        this.label.setFont(labelFont);
        this.label.setOpaque(true);
        this.label.setHorizontalAlignment(0);
        int labelW = context.iconBounds.width;
        int labelH = this.label.getPreferredSize().height;
        this.label.setPreferredSize(new Dimension(labelW, labelH));
        this.nameField = new JTextField();
        this.nameField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                JAlbumObject.this.setEditing(false);
            }
        });
        this.nameField.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent ke) {
                if (ke.getKeyCode() == 27) {
                    JAlbumObject.this.nameField.setText(ao.getName());
                    JAlbumObject.this.setEditing(false);
                }
            }
        });
        if (!Platform.isMac()) {
            this.nameField.setFont(this.label.getFont());
        }
        this.nameField.setText(this.label.getText());
        int nameFieldW = context.iconBounds.width;
        int nameFieldH = this.nameField.getPreferredSize().height;
        this.nameField.setPreferredSize(new Dimension(nameFieldW, nameFieldH));
        this.labelPanel = new JPanel();
        FlowLayout fl = new FlowLayout(1, 0, 3);
        this.labelPanel.setLayout(fl);
        this.labelPanel.setOpaque(false);
        this.labelPanel.add(this.label);
        int maxWidth = Math.max(this.label.getPreferredSize().width, this.nameField.getPreferredSize().width);
        int maxHeight = Math.max(this.label.getPreferredSize().height, this.nameField.getPreferredSize().height);
        this.labelPanel.setPreferredSize(new Dimension(maxWidth, maxHeight + 3));
        this.add((Component)this.labelPanel, "Center");
        this.setSelected(this.selected);
        File rep = ao.getRepresentingIconFile();
        if (rep != null && rep.getName().toLowerCase().endsWith(".thm")) {
            this.isMediaFile = true;
        }
        Msg.setTexts(this);
    }

    void attachEditButton(JButton editButton) {
        if (this.buttonPanel.getComponentCount() > 0 && editButton == this.image.getComponent(0)) {
            editButton.setVisible(true);
            return;
        }
        Container c = editButton.getParent();
        if (c != null) {
            c.remove(editButton);
        }
        this.buttonPanel.add(editButton);
        editButton.setVisible(true);
    }

    void renderIcon() {
        try {
            this.image.setIcon(this.ao.getRepresentingIcon(this.explorer.iconBounds, false));
            this.renderingDone = true;
        }
        catch (IOException ex) {
            this.image.setText("Broken");
            this.renderingDone = true;
        }
    }

    public void paintChildren(Graphics g) {
        if (this.firstPaint) {
            this.updateToolTip();
            this.firstPaint = false;
        }
        Graphics2D g2d = (Graphics2D)g;
        super.paintChildren(g);
        this.updateStatusIcons();
        if (this.ao.isLink()) {
            int ypos = this.image.getHeight() - this.linkImage.getHeight(null);
            g2d.drawImage(this.linkImage, 2, ypos, null);
        }
        if (!this.ao.isIncluded()) {
            g2d.drawImage(excludedImage, (this.image.getWidth() - excludedImage.getWidth(null)) / 2, (this.image.getHeight() - excludedImage.getHeight(null)) / 2, null);
        }
    }

    public boolean isSelected() {
        return this.selected;
    }

    boolean isEditing() {
        return this.editing;
    }

    void setEditing(boolean editing) {
        if (this.editing == editing) {
            return;
        }
        this.editing = editing;
        if (editing) {
            this.labelPanel.removeAll();
            this.labelPanel.add(this.nameField);
            this.nameField.setText(this.ao.getName());
            this.nameField.setSelectionStart(0);
            this.nameField.setSelectionEnd(this.ao.getName().length());
            this.labelPanel.validate();
            this.nameField.requestFocusInWindow();
        } else {
            String newName = this.nameField.getText();
            if (!newName.equals(this.ao.getName())) {
                this.setLabel(newName);
            }
            this.label.setText(this.ao.getName());
            this.labelPanel.removeAll();
            this.labelPanel.add(this.label);
            this.updateToolTip();
            this.labelPanel.validate();
            this.repaint();
        }
    }

    private void updateToolTip() {
        this.label.setToolTipText(this.ao.getName());
        String comment = this.ao.getComment();
        if (!this.ao.getFile().exists()) {
            this.setToolTipText(Msg.get("edit.brokenLinkError", this.ao.getFile()));
        } else {
            this.setToolTipText(this.ao.getFile().toString());
            if (comment != null && comment.length() > 0) {
                this.isCommentedStatus.setToolTipText("<html><body>" + this.ao.getComment() + "</body></html>");
            } else if (this.getToolTipText() != null) {
                this.isCommentedStatus.setToolTipText(null);
            }
        }
    }

    public void setLabel(String name) {
        String oldName = this.ao.getName();
        if (!this.ao.setName(name)) {
            Toolkit.getDefaultToolkit().beep();
        } else {
            this.firePropertyChange("label", oldName, name);
        }
    }

    public void setRubberbanded(boolean rubberbanded) {
        if (this.rubberbanded != rubberbanded) {
            this.setSelected(!this.selected);
        }
        this.rubberbanded = rubberbanded;
    }

    public void resetRubberbanded() {
        this.rubberbanded = false;
    }

    public boolean isIncluded() {
        return this.ao.isIncluded();
    }

    public void setIncluded(boolean included) {
        this.ao.setIncluded(included);
        this.repaint();
    }

    public void setSelected(boolean selected) {
        boolean oldSelected = this.selected;
        this.selected = selected;
        if (selected) {
            this.imagePanel.setBorder(JAlbumBorders.createSelectedImageBorder());
            this.label.setForeground(SystemColor.textHighlightText);
            this.label.setBackground(SystemColor.textHighlight);
        } else {
            this.setEditing(false);
            this.imagePanel.setBorder(JAlbumBorders.createImageBorder());
            this.label.setForeground(SystemColor.textText);
            this.label.setBackground(SystemColor.text);
        }
        if (selected != oldSelected) {
            this.explorer.selectionModel.objectSelected(this, selected);
        }
    }

    public Object getTransferData(DataFlavor flavor) {
        if (flavor.equals(jAlbumObjectFlavor)) {
            return this;
        }
        return null;
    }

    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] flavors = new DataFlavor[]{jAlbumObjectFlavor};
        return flavors;
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return true;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("comment".equals(evt.getPropertyName())) {
            this.updateToolTip();
        } else if ("name".equals(evt.getPropertyName())) {
            this.label.setText(this.ao.getName());
        } else if ("orientation".equals(evt.getPropertyName())) {
            this.renderIcon();
            this.validate();
        } else if ("imageUpdated".equals(evt.getPropertyName())) {
            this.renderIcon();
            this.validate();
        } else if ("linkRepaired".equals(evt.getPropertyName())) {
            this.renderIcon();
            this.updateToolTip();
            this.validate();
        }
    }

    public String toString() {
        return this.getClass().getName() + " [name=" + this.ao.getName() + "]";
    }

    public boolean isRenderingDone() {
        return this.renderingDone;
    }

    public static Image getCrossImage() {
        return excludedImage;
    }

    static {
        stars = new ImageIcon[5];
        for (int i = 1; i <= 5; ++i) {
            JAlbumObject.stars[i - 1] = Icons.getIcon("small.star" + i);
        }
        try {
            defaultImageIcon = new ImageIcon(new File(Config.getConfig().progDir, "res/img.gif").toURL());
        }
        catch (Exception exception) {
            // empty catch block
        }
        labelFont = new Font("SansSerif", 0, 11);
    }
}

