/*
 * Decompiled with CFR 0.152.
 */
package se.datadosen.component;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import se.datadosen.component.JColorSelector;

public abstract class StateMonitor
implements ItemListener,
DocumentListener,
PropertyChangeListener {
    protected Object source;

    public StateMonitor add(JCheckBox comp) {
        comp.addItemListener(this);
        return this;
    }

    public StateMonitor add(JRadioButton comp) {
        comp.addItemListener(this);
        return this;
    }

    public StateMonitor add(JComboBox comp) {
        comp.addItemListener(this);
        return this;
    }

    public StateMonitor add(JTextComponent comp) {
        comp.getDocument().addDocumentListener(this);
        return this;
    }

    public StateMonitor add(JColorSelector comp) {
        comp.addPropertyChangeListener("color", this);
        return this;
    }

    public Object getSource() {
        return this.source;
    }

    public abstract void onChange();

    public void done() {
        this.onChange();
    }

    public static void enable(boolean test, JComponent comp) {
        StateMonitor.enable(test, new JComponent[]{comp});
    }

    public static void enable(boolean test, JComponent comp1, JComponent comp2) {
        StateMonitor.enable(test, new JComponent[]{comp1, comp2});
    }

    public static void enable(boolean test, JComponent comp1, JComponent comp2, JComponent comp3) {
        StateMonitor.enable(test, new JComponent[]{comp1, comp2, comp3});
    }

    public static void enable(boolean test, JComponent comp1, JComponent comp2, JComponent comp3, JComponent comp4) {
        StateMonitor.enable(test, new JComponent[]{comp1, comp2, comp3, comp3, comp4});
    }

    public static void enable(boolean test, JComponent comp1, JComponent comp2, JComponent comp3, JComponent comp4, JComponent comp5) {
        StateMonitor.enable(test, comp1, comp2, comp3, comp3, comp4, comp5);
    }

    public static void enable(boolean test, JComponent ... comps) {
        for (JComponent comp : comps) {
            comp.setEnabled(test);
        }
    }

    public void itemStateChanged(ItemEvent e) {
        this.source = e.getSource();
        this.onChange();
    }

    public void insertUpdate(DocumentEvent e) {
        this.source = e.getDocument();
        this.onChange();
    }

    public void removeUpdate(DocumentEvent e) {
        this.source = e.getDocument();
        this.onChange();
    }

    public void changedUpdate(DocumentEvent e) {
        this.source = e.getDocument();
        this.onChange();
    }

    public void propertyChange(PropertyChangeEvent e) {
        this.source = e.getSource();
        this.onChange();
    }
}

