<% 
// focallength.inc - Focal Length Calculation from cameras.properties
// Helper methods and variables/constants for 35mm focal length computation
import java.util.Map;
import java.util.*;
import java.text.*;
import se.datadosen.util.*; 

// Return true if the object's string representation is equivalent to an empty string.
public boolean isEmptyString(Object obj) {
	return ( obj==void || obj==null || obj.toString().trim().equals("") );
}

// Try to find the "cameras.properties" file.
Map cameraProperties = null;
try {
	cameraProperties = IO.readMapFile(new File(programDirectory, "system/cameras.properties"));
} catch (Exception e) {
	cameraProperties = null;
}

/**
 * Try to fetch metadata from a given key.
 * @param meta	The meta-information map for the given file.
 * @param key	The name of the key in the map.
 * @return the value corresponding with the given key, or null.
 */
public String getValueForKey(Map map, String key) {
	if (map == void || map == null)
		return null;
	if (map.containsKey(key) && map.get(key) != null) {
		return map.get(key).toString();
	}
	return null;
}

// Strip non-numeric ending on strings and convert result to float
float numericPart(String s) {
   int i;
   for (i=0; i<s.length(); i++) {
     char c = s.charAt(i);
     if (!Character.isDigit(c) && c != '.') break;
   }
   return Float.parseFloat(s.substring(0,i));
}

// Constructs the camera identifier from Make and Model Exif tags.
// The returned identifier is used as seach key in the "cameras.properties" file.
String getCameraIdentifier() {
	String model = getValueForKey(meta, "Model");
	String make = getValueForKey(meta, "Make");

	if ( isEmptyString(make) ) {
		if ( isEmptyString(model) ) {
			return null;
		} else {
			return model;
		}
	} else {
		if ( isEmptyString(model) ) {
			return make;
		}
	}

	if ( model.startsWith(make) )
		return model;
	else
		return make + " " + model;
}

// 35mm focus helper method.
// Retrieve the 35mm equivalent focus multiplier.
double getCamera35mmFocalMultiplier(String cameraIdentifier) {
	if ( isEmptyString(cameraIdentifier) ) {
		return 0.0;
	}
	String info = getValueForKey(cameraProperties, cameraIdentifier + ".focalLengthMultiplier");
	if (isEmptyString(info))
		return 0.0;
	return Double.parseDouble(info);
}

// Compute and return the 35mm focal length.
String cameraIdentifier = getCameraIdentifier();
multiplier = getCamera35mmFocalMultiplier(cameraIdentifier);
int newFocalLength = (int)(numericPart(focalLength) * multiplier); 
out.print(focalLength + "<br>("+ txt35mmEquivalent + ": " + newFocalLength + " mm)");

%>
