/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextarea;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JScrollPane;
import org.fife.ui.rtextarea.LineNumberBorder;
import org.fife.ui.rtextarea.LineNumberList;
import org.fife.ui.rtextarea.RTextArea;

public class RTextScrollPane
extends JScrollPane {
    public RTextArea textArea;
    private LineNumberList lineNumberList;
    private LineNumberBorder lineNumberBorder;
    private static final boolean usingLineNumberList = false;
    private boolean lineNumbersEnabled;

    public RTextScrollPane() {
        this(300, 300, null, true);
    }

    public RTextScrollPane(int n, int n2, RTextArea rTextArea, boolean bl) {
        this(n, n2, rTextArea, bl, Color.GRAY);
    }

    public RTextScrollPane(int n, int n2, RTextArea rTextArea, boolean bl, Color color) {
        super(rTextArea);
        this.setPreferredSize(new Dimension(n, n2));
        this.textArea = rTextArea;
        Font font = new Font("Monospaced", 0, 12);
        this.enableEvents(16L);
        this.lineNumberBorder = new LineNumberBorder(this, this.textArea, color);
        this.lineNumberBorder.setFont(font);
        this.setLineNumbersEnabled(bl);
        this.setVerticalScrollBarPolicy(22);
        this.setHorizontalScrollBarPolicy(30);
    }

    public boolean areLineNumbersEnabled() {
        return this.lineNumbersEnabled;
    }

    public Font getLineNumberFont() {
        return this.lineNumberBorder.getFont();
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getID() == 500) {
            int n = this.getViewport().getViewPosition().y + mouseEvent.getY();
            int n2 = this.textArea.viewToModel(new Point(0, n));
            this.textArea.setCaretPosition(n2);
        }
        super.processMouseEvent(mouseEvent);
    }

    public void setLineNumberFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("font cannot be null");
        }
        this.lineNumberBorder.setFont(font);
    }

    public void setLineNumbersEnabled(boolean bl) {
        if (bl != this.lineNumbersEnabled) {
            this.lineNumbersEnabled = bl;
            this.setViewportBorder(bl ? this.lineNumberBorder : null);
            this.revalidate();
        }
    }

    public void setViewportView(Component component) {
        if (!(component instanceof RTextArea)) {
            throw new IllegalArgumentException("view must be an RTextArea");
        }
        super.setViewportView(component);
        this.textArea = (RTextArea)component;
        if (this.lineNumberBorder != null) {
            this.lineNumberBorder.setTextArea(this.textArea);
        }
    }
}

