/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.autocomplete;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import org.fife.ui.autocomplete.AutoCompletePopupWindow;
import org.fife.ui.autocomplete.Completion;
import org.fife.ui.autocomplete.CompletionProvider;
import org.fife.ui.autocomplete.ExternalURLHandler;
import org.fife.ui.autocomplete.ParameterizedCompletion;
import org.fife.ui.autocomplete.ParameterizedCompletionDescriptionToolTip;

public class AutoCompletion
implements HierarchyListener {
    private JTextComponent textComponent;
    private Window parentWindow;
    private AutoCompletePopupWindow popupWindow;
    private Dimension preferredDescWindowSize;
    private ParameterizedCompletionDescriptionToolTip descToolTip;
    private CompletionProvider provider;
    private ListCellRenderer renderer;
    private ExternalURLHandler externalURLHandler;
    private boolean showDescWindow;
    private boolean autoCompleteEnabled;
    private boolean autoCompleteSingleChoices;
    private boolean parameterAssistanceEnabled;
    private KeyStroke trigger;
    private Object oldTriggerKey;
    private Action oldTriggerAction;
    private Object oldParenKey;
    private Action oldParenAction;
    private Listener parentWindowListener;
    private static final String PARAM_TRIGGER_KEY = "AutoComplete";
    private static final String PARAM_COMPLETE_KEY = "AutoCompletion.FunctionStart";
    private static final boolean DEBUG = AutoCompletion.initDebug();

    public AutoCompletion(CompletionProvider completionProvider) {
        this.setCompletionProvider(completionProvider);
        this.setTriggerKey(AutoCompletion.getDefaultTriggerKey());
        this.setAutoCompleteEnabled(true);
        this.setAutoCompleteSingleChoices(true);
        this.setShowDescWindow(false);
        this.parentWindowListener = new Listener();
    }

    private void displayDescriptionToolTip(ParameterizedCompletion parameterizedCompletion, boolean bl) {
        this.hideToolTipWindow();
        if (parameterizedCompletion.getParamCount() == 0) {
            CompletionProvider completionProvider = parameterizedCompletion.getProvider();
            String string = Character.toString(completionProvider.getParameterListEnd());
            if (bl) {
                string = completionProvider.getParameterListStart() + string;
            }
            this.textComponent.replaceSelection(string);
            return;
        }
        this.descToolTip = new ParameterizedCompletionDescriptionToolTip(this.parentWindow, this, parameterizedCompletion);
        try {
            int n = this.textComponent.getCaretPosition();
            Rectangle rectangle = this.textComponent.modelToView(n);
            Point point = new Point(rectangle.x, rectangle.y);
            SwingUtilities.convertPointToScreen(point, this.textComponent);
            rectangle.x = point.x;
            rectangle.y = point.y;
            this.descToolTip.setLocationRelativeTo(rectangle);
            this.descToolTip.setVisible(true, bl);
        }
        catch (BadLocationException badLocationException) {
            UIManager.getLookAndFeel().provideErrorFeedback(this.textComponent);
            badLocationException.printStackTrace();
        }
    }

    public void doCompletion() {
        this.refreshPopupWindow();
    }

    public boolean getAutoCompleteSingleChoices() {
        return this.autoCompleteSingleChoices;
    }

    public CompletionProvider getCompletionProvider() {
        return this.provider;
    }

    static boolean getDebug() {
        return DEBUG;
    }

    public static KeyStroke getDefaultTriggerKey() {
        int n = 2;
        return KeyStroke.getKeyStroke(32, n);
    }

    public ExternalURLHandler getExternalURLHandler() {
        return this.externalURLHandler;
    }

    int getLineOfCaret() {
        Document document = this.textComponent.getDocument();
        Element element = document.getDefaultRootElement();
        return element.getElementIndex(this.textComponent.getCaretPosition());
    }

    public ListCellRenderer getListCellRenderer() {
        return this.renderer;
    }

    protected String getReplacementText(Completion completion, Document document, int n, int n2) {
        return completion.getReplacementText();
    }

    public boolean getShowDescWindow() {
        return this.showDescWindow;
    }

    public JTextComponent getTextComponent() {
        return this.textComponent;
    }

    public KeyStroke getTriggerKey() {
        return this.trigger;
    }

    public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
        Window window = this.parentWindow;
        this.parentWindow = SwingUtilities.getWindowAncestor(this.textComponent);
        if (this.parentWindow != window) {
            if (window != null) {
                this.parentWindowListener.removeFrom(window);
            }
            if (this.parentWindow != null) {
                this.parentWindowListener.addTo(this.parentWindow);
            }
        }
    }

    public void hideChildWindows() {
        this.hidePopupWindow();
        this.hideToolTipWindow();
    }

    private void hidePopupWindow() {
        if (this.popupWindow != null && this.popupWindow.isVisible()) {
            this.popupWindow.setVisible(false);
        }
    }

    private void hideToolTipWindow() {
        if (this.descToolTip != null) {
            this.descToolTip.setVisible(false, false);
            this.descToolTip = null;
        }
    }

    private static final boolean initDebug() {
        boolean bl = false;
        try {
            bl = Boolean.getBoolean("AutoCompletion.debug");
        }
        catch (SecurityException securityException) {
            bl = false;
        }
        return bl;
    }

    void insertCompletion(Completion completion) {
        JTextComponent jTextComponent = this.getTextComponent();
        String string = completion.getAlreadyEntered(jTextComponent);
        this.hidePopupWindow();
        Caret caret = jTextComponent.getCaret();
        int n = caret.getDot();
        int n2 = string.length();
        int n3 = n - n2;
        String string2 = this.getReplacementText(completion, jTextComponent.getDocument(), n3, n2);
        caret.setDot(n3);
        caret.moveDot(n);
        jTextComponent.replaceSelection(string2);
        if (this.isParameterAssistanceEnabled() && completion instanceof ParameterizedCompletion) {
            ParameterizedCompletion parameterizedCompletion = (ParameterizedCompletion)completion;
            this.displayDescriptionToolTip(parameterizedCompletion, true);
        }
    }

    public void install(JTextComponent jTextComponent) {
        if (this.textComponent != null) {
            this.uninstall();
        }
        this.textComponent = jTextComponent;
        this.installTriggerKey(this.getTriggerKey());
        char c = this.provider.getParameterListStart();
        if (c != '\u0000') {
            InputMap inputMap = jTextComponent.getInputMap();
            ActionMap actionMap = jTextComponent.getActionMap();
            KeyStroke keyStroke = KeyStroke.getKeyStroke(c);
            this.oldParenKey = inputMap.get(keyStroke);
            inputMap.put(keyStroke, PARAM_COMPLETE_KEY);
            this.oldParenAction = actionMap.get(PARAM_COMPLETE_KEY);
            actionMap.put(PARAM_COMPLETE_KEY, new ParameterizedCompletionStartAction(c));
        }
        this.textComponent.addHierarchyListener(this);
        this.hierarchyChanged(null);
    }

    private void installTriggerKey(KeyStroke keyStroke) {
        InputMap inputMap = this.textComponent.getInputMap();
        this.oldTriggerKey = inputMap.get(keyStroke);
        inputMap.put(keyStroke, PARAM_TRIGGER_KEY);
        ActionMap actionMap = this.textComponent.getActionMap();
        this.oldTriggerAction = actionMap.get(PARAM_TRIGGER_KEY);
        actionMap.put(PARAM_TRIGGER_KEY, new AutoCompleteAction());
    }

    public boolean isAutoCompleteEnabled() {
        return this.autoCompleteEnabled;
    }

    public boolean isParameterAssistanceEnabled() {
        return this.parameterAssistanceEnabled;
    }

    private boolean isPopupVisible() {
        return this.popupWindow != null && this.popupWindow.isVisible();
    }

    protected int refreshPopupWindow() {
        final List list = this.provider.getCompletions(this.textComponent);
        int n = list.size();
        if (n > 1 || n == 1 && this.isPopupVisible() || n == 1 && !this.getAutoCompleteSingleChoices()) {
            if (this.popupWindow == null) {
                this.popupWindow = new AutoCompletePopupWindow(this.parentWindow, this);
                if (this.renderer != null) {
                    this.popupWindow.setListCellRenderer(this.renderer);
                }
                if (this.preferredDescWindowSize != null) {
                    this.popupWindow.setDescriptionWindowSize(this.preferredDescWindowSize);
                }
            }
            this.popupWindow.setCompletions(list);
            if (!this.popupWindow.isVisible()) {
                Rectangle rectangle = null;
                try {
                    rectangle = this.textComponent.modelToView(this.textComponent.getCaretPosition());
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                    return -1;
                }
                Point point = new Point(rectangle.x, rectangle.y);
                SwingUtilities.convertPointToScreen(point, this.textComponent);
                rectangle.x = point.x;
                rectangle.y = point.y;
                this.popupWindow.setLocationRelativeTo(rectangle);
                this.popupWindow.setVisible(true);
            }
        } else if (n == 1) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    AutoCompletion.this.insertCompletion((Completion)list.get(0));
                }
            });
        } else {
            this.hidePopupWindow();
        }
        return this.getLineOfCaret();
    }

    public void setAutoCompleteEnabled(boolean bl) {
        if (bl != this.autoCompleteEnabled) {
            this.autoCompleteEnabled = bl;
            this.hidePopupWindow();
        }
    }

    public void setAutoCompleteSingleChoices(boolean bl) {
        this.autoCompleteSingleChoices = bl;
    }

    public void setCompletionProvider(CompletionProvider completionProvider) {
        if (completionProvider == null) {
            throw new IllegalArgumentException("provider cannot be null");
        }
        this.provider = completionProvider;
        this.hidePopupWindow();
    }

    public void setDescriptionWindowSize(int n, int n2) {
        this.preferredDescWindowSize = new Dimension(n, n2);
        if (this.popupWindow != null) {
            this.popupWindow.setDescriptionWindowSize(this.preferredDescWindowSize);
        }
    }

    public void setExternalURLHandler(ExternalURLHandler externalURLHandler) {
        this.externalURLHandler = externalURLHandler;
    }

    public void setListCellRenderer(ListCellRenderer listCellRenderer) {
        this.renderer = listCellRenderer;
        if (this.popupWindow != null) {
            this.popupWindow.setListCellRenderer(listCellRenderer);
            this.hidePopupWindow();
        }
    }

    public void setParameterAssistanceEnabled(boolean bl) {
        this.parameterAssistanceEnabled = bl;
    }

    public void setShowDescWindow(boolean bl) {
        this.hidePopupWindow();
        this.showDescWindow = bl;
    }

    public void setTriggerKey(KeyStroke keyStroke) {
        if (keyStroke == null) {
            throw new IllegalArgumentException("trigger key cannot be null");
        }
        if (!keyStroke.equals(this.trigger)) {
            if (this.textComponent != null) {
                this.uninstallTriggerKey();
                this.installTriggerKey(keyStroke);
            }
            this.trigger = keyStroke;
        }
    }

    public void uninstall() {
        if (this.textComponent != null) {
            this.hidePopupWindow();
            this.uninstallTriggerKey();
            char c = this.provider.getParameterListStart();
            if (c != '\u0000') {
                KeyStroke keyStroke = KeyStroke.getKeyStroke(c);
                InputMap inputMap = this.textComponent.getInputMap();
                inputMap.put(keyStroke, this.oldParenKey);
                ActionMap actionMap = this.textComponent.getActionMap();
                actionMap.put(PARAM_COMPLETE_KEY, this.oldParenAction);
            }
            this.textComponent.removeHierarchyListener(this);
            if (this.parentWindow != null) {
                this.parentWindowListener.removeFrom(this.parentWindow);
            }
            this.textComponent = null;
            this.popupWindow = null;
        }
    }

    private void uninstallTriggerKey() {
        InputMap inputMap = this.textComponent.getInputMap();
        inputMap.put(this.trigger, this.oldTriggerKey);
        ActionMap actionMap = this.textComponent.getActionMap();
        actionMap.put(PARAM_TRIGGER_KEY, this.oldTriggerAction);
    }

    public void updateUI() {
        if (this.popupWindow != null) {
            this.popupWindow.updateUI();
        }
        if (this.descToolTip != null) {
            this.descToolTip.updateUI();
        }
    }

    private class ParameterizedCompletionStartAction
    extends AbstractAction {
        private String start;

        public ParameterizedCompletionStartAction(char c) {
            this.start = Character.toString(c);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AutoCompletion.this.hidePopupWindow();
            AutoCompletion.this.textComponent.replaceSelection(this.start);
            if (!AutoCompletion.this.isParameterAssistanceEnabled()) {
                return;
            }
            List list = AutoCompletion.this.provider.getParameterizedCompletions(AutoCompletion.this.textComponent);
            if (list != null && list.size() > 0) {
                ParameterizedCompletion parameterizedCompletion = (ParameterizedCompletion)list.get(0);
                AutoCompletion.this.displayDescriptionToolTip(parameterizedCompletion, false);
            }
        }
    }

    private class Listener
    extends ComponentAdapter
    implements WindowFocusListener {
        private Listener() {
        }

        public void addTo(Window window) {
            window.addComponentListener(this);
            window.addWindowFocusListener(this);
        }

        public void componentHidden(ComponentEvent componentEvent) {
            AutoCompletion.this.hideChildWindows();
        }

        public void componentMoved(ComponentEvent componentEvent) {
            AutoCompletion.this.hideChildWindows();
        }

        public void componentResized(ComponentEvent componentEvent) {
            AutoCompletion.this.hideChildWindows();
        }

        public void removeFrom(Window window) {
            window.removeComponentListener(this);
            window.removeWindowFocusListener(this);
        }

        public void windowGainedFocus(WindowEvent windowEvent) {
        }

        public void windowLostFocus(WindowEvent windowEvent) {
            AutoCompletion.this.hideChildWindows();
        }
    }

    class AutoCompleteAction
    extends AbstractAction {
        AutoCompleteAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (AutoCompletion.this.isAutoCompleteEnabled()) {
                AutoCompletion.this.refreshPopupWindow();
            } else if (AutoCompletion.this.oldTriggerAction != null) {
                AutoCompletion.this.oldTriggerAction.actionPerformed(actionEvent);
            }
        }
    }
}

