/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.autocomplete;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;
import org.fife.ui.autocomplete.AutoCompleteDescWindow;
import org.fife.ui.autocomplete.AutoCompletion;
import org.fife.ui.autocomplete.Completion;
import org.fife.ui.autocomplete.CompletionListModel;
import org.fife.ui.autocomplete.DelegatingCellRenderer;
import org.fife.ui.autocomplete.SizeGrip;

class AutoCompletePopupWindow
extends JWindow
implements CaretListener,
ListSelectionListener,
MouseListener {
    private AutoCompletion ac;
    private JList list;
    private CompletionListModel model;
    private AutoCompleteDescWindow descWindow;
    private Dimension preferredDescWindowSize;
    private boolean aboveCaret;
    private int lastLine;
    private KeyActionPair escapeKap;
    private KeyActionPair upKap;
    private KeyActionPair downKap;
    private KeyActionPair leftKap;
    private KeyActionPair rightKap;
    private KeyActionPair enterKap;
    private KeyActionPair tabKap;
    private KeyActionPair homeKap;
    private KeyActionPair endKap;
    private KeyActionPair pageUpKap;
    private KeyActionPair pageDownKap;
    private KeyActionPair ctrlCKap;
    private KeyActionPair oldEscape;
    private KeyActionPair oldUp;
    private KeyActionPair oldDown;
    private KeyActionPair oldLeft;
    private KeyActionPair oldRight;
    private KeyActionPair oldEnter;
    private KeyActionPair oldTab;
    private KeyActionPair oldHome;
    private KeyActionPair oldEnd;
    private KeyActionPair oldPageUp;
    private KeyActionPair oldPageDown;
    private KeyActionPair oldCtrlC;

    public AutoCompletePopupWindow(Window window, AutoCompletion autoCompletion) {
        super(window);
        this.ac = autoCompletion;
        this.model = new CompletionListModel();
        this.list = new JList(this.model);
        this.list.setCellRenderer(new DelegatingCellRenderer());
        this.list.addListSelectionListener(this);
        this.list.addMouseListener(this);
        JPanel jPanel = new JPanel(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(this.list, 22, 32);
        SizeGrip sizeGrip = new SizeGrip();
        boolean bl = this.getComponentOrientation().isLeftToRight();
        String string = bl ? "LOWER_RIGHT_CORNER" : "LOWER_LEFT_CORNER";
        jScrollPane.setCorner(string, sizeGrip);
        jPanel.add(jScrollPane);
        this.setContentPane(jPanel);
        this.pack();
        this.setFocusableWindowState(false);
        this.lastLine = -1;
    }

    public void caretUpdate(CaretEvent caretEvent) {
        if (this.isVisible()) {
            int n = this.ac.getLineOfCaret();
            if (n != this.lastLine) {
                this.lastLine = -1;
                this.setVisible(false);
            } else {
                this.doAutocomplete();
            }
        } else if (AutoCompletion.getDebug()) {
            Thread.dumpStack();
        }
    }

    private AutoCompleteDescWindow createDescriptionWindow() {
        AutoCompleteDescWindow autoCompleteDescWindow = new AutoCompleteDescWindow((Window)this, this.ac);
        Dimension dimension = this.preferredDescWindowSize;
        if (dimension == null) {
            dimension = this.getSize();
        }
        autoCompleteDescWindow.setSize(dimension);
        return autoCompleteDescWindow;
    }

    private void createKeyActionPairs() {
        EnterAction enterAction = new EnterAction();
        this.escapeKap = new KeyActionPair("Escape", new EscapeAction());
        this.upKap = new KeyActionPair("Up", new UpAction());
        this.downKap = new KeyActionPair("Down", new DownAction());
        this.leftKap = new KeyActionPair("Left", new LeftAction());
        this.rightKap = new KeyActionPair("Right", new RightAction());
        this.enterKap = new KeyActionPair("Enter", enterAction);
        this.tabKap = new KeyActionPair("Tab", enterAction);
        this.homeKap = new KeyActionPair("Home", new HomeAction());
        this.endKap = new KeyActionPair("End", new EndAction());
        this.pageUpKap = new KeyActionPair("PageUp", new PageUpAction());
        this.pageDownKap = new KeyActionPair("PageDown", new PageDownAction());
        this.ctrlCKap = new KeyActionPair("CtrlC", new CopyAction());
        this.oldEscape = new KeyActionPair();
        this.oldUp = new KeyActionPair();
        this.oldDown = new KeyActionPair();
        this.oldLeft = new KeyActionPair();
        this.oldRight = new KeyActionPair();
        this.oldEnter = new KeyActionPair();
        this.oldTab = new KeyActionPair();
        this.oldHome = new KeyActionPair();
        this.oldEnd = new KeyActionPair();
        this.oldPageUp = new KeyActionPair();
        this.oldPageDown = new KeyActionPair();
        this.oldCtrlC = new KeyActionPair();
    }

    protected void doAutocomplete() {
        this.lastLine = this.ac.refreshPopupWindow();
    }

    private static final KeyStroke getCopyKeyStroke() {
        int n = 67;
        int n2 = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        return KeyStroke.getKeyStroke(n, n2);
    }

    public ListCellRenderer getListCellRenderer() {
        DelegatingCellRenderer delegatingCellRenderer = (DelegatingCellRenderer)this.list.getCellRenderer();
        return delegatingCellRenderer.getFallbackCellRenderer();
    }

    public Completion getSelection() {
        return (Completion)this.list.getSelectedValue();
    }

    public void insertSelectedCompletion() {
        Completion completion = this.getSelection();
        this.ac.insertCompletion(completion);
    }

    private void installKeyBindings() {
        if (AutoCompletion.getDebug()) {
            System.out.println("PopupWindow: Installing keybindings");
        }
        if (this.escapeKap == null) {
            this.createKeyActionPairs();
        }
        JTextComponent jTextComponent = this.ac.getTextComponent();
        InputMap inputMap = jTextComponent.getInputMap();
        ActionMap actionMap = jTextComponent.getActionMap();
        this.replaceAction(inputMap, actionMap, 27, this.escapeKap, this.oldEscape);
        if (AutoCompletion.getDebug() && this.oldEscape.action == this.escapeKap.action) {
            Thread.dumpStack();
        }
        this.replaceAction(inputMap, actionMap, 38, this.upKap, this.oldUp);
        this.replaceAction(inputMap, actionMap, 37, this.leftKap, this.oldLeft);
        this.replaceAction(inputMap, actionMap, 40, this.downKap, this.oldDown);
        this.replaceAction(inputMap, actionMap, 39, this.rightKap, this.oldRight);
        this.replaceAction(inputMap, actionMap, 10, this.enterKap, this.oldEnter);
        this.replaceAction(inputMap, actionMap, 9, this.tabKap, this.oldTab);
        this.replaceAction(inputMap, actionMap, 36, this.homeKap, this.oldHome);
        this.replaceAction(inputMap, actionMap, 35, this.endKap, this.oldEnd);
        this.replaceAction(inputMap, actionMap, 33, this.pageUpKap, this.oldPageUp);
        this.replaceAction(inputMap, actionMap, 34, this.pageDownKap, this.oldPageDown);
        KeyStroke keyStroke = AutoCompletePopupWindow.getCopyKeyStroke();
        this.oldCtrlC.key = inputMap.get(keyStroke);
        inputMap.put(keyStroke, this.ctrlCKap.key);
        this.oldCtrlC.action = actionMap.get(this.ctrlCKap.key);
        actionMap.put(this.ctrlCKap.key, this.ctrlCKap.action);
        jTextComponent.addCaretListener(this);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2) {
            this.insertSelectedCompletion();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    private void positionDescWindow() {
        boolean bl;
        boolean bl2 = bl = this.descWindow != null && this.ac.getShowDescWindow();
        if (!bl) {
            return;
        }
        Dimension dimension = this.getToolkit().getScreenSize();
        int n = this.getX() + this.getWidth() + 5;
        if (n + this.descWindow.getWidth() > dimension.width) {
            n = this.getX() - 5 - this.descWindow.getWidth();
        }
        int n2 = this.getY();
        if (this.aboveCaret) {
            n2 = n2 + this.getHeight() - this.descWindow.getHeight();
        }
        if (n != this.descWindow.getX() || n2 != this.descWindow.getY()) {
            this.descWindow.setLocation(n, n2);
        }
    }

    private void putBackAction(InputMap inputMap, ActionMap actionMap, int n, KeyActionPair keyActionPair) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(n, 0);
        actionMap.put(inputMap.get(keyStroke), keyActionPair.action);
        inputMap.put(keyStroke, keyActionPair.key);
    }

    private void replaceAction(InputMap inputMap, ActionMap actionMap, int n, KeyActionPair keyActionPair, KeyActionPair keyActionPair2) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(n, 0);
        keyActionPair2.key = inputMap.get(keyStroke);
        inputMap.put(keyStroke, keyActionPair.key);
        keyActionPair2.action = actionMap.get(keyActionPair.key);
        actionMap.put(keyActionPair.key, keyActionPair.action);
    }

    private void selectFirstItem() {
        if (this.model.getSize() > 0) {
            this.list.setSelectedIndex(0);
            this.list.ensureIndexIsVisible(0);
        }
    }

    private void selectLastItem() {
        int n = this.model.getSize() - 1;
        if (n > -1) {
            this.list.setSelectedIndex(n);
            this.list.ensureIndexIsVisible(n);
        }
    }

    private void selectNextItem() {
        int n = this.list.getSelectedIndex();
        if (n > -1) {
            n = (n + 1) % this.model.getSize();
            this.list.setSelectedIndex(n);
            this.list.ensureIndexIsVisible(n);
        }
    }

    private void selectPageDownItem() {
        int n = this.list.getVisibleRowCount();
        int n2 = Math.min(this.list.getModel().getSize() - 1, this.list.getSelectedIndex() + n);
        this.list.setSelectedIndex(n2);
        this.list.ensureIndexIsVisible(n2);
    }

    private void selectPageUpItem() {
        int n = this.list.getVisibleRowCount();
        int n2 = Math.max(0, this.list.getSelectedIndex() - n);
        this.list.setSelectedIndex(n2);
        this.list.ensureIndexIsVisible(n2);
    }

    private void selectPreviousItem() {
        int n = this.list.getSelectedIndex();
        switch (n) {
            case 0: {
                n = this.list.getModel().getSize() - 1;
                break;
            }
            case -1: {
                n = this.list.getModel().getSize() - 1;
                if (n != -1) break;
                return;
            }
            default: {
                --n;
            }
        }
        this.list.setSelectedIndex(n);
        this.list.ensureIndexIsVisible(n);
    }

    public void setCompletions(List list) {
        this.model.setContents(list);
        this.selectFirstItem();
    }

    public void setDescriptionWindowSize(Dimension dimension) {
        if (this.descWindow != null) {
            this.descWindow.setSize(dimension);
        } else {
            this.preferredDescWindowSize = dimension;
        }
    }

    public void setListCellRenderer(ListCellRenderer listCellRenderer) {
        DelegatingCellRenderer delegatingCellRenderer = (DelegatingCellRenderer)this.list.getCellRenderer();
        delegatingCellRenderer.setFallbackCellRenderer(listCellRenderer);
    }

    public void setLocationRelativeTo(Rectangle rectangle) {
        int n;
        boolean bl = this.descWindow != null && this.ac.getShowDescWindow();
        Dimension dimension = this.getToolkit().getScreenSize();
        int n2 = this.getHeight();
        if (bl) {
            n2 = Math.max(n2, this.descWindow.getHeight());
        }
        this.aboveCaret = false;
        int n3 = rectangle.y + rectangle.height + 10;
        if (n3 + n2 > dimension.height) {
            n3 = rectangle.y - 10 - this.getHeight();
            this.aboveCaret = true;
        }
        if ((n = rectangle.x) < 0) {
            n = 0;
        } else if (n + this.getWidth() > dimension.width) {
            n = dimension.width - this.getWidth();
        }
        this.setLocation(n, n3);
        if (bl) {
            this.positionDescWindow();
        }
    }

    public void setVisible(boolean bl) {
        if (bl != this.isVisible()) {
            if (bl) {
                this.installKeyBindings();
                this.lastLine = this.ac.getLineOfCaret();
                this.selectFirstItem();
                if (this.descWindow == null && this.ac.getShowDescWindow()) {
                    this.descWindow = this.createDescriptionWindow();
                    this.positionDescWindow();
                    Completion completion = (Completion)this.list.getSelectedValue();
                    this.descWindow.setDescriptionFor(completion);
                }
            } else {
                this.uninstallKeyBindings();
            }
            super.setVisible(bl);
            if (this.descWindow != null) {
                this.descWindow.setVisible(bl && this.ac.getShowDescWindow());
            }
        }
    }

    public void uninstallKeyBindings() {
        if (AutoCompletion.getDebug()) {
            System.out.println("PopupWindow: Removing keybindings");
        }
        JTextComponent jTextComponent = this.ac.getTextComponent();
        InputMap inputMap = jTextComponent.getInputMap();
        ActionMap actionMap = jTextComponent.getActionMap();
        this.putBackAction(inputMap, actionMap, 27, this.oldEscape);
        this.putBackAction(inputMap, actionMap, 27, this.oldEscape);
        this.putBackAction(inputMap, actionMap, 38, this.oldUp);
        this.putBackAction(inputMap, actionMap, 40, this.oldDown);
        this.putBackAction(inputMap, actionMap, 37, this.oldLeft);
        this.putBackAction(inputMap, actionMap, 39, this.oldRight);
        this.putBackAction(inputMap, actionMap, 10, this.oldEnter);
        this.putBackAction(inputMap, actionMap, 9, this.oldTab);
        this.putBackAction(inputMap, actionMap, 36, this.oldHome);
        this.putBackAction(inputMap, actionMap, 35, this.oldEnd);
        this.putBackAction(inputMap, actionMap, 33, this.oldPageUp);
        this.putBackAction(inputMap, actionMap, 34, this.oldPageDown);
        KeyStroke keyStroke = AutoCompletePopupWindow.getCopyKeyStroke();
        actionMap.put(inputMap.get(keyStroke), this.oldCtrlC.action);
        inputMap.put(keyStroke, this.oldCtrlC.key);
        jTextComponent.removeCaretListener(this);
    }

    public void updateUI() {
        SwingUtilities.updateComponentTreeUI(this);
        if (this.descWindow != null) {
            this.descWindow.updateUI();
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        Object e;
        if (!listSelectionEvent.getValueIsAdjusting() && (e = this.list.getSelectedValue()) != null && this.descWindow != null) {
            this.descWindow.setDescriptionFor((Completion)e);
            this.positionDescWindow();
        }
    }

    class UpAction
    extends AbstractAction {
        UpAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (AutoCompletePopupWindow.this.isVisible()) {
                AutoCompletePopupWindow.this.selectPreviousItem();
            }
        }
    }

    class RightAction
    extends AbstractAction {
        RightAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent;
            Caret caret;
            int n;
            if (AutoCompletePopupWindow.this.isVisible() && (n = (caret = (jTextComponent = AutoCompletePopupWindow.this.ac.getTextComponent()).getCaret()).getDot()) < jTextComponent.getDocument().getLength()) {
                caret.setDot(++n);
                if (jTextComponent.isVisible() && AutoCompletePopupWindow.this.lastLine != -1) {
                    AutoCompletePopupWindow.this.doAutocomplete();
                }
            }
        }
    }

    class PageUpAction
    extends AbstractAction {
        PageUpAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (AutoCompletePopupWindow.this.isVisible()) {
                AutoCompletePopupWindow.this.selectPageUpItem();
            }
        }
    }

    class PageDownAction
    extends AbstractAction {
        PageDownAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (AutoCompletePopupWindow.this.isVisible()) {
                AutoCompletePopupWindow.this.selectPageDownItem();
            }
        }
    }

    class LeftAction
    extends AbstractAction {
        LeftAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent;
            Caret caret;
            int n;
            if (AutoCompletePopupWindow.this.isVisible() && (n = (caret = (jTextComponent = AutoCompletePopupWindow.this.ac.getTextComponent()).getCaret()).getDot()) > 0) {
                caret.setDot(--n);
                if (jTextComponent.isVisible() && AutoCompletePopupWindow.this.lastLine != -1) {
                    AutoCompletePopupWindow.this.doAutocomplete();
                }
            }
        }
    }

    private static class KeyActionPair {
        public Object key;
        public Action action;

        public KeyActionPair() {
        }

        public KeyActionPair(Object object, Action action) {
            this.key = object;
            this.action = action;
        }
    }

    class HomeAction
    extends AbstractAction {
        HomeAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (AutoCompletePopupWindow.this.isVisible()) {
                AutoCompletePopupWindow.this.selectFirstItem();
            }
        }
    }

    class EscapeAction
    extends AbstractAction {
        EscapeAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (AutoCompletePopupWindow.this.isVisible()) {
                AutoCompletePopupWindow.this.setVisible(false);
            }
        }
    }

    class EnterAction
    extends AbstractAction {
        EnterAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (AutoCompletePopupWindow.this.isVisible()) {
                AutoCompletePopupWindow.this.insertSelectedCompletion();
            }
        }
    }

    class EndAction
    extends AbstractAction {
        EndAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (AutoCompletePopupWindow.this.isVisible()) {
                AutoCompletePopupWindow.this.selectLastItem();
            }
        }
    }

    class DownAction
    extends AbstractAction {
        DownAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (AutoCompletePopupWindow.this.isVisible()) {
                AutoCompletePopupWindow.this.selectNextItem();
            }
        }
    }

    class CopyAction
    extends AbstractAction {
        CopyAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = false;
            if (AutoCompletePopupWindow.this.descWindow != null && AutoCompletePopupWindow.this.descWindow.isVisible()) {
                boolean bl2 = bl = !AutoCompletePopupWindow.this.descWindow.copy();
            }
            if (bl) {
                AutoCompletePopupWindow.this.ac.getTextComponent().copy();
            }
        }
    }
}

