/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.editor;

import edu.stanford.ejalbert.BrowserLauncher;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import net.jalbum.editor.JTextPad;
import net.jalbum.editor.OperationCanceledException;
import org.fife.ui.autocomplete.AbstractCompletionProvider;
import org.fife.ui.autocomplete.BasicCompletion;
import se.datadosen.io.ChainedDirectory;
import se.datadosen.jalbum.Config;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.JAlbumPlugin;
import se.datadosen.jalbum.PluginContext;
import se.datadosen.util.IO;

public class JTextPadPlugin
implements JAlbumPlugin {
    private PluginContext context;
    private JAlbumFrame window;
    Action editSkinFiles = new AbstractAction("Edit skin files"){
        {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(69, JTextPad.menuShortcutKeyMask | 1));
        }

        public void actionPerformed(ActionEvent e) {
            File[] files;
            File skinDir = JTextPadPlugin.this.context.getJAlbumContext().getSkinDir();
            for (File f : files = skinDir.listFiles()) {
                String ext = IO.extensionOf(f).toLowerCase();
                if (!JTextPad.fileTypes.containsKey(ext)) continue;
                JTextPadPlugin.this.launchEditor(f);
            }
        }
    };
    Action openEmptyEditor = new AbstractAction("Open empty editor"){
        {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(69, JTextPad.menuShortcutKeyMask));
        }

        public void actionPerformed(ActionEvent e) {
            File skinDir = JTextPadPlugin.this.context.getJAlbumContext().getSkinDir();
            JTextPad tp = JTextPadPlugin.this.launchEditor(skinDir);
            tp.setCurrentDirectory(skinDir);
        }
    };
    Action createNewSkin = new AbstractAction("Create new skin"){

        public void actionPerformed(ActionEvent e) {
            String name = JOptionPane.showInputDialog((Component)JTextPadPlugin.this.window, (Object)"Please enter name for new skin");
            if (name == null) {
                return;
            }
            ChainedDirectory chainedSkinsDir = Config.getConfig().chainedSkinsDir;
            File newSkinDir = new File(chainedSkinsDir.getDirectory(), name);
            if (newSkinDir.exists()) {
                JOptionPane.showMessageDialog((Component)JTextPadPlugin.this.window, "Skin " + name + " already exists", "Create new skin", 0);
                return;
            }
            File sourceSkinDir = new File(Config.getConfig().skinsDir, "Minimal");
            if (!sourceSkinDir.exists()) {
                JOptionPane.showMessageDialog((Component)JTextPadPlugin.this.window, "Can't find skin Minimal to use as template for new skin creation", "Create new skin", 0);
                return;
            }
            try {
                newSkinDir.mkdir();
                IO.copyFile(sourceSkinDir, newSkinDir);
                ((JTextPadPlugin)JTextPadPlugin.this).window.mainSettingsPanel.scanSkins();
                JTextPadPlugin.this.window.ui2Engine();
                JTextPadPlugin.this.context.getJAlbumContext().getEngine().setSkin(name);
                JTextPadPlugin.this.window.engine2UI();
                int answer = JOptionPane.showConfirmDialog((Component)JTextPadPlugin.this.window, "Skin " + name + " created ok with Minimal skin as base.\nDo you want to edit it now?", "Create new skin", 0);
                if (answer == 0) {
                    JTextPadPlugin.this.editSkinFiles.actionPerformed(null);
                }
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog((Component)JTextPadPlugin.this.window, "Error creating new skin: " + ex.getMessage(), "Create new skin", 0);
            }
        }
    };
    Action packSkin = new AbstractAction("Pack as .jaskin file"){

        public void actionPerformed(ActionEvent e) {
            final String name = JTextPadPlugin.this.context.getJAlbumContext().getEngine().getSkin();
            final String packedName = name + ".jaskin";
            ((JTextPadPlugin)JTextPadPlugin.this).window.statusBar.setText("Packing skin " + name + " to " + packedName + "...");
            new Thread("Skin packer"){

                public void run() {
                    ChainedDirectory chainedSkinsDir = Config.getConfig().chainedSkinsDir;
                    File skinDir = chainedSkinsDir.getFile(name);
                    try {
                        File skinFile = new File(skinDir.getParentFile(), packedName);
                        ZipOutputStream zout = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(skinFile)));
                        this.packDir(skinDir, skinDir.getParentFile(), zout);
                        zout.finish();
                        zout.close();
                        ((JTextPadPlugin)JTextPadPlugin.this).window.statusBar.setText("Skin " + name + " packed as " + packedName);
                        BrowserLauncher.openLocal(skinDir.getParentFile());
                    }
                    catch (IOException ex) {
                        ((JTextPadPlugin)JTextPadPlugin.this).window.statusBar.setText("Skin " + name + " packing aborted due to error");
                        JOptionPane.showMessageDialog((Component)JTextPadPlugin.this.window, "Error packing skin: " + ex.getMessage(), "Pack skin", 0);
                    }
                }
            }.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void packDir(File dir, File rel, ZipOutputStream zout) throws IOException {
            byte[] buffer = new byte[65536];
            ZipEntry e = new ZipEntry(IO.relativePath(dir, rel) + '/');
            zout.putNextEntry(e);
            for (File f : dir.listFiles(new FileFilter(){

                public boolean accept(File test) {
                    String s = test.getName();
                    return !s.equals(".DS_Store") && !s.toLowerCase().equals(".svn") && !s.toLowerCase().equals(".cvs");
                }
            })) {
                if (f.isDirectory()) {
                    this.packDir(f, rel, zout);
                    continue;
                }
                e = new ZipEntry(IO.relativePath(f, rel));
                zout.putNextEntry(e);
                BufferedInputStream in = new BufferedInputStream(new FileInputStream(f));
                try {
                    int bytes;
                    while ((bytes = ((InputStream)in).read(buffer)) >= 0) {
                        zout.write(buffer, 0, bytes);
                    }
                    zout.closeEntry();
                }
                finally {
                    ((InputStream)in).close();
                }
            }
        }
    };
    Action deleteSkin = new AbstractAction("Delete selected skin"){

        public void actionPerformed(ActionEvent e) {
            JTextPadPlugin.this.window.ui2Engine();
            String name = JTextPadPlugin.this.context.getJAlbumContext().getEngine().getSkin();
            int answer = JOptionPane.showConfirmDialog((Component)JTextPadPlugin.this.window, "Are you sure you wish to delete the " + name + " skin?", "Delete selected skin", 0, 2);
            if (answer != 0) {
                return;
            }
            ChainedDirectory chainedSkinsDir = Config.getConfig().chainedSkinsDir;
            File skinDir = chainedSkinsDir.getFile(name);
            try {
                JTextPadPlugin.this.deleteDir(skinDir);
                ((JTextPadPlugin)JTextPadPlugin.this).window.mainSettingsPanel.scanSkins();
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog((Component)JTextPadPlugin.this.window, "Error deleting skin " + name + ": " + ex.getMessage(), "Delete selected skin", 0);
            }
        }
    };

    private JTextPad launchEditor(File f) {
        boolean alreadyExists = JTextPad.editors.containsKey(f);
        JTextPad tp = JTextPad.getEditor(f);
        if (!alreadyExists) {
            this.configureEditor(tp);
        }
        return tp;
    }

    private void deleteDir(File dir) throws IOException {
        File[] files;
        for (File f : files = dir.listFiles()) {
            if (f.isDirectory()) {
                this.deleteDir(f);
                continue;
            }
            f.delete();
        }
        dir.delete();
    }

    public void init(PluginContext context) {
        this.context = context;
        this.window = context.getJAlbumContext().getFrame();
        JMenu menu = new JMenu("Skin developer");
        menu.add(new JMenuItem(this.editSkinFiles));
        menu.add(new JMenuItem(this.openEmptyEditor));
        menu.addSeparator();
        menu.add(new JMenuItem(this.createNewSkin));
        menu.add(new JMenuItem(this.packSkin));
        menu.add(new JMenuItem(this.deleteSkin));
        context.addToolsMenuItem((JMenuItem)menu);
    }

    public void configureEditor(JTextPad tp) {
        AbstractCompletionProvider provider = tp.getCompletionProvider();
        this.context.getJAlbumContext().getFrame().ui2Engine();
        LinkedList<BasicCompletion> list = new LinkedList<BasicCompletion>();
        Map skinVars = this.context.getJAlbumContext().getEngine().getSkinVariables();
        Set entries = skinVars.entrySet();
        for (Map.Entry e : entries) {
            BasicCompletion cpl = new BasicCompletion(provider, e.getKey().toString(), this.context.getJAlbumContext().getEngine().getSkin(), "Sample value: " + e.getValue());
            list.add(cpl);
        }
        Map userVars = this.context.getJAlbumContext().getEngine().getUserVariables();
        entries = userVars.entrySet();
        for (Map.Entry e : entries) {
            BasicCompletion cpl = new BasicCompletion(provider, e.getKey().toString(), "User variable", "Sample value: " + e.getValue());
            list.add(cpl);
        }
        provider.addCompletions(list);
    }

    public boolean onExit() {
        try {
            JTextPad.exitAction.actionPerformed(null);
            return JTextPad.windows.size() == 0;
        }
        catch (OperationCanceledException operationCanceledException) {
            return false;
        }
    }
}

