/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xmp.impl;

import com.adobe.xmp.XMPDateTime;
import com.adobe.xmp.XMPException;
import com.adobe.xmp.impl.ISO8601Converter;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class XMPDateTimeImpl
implements XMPDateTime {
    private int year = 0;
    private int month = 0;
    private int day = 0;
    private int hour = 0;
    private int minute = 0;
    private int second = 0;
    private TimeZone timeZone = TimeZone.getTimeZone("UTC");
    private int nanoSeconds;

    public XMPDateTimeImpl() {
    }

    public XMPDateTimeImpl(Calendar calendar) {
        this.year = calendar.get(1);
        this.month = calendar.get(2) + 1;
        this.day = calendar.get(5);
        this.hour = calendar.get(11);
        this.minute = calendar.get(12);
        this.second = calendar.get(13);
        this.nanoSeconds = calendar.get(14) * 1000000;
        this.timeZone = calendar.getTimeZone();
    }

    public XMPDateTimeImpl(String string) throws XMPException {
        ISO8601Converter.parse(string, this);
    }

    public int getYear() {
        return this.year;
    }

    public void setYear(int n) {
        this.year = Math.min(Math.abs(n), 9999);
    }

    public int getMonth() {
        return this.month;
    }

    public void setMonth(int n) {
        this.month = n < 1 ? 1 : (n > 12 ? 12 : n);
    }

    public int getDay() {
        return this.day;
    }

    public void setDay(int n) {
        this.day = n < 1 ? 1 : (n > 31 ? 31 : n);
    }

    public int getHour() {
        return this.hour;
    }

    public void setHour(int n) {
        this.hour = Math.min(Math.abs(n), 23);
    }

    public int getMinute() {
        return this.minute;
    }

    public void setMinute(int n) {
        this.minute = Math.min(Math.abs(n), 59);
    }

    public int getSecond() {
        return this.second;
    }

    public void setSecond(int n) {
        this.second = Math.min(Math.abs(n), 59);
    }

    public int getNanoSecond() {
        return this.nanoSeconds;
    }

    public void setNanoSecond(int n) {
        this.nanoSeconds = n;
    }

    public int compareTo(Object object) {
        long l = this.getCalendar().getTimeInMillis() - ((XMPDateTime)object).getCalendar().getTimeInMillis();
        if (l != 0L) {
            return (int)(l % 2L);
        }
        l = this.nanoSeconds - ((XMPDateTime)object).getNanoSecond();
        return (int)(l % 2L);
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public Calendar getCalendar() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(this.year, this.month - 1, this.day, this.hour, this.minute, this.second);
        gregorianCalendar.set(14, this.nanoSeconds / 1000000);
        ((Calendar)gregorianCalendar).setTimeZone(this.timeZone);
        return gregorianCalendar;
    }

    public String getISO8601String() {
        return ISO8601Converter.render(this);
    }

    public String toString() {
        return this.getISO8601String();
    }
}

