/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.jprint;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import se.datadosen.jalbum.AlbumBean;
import se.datadosen.jalbum.AlbumImage;
import se.datadosen.jalbum.AlbumObject;
import se.datadosen.jalbum.JAlbumFrame;
import se.datadosen.jalbum.JAlbumPlugin;
import se.datadosen.jalbum.PluginContext;
import se.datadosen.util.Debug;

public class JPrintPlugin
implements JAlbumPlugin,
Printable {
    static final int menuShortcutKeyMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    private static final ImageIcon smallIcon = new ImageIcon(JPrintPlugin.class.getResource("images/printer16.png"));
    private static final ImageIcon bigIcon = new ImageIcon(JPrintPlugin.class.getResource("images/printer48.png"));
    private PluginContext context;
    private JAlbumFrame window;
    private List<AlbumObject> images;
    private int imagesPerPage = 1;
    JCheckBox rotateToFit = new JCheckBox("Rotate images to fit page", true);
    JCheckBox showFilenames = new JCheckBox("Show filenames");
    JCheckBox showCaptions = new JCheckBox("Show captions");
    PrinterJob printJob;
    PageFormat pageFormat;
    JDialog progressDialog;
    JLabel statusLabel = new JLabel("Initializing...");
    private Action printerSettingsAction = new AbstractAction("Printer Settings..."){

        public void actionPerformed(ActionEvent e) {
            JPrintPlugin.this.pageFormat = JPrintPlugin.this.printJob.pageDialog(JPrintPlugin.this.pageFormat);
        }
    };
    private Action openPrintSettingsAction = new AbstractAction("Print..."){
        {
            this.putValue("SmallIcon", smallIcon);
        }

        public void actionPerformed(ActionEvent e) {
            String printerSettings = "Printer settings...";
            String print = "Print...";
            int res = JOptionPane.showOptionDialog((Component)JPrintPlugin.this.window, new Object[]{JPrintPlugin.this.rotateToFit, JPrintPlugin.this.showFilenames, JPrintPlugin.this.showCaptions}, "Print settings", -1, -1, bigIcon, new Object[]{print, printerSettings}, print);
            if (res == 0) {
                JPrintPlugin.this.printAction.actionPerformed(e);
            } else if (res == 1) {
                JPrintPlugin.this.printerSettingsAction.actionPerformed(e);
            }
        }
    };
    private Action printAction = new AbstractAction("Print..."){

        public void actionPerformed(ActionEvent e) {
            JPrintPlugin.this.printJob.setPrintable(JPrintPlugin.this, JPrintPlugin.this.pageFormat);
            if (JPrintPlugin.this.printJob.printDialog()) {
                AlbumObject[] all;
                JPrintPlugin.this.images = new LinkedList();
                for (AlbumObject ao : all = JPrintPlugin.this.context.getSelectedAlbumObjects()) {
                    if (!ao.isDisplayableImage()) continue;
                    JPrintPlugin.this.images.add(ao);
                }
                Thread printThread = new Thread("Print thread"){

                    public void run() {
                        try {
                            JPrintPlugin.this.printJob.print();
                        }
                        catch (PrinterException pe) {
                            Debug.showFriendlyErrorDialog((Component)JPrintPlugin.this.window, (Throwable)pe);
                        }
                    }
                };
                JPrintPlugin.this.progressDialog = new JDialog((Frame)JPrintPlugin.this.window, "Print", true);
                JPanel content = new JPanel(new BorderLayout());
                content.setBorder(BorderFactory.createEmptyBorder(12, 16, 12, 16));
                content.add((Component)new JLabel(bigIcon), "West");
                JPrintPlugin.this.statusLabel.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
                content.add((Component)JPrintPlugin.this.statusLabel, "Center");
                JButton stopButton = new JButton("Stop");
                stopButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        JPrintPlugin.this.progressDialog.setVisible(false);
                    }
                });
                JPanel buttonPanel = new JPanel(new FlowLayout(1));
                buttonPanel.add(stopButton);
                JPrintPlugin.this.progressDialog.getRootPane().setDefaultButton(stopButton);
                content.add((Component)buttonPanel, "South");
                JPrintPlugin.this.progressDialog.getContentPane().add(content);
                content.setPreferredSize(new Dimension(250, 120));
                JPrintPlugin.this.progressDialog.pack();
                JPrintPlugin.this.progressDialog.setLocationRelativeTo((Component)JPrintPlugin.this.window);
                printThread.start();
                JPrintPlugin.this.progressDialog.setVisible(true);
                JPrintPlugin.this.progressDialog.dispose();
                JPrintPlugin.this.progressDialog = null;
            }
        }
    };

    public void init(PluginContext context) {
        this.context = context;
        this.window = context.getJAlbumContext().getFrame();
        this.printJob = PrinterJob.getPrinterJob();
        this.printJob.setJobName("Jalbum printing");
        this.pageFormat = this.printJob.defaultPage();
        this.pageFormat.setOrientation(0);
        context.addContextMenuItem(new JMenuItem(this.openPrintSettingsAction));
    }

    public boolean onExit() {
        return true;
    }

    private Dimension getScaledSize(Dimension imageDim, Dimension boundingBox) {
        double widthScale = (double)imageDim.width / (double)boundingBox.width;
        double heightScale = (double)imageDim.height / (double)boundingBox.height;
        double maxScale = Math.max(widthScale, heightScale);
        return new Dimension((int)((double)imageDim.width / maxScale), (int)((double)imageDim.height / maxScale));
    }

    private String getText(AlbumObject ao) {
        String comment;
        ArrayList<String> texts = new ArrayList<String>();
        if (this.showFilenames.isSelected()) {
            texts.add(ao.getName());
        }
        if (this.showCaptions.isSelected() && (comment = ao.getComment()).length() > 0) {
            texts.add(comment);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < texts.size(); ++i) {
            if (i > 0) {
                sb.append(" | ");
            }
            sb.append((String)texts.get(i));
        }
        if (sb.length() > 0) {
            return sb.toString();
        }
        return null;
    }

    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        int startIndex;
        if (this.progressDialog == null) {
            return 1;
        }
        if (pageIndex * this.imagesPerPage >= this.images.size()) {
            JDialog pd = this.progressDialog;
            if (pd != null) {
                pd.setVisible(false);
                pd.dispose();
                this.progressDialog = null;
            }
            return 1;
        }
        this.statusLabel.setText("Preparing page " + (pageIndex + 1));
        Dimension boundingBox = new Dimension((int)pageFormat.getImageableWidth(), (int)pageFormat.getImageableHeight());
        Graphics2D g = (Graphics2D)graphics;
        for (int i = startIndex = pageIndex * this.imagesPerPage; i < startIndex + this.imagesPerPage; ++i) {
            try {
                AlbumObject ao = this.images.get(i);
                AlbumBean engine = this.context.getJAlbumContext().getEngine();
                AlbumImage ai = new AlbumImage(ao.getFile(), engine);
                BufferedImage image = (BufferedImage)ai.getImage();
                try {
                    engine.init();
                    ai = ai.applyFilters(1);
                    ai = ai.applyFilters(2);
                    image = (BufferedImage)ai.getImage();
                }
                catch (Exception ex) {
                    ex.printStackTrace(System.err);
                }
                Dimension originalDim = new Dimension(image.getWidth(), image.getHeight());
                float boundingBoxRatio = (float)boundingBox.width / (float)boundingBox.height;
                float imageRatio = (float)originalDim.width / (float)originalDim.height;
                if (this.rotateToFit.isSelected() && (boundingBoxRatio > 1.0f && imageRatio < 1.0f || boundingBoxRatio < 1.0f && imageRatio > 1.0f)) {
                    int temp = boundingBox.width;
                    boundingBox.width = boundingBox.height;
                    boundingBox.height = temp;
                    g.rotate(1.5707963267948966, 0.0, 0.0);
                    if (imageRatio < 1.0f) {
                        g.translate(pageFormat.getImageableX(), -pageFormat.getPaper().getHeight() + pageFormat.getImageableY());
                    } else {
                        g.translate(pageFormat.getImageableY(), -pageFormat.getPaper().getWidth() + pageFormat.getImageableX());
                    }
                } else {
                    g.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
                }
                Dimension newDim = this.getScaledSize(originalDim, boundingBox);
                int yoff = (boundingBox.height - newDim.height) / 2;
                Dimension imageBox = (Dimension)boundingBox.clone();
                String text = this.getText(this.images.get(i));
                Font f = new Font("Dialog", 0, 14);
                g.setFont(f);
                FontMetrics fm = g.getFontMetrics();
                int fontHeight = fm.getMaxAscent() + fm.getMaxDescent();
                if (text != null) {
                    imageBox.height -= fontHeight;
                }
                Dimension imageDim = this.getScaledSize(originalDim, imageBox);
                int xoff = (boundingBox.width - imageDim.width) / 2;
                if (text != null) {
                    Rectangle2D r = f.getStringBounds(text, g.getFontRenderContext());
                    g.setColor(Color.black);
                    g.drawString(text, (float)((double)xoff + ((double)imageDim.width - r.getWidth()) / 2.0), (float)(yoff + imageDim.height + fm.getMaxAscent()));
                }
                g.drawImage(image, xoff, yoff, imageDim.width, imageDim.height, null);
                continue;
            }
            catch (IOException ex) {
                ex.printStackTrace(System.err);
            }
        }
        return 0;
    }
}

