/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.filters;

import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import javax.swing.ImageIcon;
import net.jalbum.filterManager.FilterProperties;
import net.jalbum.filters.BasicFilter;

public class SharpenFilterPlugin
extends BasicFilter {
    private static final long serialVersionUID = 1720559385062856569L;

    public SharpenFilterPlugin() {
        this.name = "Sharpen Filter";
        this.shortName = "Sharpen";
        this.icon = new ImageIcon(this.getClass().getResource("res/sharpen.png"));
        this.author = "David Fichtmueller";
        this.version = "1.0";
        this.description = "Make the image appear a little sharper.";
        this.category = FilterProperties.FilterCategory.OTHER;
        this.prescale = false;
        this.postscale = true;
    }

    public BufferedImage renderImage(BufferedImage bi) {
        Kernel kernel = new Kernel(3, 3, new float[]{0.0f, -0.3f, 0.0f, -0.3f, 2.2f, -0.3f, 0.0f, -0.3f, 0.0f});
        ConvolveOp op = new ConvolveOp(kernel, 1, null);
        bi = op.filter(bi, null);
        return bi;
    }
}

