/*
 * Decompiled with CFR 0.152.
 */
package net.jalbum.filters;

import java.awt.event.ActionEvent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import net.jalbum.filters.MultipleResizableCirclePanel;
import net.jalbum.filters.MultipleResizableObjectControl;
import se.datadosen.jalbum.Msg;

public class MultipleResizableCircleControl
extends MultipleResizableObjectControl {
    private static final long serialVersionUID = 7586624283212259387L;
    protected MultipleResizableCirclePanel multipleResizableCirclePanel;
    protected double Radius = 0.2;
    protected double Radius2 = 0.1;
    protected JTextField textX;
    protected JTextField textY;
    protected JTextField textRadius;
    protected JTextField textRadius2;

    public MultipleResizableCircleControl() {
    }

    public MultipleResizableCircleControl(MultipleResizableCirclePanel multipleResizableCirclePanel) {
        this.init(multipleResizableCirclePanel);
        this.addMultipleControls();
    }

    protected void addCircleControls() {
        this.textX = new JTextField(3);
        this.textY = new JTextField(3);
        this.textRadius = new JTextField(3);
        this.textRadius2 = new JTextField(3);
        this.textX.addActionListener(this);
        this.textY.addActionListener(this);
        this.textRadius.addActionListener(this);
        this.textRadius2.addActionListener(this);
        this.add("p", new JLabel(Msg.getString((Object)this, (String)"filters.focus.positionX")));
        this.add(this.textX);
        this.add("p", new JLabel(Msg.getString((Object)this, (String)"filters.focus.positionY")));
        this.add(this.textY);
        this.add("p", new JLabel(Msg.getString((Object)this, (String)"filters.focus.radius")));
        this.add(this.textRadius);
        if (this.multipleResizableCirclePanel.isShowRadius2()) {
            this.add("p", new JLabel(Msg.getString((Object)this, (String)"filters.focus.radius2")));
            this.add(this.textRadius2);
        }
    }

    protected void init(MultipleResizableCirclePanel multipleResizableCirclePanel) {
        this.multipleResizableCirclePanel = multipleResizableCirclePanel;
        super.init(multipleResizableCirclePanel);
    }

    public void update(double x, double y, double radius, double radius2) {
        this.X1 = x;
        this.textX.setText(Double.toString(x));
        this.Y1 = y;
        this.textY.setText(Double.toString(y));
        this.Radius = radius;
        this.textRadius.setText(Double.toString(radius));
        this.Radius2 = radius2;
        this.textRadius2.setText(Double.toString(radius2));
    }

    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        if (e.getSource() == this.textX) {
            try {
                int x = Integer.parseInt(this.textX.getText());
                if (x < 0) {
                    x = 0;
                } else if (x > this.objectWidth - 1) {
                    x = this.objectWidth - 1;
                }
                this.X1 = (double)x / (double)(this.objectWidth - 1);
            }
            catch (Exception exception) {}
        } else if (e.getSource() == this.textY) {
            try {
                int y = Integer.parseInt(this.textY.getText());
                if (y < 0) {
                    y = 0;
                } else if (y > this.objectHeight - 1) {
                    y = this.objectHeight - 1;
                }
                this.Y1 = (double)y / (double)(this.objectHeight - 1);
            }
            catch (Exception exception) {}
        } else if (e.getSource() == this.textRadius) {
            try {
                int radius = Integer.parseInt(this.textRadius.getText());
                if (radius < 0) {
                    radius = Math.abs(radius);
                }
                if (radius > Math.max(this.objectWidth, this.objectHeight) - 1) {
                    radius = Math.max(this.objectWidth, this.objectHeight) - 1;
                }
                this.Radius = (double)radius / (double)(this.objectWidth - 1);
            }
            catch (Exception exception) {}
        } else if (e.getSource() == this.textRadius2) {
            try {
                int radius2 = Integer.parseInt(this.textRadius2.getText());
                if (radius2 < 0) {
                    radius2 = Math.abs(radius2);
                }
                this.Radius2 = (double)radius2 > this.Radius * (double)Math.max(this.objectWidth - 1, this.objectHeight - 1) ? (double)Math.max(this.objectWidth - 1, this.objectHeight - 1) / (double)(this.objectWidth - 1) : (double)radius2;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!(e.getSource() != this.textX && e.getSource() != this.textY && e.getSource() != this.textRadius && e.getSource() != this.textRadius2 || this.multipleResizableCirclePanel.getResizableCircle().isInitial())) {
            this.textX.setText(Integer.toString((int)(this.X1 * (double)(this.objectWidth - 1))));
            this.textY.setText(Integer.toString((int)(this.Y1 * (double)(this.objectHeight - 1))));
            this.textRadius.setText(Integer.toString((int)(this.Radius * (double)(this.objectWidth - 1))));
            this.textRadius2.setText(Integer.toString((int)(this.Radius2 * (double)(this.objectWidth - 1))));
            this.multipleResizableCirclePanel.updateCircle(this.X1, this.Y1, this.Radius, this.Radius2);
        }
        if (!(e.getSource() != this.removeButton && e.getSource() != this.nextButton && e.getSource() != this.previousButton || this.multipleResizableCirclePanel.getResizableCircle().isInitial())) {
            this.textX.setText(Integer.toString((int)this.multipleResizableCirclePanel.getResizableCircle().getX1() * (this.objectWidth - 1)));
            this.textY.setText(Integer.toString((int)this.multipleResizableCirclePanel.getResizableCircle().getY1() * (this.objectHeight - 1)));
            this.textRadius.setText(Integer.toString((int)this.multipleResizableCirclePanel.getResizableCircle().getRadius() * (this.objectWidth - 1)));
            this.textRadius2.setText(Integer.toString((int)this.multipleResizableCirclePanel.getResizableCircle().getRadius2() * (this.objectWidth - 1)));
        }
    }

    public MultipleResizableCirclePanel getMultipleResizableCirclePanel() {
        return this.multipleResizableCirclePanel;
    }

    public void setMultipleResizableCirclePanel(MultipleResizableCirclePanel multipleResizableCirclePanel) {
        this.multipleResizableCirclePanel = multipleResizableCirclePanel;
    }

    public double getRadius() {
        return this.Radius;
    }

    public void setRadius(double radius) {
        this.update(this.X1, this.Y1, radius, this.Radius2);
    }

    public double getRadius2() {
        return this.Radius2;
    }

    public void setRadius2(double radius2) {
        this.update(this.X1, this.Y1, this.Radius, radius2);
    }
}

